#include "robot/sensor/encoder.hpp"
#include "utils/constants.hpp"

using namespace Robot::Sensor;
using namespace Utils::Constants;

/// Definir un encodeur, connecté sur les broches pin_chA et pin_chB.
/// @param pin_chA Nom ou numero du pin du canal A.
/// @param pin_chB Nom ou numero du pin du canal B.
/// @param points  Nombre de points par tour de roue.
Encoder :: Encoder ( PinName pin_chA, PinName pin_chB, float points )
: _count(0), _chA(pin_chA), _chB(pin_chB), _points(points) {
    // chA.mode( PullNone ); // Mode de pull: peut etre necessaire parfois.
    // chB.mode( PullNone ); //

    _chA.fall <Encoder> ( this , & Encoder :: chA_fall );
    _chA.rise <Encoder> ( this , & Encoder :: chA_rise );
    _chB.fall <Encoder> ( this , & Encoder :: chB_fall );
    _chB.rise <Encoder> ( this , & Encoder :: chB_rise );
}

//-----------------------------------------------------------------------------
/// Lire la valeur de comptage de l'encodeur et remet la valeur à 0.
/// @return Retourne la difference d'angle (en radian).
float Encoder :: read () {
    float alpha = (float)_count / _points * 2.0f * (float)PI;
    reset();
    return alpha;
}

//-----------------------------------------------------------------------------
/// Remet la valeur de comptage de l'encodeur à 0.
void Encoder :: reset () {
    _count = 0;
}

//-----------------------------------------------------------------------------
/// Fonction à declencher sur un front descendant de A.
void Encoder :: chA_fall () {
    if( _chB.read() ) _count ++; // Ajoute 1 si B à 1,
    else              _count --; // sinon -1.
}
/// Fonction à declencher sur un front montant de A.
void Encoder :: chA_rise () {
    if( _chB.read() ) _count --; // Ajoute 1 si B à 0,
    else              _count ++; // sinon -1.
}
/// Fonction à declencher sur un front descendant de B.
void Encoder :: chB_fall () {
    if( _chA.read() ) _count --; // Ajoute 1 si A à 0,
    else              _count ++; // sinon -1.
}
/// Fonction à declencher sur un front montant de B.
void Encoder :: chB_rise () {
    if( _chA.read() ) _count ++; // Ajoute 1 si A à 1,
    else              _count --; // sinon -1.
}
