#ifndef HPP__ROBOT
#define HPP__ROBOT
    
    #include "mbed.h"
    
    #include "robot/sensor/sensor.hpp"
    #include "robot/control/control.hpp"
    #include "utils/position.hpp"
    
    /// @namespace Robot
    /// Espace de nom reservé au robot.
    namespace Robot {
        
        /// @class Robot::Robot
        /// @brief Classe de description du robot et de controle du robot.
        /// Cette classe reunit tout les controles et les capteurs du robot.
        ///
        /// @b Exemple:
        /// @code
        /// #include "robot/robot.hpp"
        /// #include "mbed.h"
        ///
        /// using namespace Robot
        /// int main () {
        ///     Robot::Robot robot(
        ///         Control::Motor( // Moteur de droite.
        ///             Sensor::Encoder(pin1, pin2, 1024/*pt*/),
        ///             Control::Servo(pin5, 50.0/*Hz*/),
        ///             Utils::System(
        ///                 /*coef P*/,
        ///                 /*coef Q*/
        ///             ),
        ///             50.0/*Hz*/
        ///         ),
        ///         0.05/*m*/, // Rayon de la roue droite.
        ///         Control::Motor( // Moteur de gauche.
        ///             Sensor::Encoder(pin1, pin2, 1024/*pt*/),
        ///             Control::Servo(pin5, 50.0/*Hz*/),
        ///             Utils::System(
        ///                 /*coef P*/,
        ///                 /*coef Q*/
        ///             ),
        ///             50.0/*Hz*/
        ///         ),
        ///         0.05/*m*/, // Rayon de la roue gauche.
        ///         0.25/*m*/, // Distance entre les roues.
        ///         50.0/*Hz*/,// Frequence.
        ///     );
        /// 
        ///     robot.setSpeed( 0.1, 0.5 ); // 0.1 [m/s] , 0.5 [rad/s]
        /// 
        ///     while(true);
        /// }
        /// @endcode
        class Robot {
        protected:
            float _freq; ///< Frequence d'echantillonnage.
            float _dist; ///< Distance entre les 2 roues.
            float _radius_right; ///< Rayon de la roue de droite.
            float _radius_left;  ///< Rayon de la roue de droite.
            Control::Motor &_motor_right;///< Moteur droite
            Control::Motor &_motor_left; ///< Moteur gauche
            Ticker   _ticker;
            Utils::Position _pos; ///< Position du robot.
        public:
            Robot ( Control::Motor& motor_right, float radius_right,
                    Control::Motor& motor_left , float radius_left ,
                    float dist, float freq );
            
            void asserv ();
            void write_speed(float, float);
            void write_speed(Utils::Speed&);
            Utils::Speed    read_speed() const;
            Utils::Position read_position() const;
            
            void initialize ();
        };
        
    } /// @}
    
#endif
