#include "robot/robot.hpp"

namespace Robot {
    
    Robot::Robot (
        Control::Motor& motor_right, ///< Moteur de droite.
        float radius_right, ///< Rayon de la roue droite.
        Control::Motor& motor_left,  ///< Moteur de gauche.
        float radius_left,  ///< Rayon de la roue gauche.
        float dist, ///< Distance entre les 2 roues.
        float freq  ///< Frequence d'echantillonnage.
    ) :_freq(freq), _dist(dist), _radius_right(radius_right), _radius_left(radius_left),
    _motor_right(motor_right), _motor_left(motor_left), _pos() {
        _ticker.attach <Robot> ( this, & Robot :: asserv, 1/_freq );
    }
    
//-----------------------------------------------------------------------------
    void Robot::write_speed( float v, float w ) {
        _motor_right.write( v  +  w * _dist/2 );
        _motor_left .write( v  -  w * _dist/2 );
    }
    
//-----------------------------------------------------------------------------
/// Defini la vitesse du robot.
/// @param v Vitesse du robot.
    void Robot::write_speed( Utils::Speed &v ) {
        _motor_right.write( (v.v  +  v.w * _dist/2)/_radius_right );
        _motor_left .write( (v.v  -  v.w * _dist/2)/_radius_left  );
    }
    
//-----------------------------------------------------------------------------
/// Lire la vitesse reelle du robot.
/// @return Vitesse du robot.
    Utils::Speed Robot::read_speed( ) const {
        Utils::Speed v;
        float v_right = _motor_right.read()*_radius_right, ///< Vitesse de la roue droite.
              v_left  = _motor_left .read()*_radius_right; ///< Vitesse de la roue gauche.
        
        v.v = ( v_right + v_left ) / 2;
        v.w = ( v_right - v_left ) / _dist; // A verifier !
        
        return v;
    }
    
//-----------------------------------------------------------------------------
/// Lire la position reelle du robot.
/// @return Position du robot.
Utils::Position Robot::read_position () const {
    return this->_pos;
}

//-----------------------------------------------------------------------------
    void Robot::asserv () {
        _pos.add_speed( read_speed(), _freq );
    }
    
}
