#ifndef HPP__ROBOT_CONTROL_SERVO
#define HPP__ROBOT_CONTROL_SERVO

#include "mbed.h"
#include "robot/control/control.hpp"

/// @namespace Robot
namespace Robot {
    /// @namespace Robot::Control
    namespace Control {

        /// @class Robot::Control::Servo
        /// Permet de controller un servomoteur connecté sur la borche indiquée.
        /// @note La commande de servomoteur ce fait en envoyant une impuslion
        ///       d'une durée comprise entre 1ms et 2ms.
        ///       La durée de l'impulsion determine la commande.
        class Servo: public Robot::Control::Control {
        protected:
            PwmOut _out; ///< Broche PWM.
            float  _f;   ///< Frequence de la PWM (en general 50 ou 100Hz pour un servo).
            float  _min; ///< Valeur minimum du servo (0 par defaut).
            float  _max; ///< Valeur maximum du servo (100 par defaut).
        public:
            // Constructeurs
            Servo(PinName pin);
            Servo(PinName pin, float f);
            Servo(PinName pin, float f, float min, float max);
            Servo(PinName pin, float min, float max);
            
            // Fonctions
            virtual void write (float in);
            
            void set_min(float min);
            void set_max(float max);
            void set_frequency(float f);
        };

    }
}

#endif
