#ifndef HPP__ROBOT_CONTROL_MOTOR
#define HPP__ROBOT_CONTROL_MOTOR

#include "robot/sensor/sensor.hpp"
#include "robot/control/control.hpp"
#include "utils/utils.hpp"

/// @namespace Robot
namespace Robot {
    /// @namespace Robot::Control
    namespace Control {

        /// @class Robot::Control::Motor
        /// Classe permetant de controller un moteur CC.
        /// Le controle ce fait via un objet de type Control.
        /// (Exemple: Controller::Servo pour les drivers qui prennent une
        /// commande de type servomoteur)
        /// Le retour ce fait via un objet de type Sensor.
        /// (Exemple: Sensor::Encoder)
        /// 
        /// @b Exemple:
        ///
        /// @code
        /// #include "robot/control/control.hpp"
        /// using namespace Robot;
        /// int main () {
        ///     Sensor::Default    in;
        ///     Control::Servo  out;
        ///     Utils::System::System corrector(...);
        ///     float freq(50.0);
        ///     Control::Motor  motor(in, out, corrector, freq );
        /// 
        ///     motor.write ( 5.0 ); // [rad/s]
        ///     while(true);
        /// }
        /// @endcode
        /// 
        /// @author  VIANES Arthur
        /// @date    2016-01-07
        class Motor: public Robot::Control::Control {
        protected:
            Sensor::Sensor & _in;   ///< Capteur de vitesse.
            Control        & _out;  ///< Controle du moteur.
            float            _f;    ///< Frequence d'echantillonnage.
            volatile float   _speed;  ///< Commande en vitesse (en radian/s).
            volatile float   _mesure; ///< Vitesse réelle mesurée (en radian/s).
            Utils::System::System & _corrector; ///< Correcteur à appliquer au systeme.
            Ticker ticker;
            // Fonction interne
            void  sync_write ();
        public:
            // Contructor
            Motor(
                Robot::Sensor::Sensor&   sensor,
                Robot::Control::Control& control,
                Utils::System::System&   corrector,
                float freq
            );
            // Fonctions
            virtual float read ();
            virtual void  write ( float in );
        };
        class MotorDC : public Robot::Control::Control {
        protected:
            PwmOut     _IN;
            DigitalOut _DIR;
            DigitalOut _EN;
            float      _max;
        public:
            MotorDC ( PinName in1, PinName in2, PinName en, float freq );
            virtual void write (float in);
        };
    }
}

#endif
