#ifndef HPP__ROBOT_CONTROL
#define HPP__ROBOT_CONTROL
    
    /// @namespace Robot
    namespace Robot {
        /// @namespace Robot::Control
        /// Espace de nom reservé au controle du robot.
        namespace Control {
            
            /// @class Robot::Control::Control
            /// Classe permetant de definir un controlleur quelconque.
            class Control {
            public:
                /// Doit definir la valeur de commande du controlleur.
                /// @param in Ecrire la commande du controlleur.
                virtual void write( float in ) = 0;
            };
            
            /// @class Robot::Control::Default
            /// Controller par defaut (ne commande rien).
            class Default: public Control {
                /// Definir la valeur de commande du controlleur.
                /// @param in Ecrire la commande du controlleur.
                virtual void write (float in ) {};
            };
            
        }
    }
    
    // Inclure les fichiers header qui utilise la class Robot::Control::Control.
    #include "robot/control/motor.hpp"
    #include "robot/control/servo.hpp"
    
#endif
