#include "mbed.h"
#include "SLCD.h"
#include "InterruptManager.h"
#include "TPM_init.h"

#define TOTAL_SYNC 3
#define PI 3.1415926f

DigitalOut d_out(D2);
DigitalIn  d_in(D3);
InterruptIn d_IRQ(D3);

int temp_pulse_flag[TOTAL_SYNC];
int temp_pulse_tpm[TOTAL_SYNC];

int temp_sync_flag[TOTAL_SYNC];
int temp_sync_tpm[TOTAL_SYNC];

bool dbg = 0;
time_t seconds = time(NULL); // needed to start rtc on reset to maintain reasonable time if hard reset

SLCD slcd;
//Timer scroll;

Serial pc(USBTX, USBRX); // tx, rx
RawSerial rpi(USBTX, USBRX); // tx, rx
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut led_r(LED_RED);
DigitalOut  pps(D7);
AnalogIn lightSensor(PTE22);
//InterruptIn setmin (SW1);
//InterruptIn sethour (SW3);

//struct tm t;

//int i,j,k,lastscroll,display_timer,minute,hour,colon,dp;
int i;
char message[60];
//void scroll_message();
char buffer[32];

//void setminIRQ();
//void sethourIRQ();
void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 255;
// might need to increase buffer size for high baud rates
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
char temp_rx_buffer[2];
char str[6];
// Circular buffer pointers
// volatile makes read-modify-write atomic 
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];
unsigned int flag = 0;
unsigned int modulo_val = 48000;   //period = 1 ms

unsigned int new_sync_flag = 0;
unsigned int new_sync_tpm = 0;
unsigned int old_sync_flag = 0;
unsigned int old_sync_tpm = 0;
unsigned int sync_flag = 0;
unsigned int sync_tpm = 0;

unsigned int new_pulse_flag = 100;
unsigned int new_pulse_tpm = 0;
unsigned int old_pulse_flag = 100;
unsigned int old_pulse_tpm = 0;
unsigned int pulse_flag = 0;
unsigned int pulse_tpm = 0;

unsigned int new_arrival_flag = 0;
unsigned int new_arrival_tpm = 0;
unsigned int old_arrival_flag = 0;
unsigned int old_arrival_tpm = 0;
unsigned int arrival_flag = 0;
unsigned int arrival_tpm = 0;

unsigned int state = 0;
unsigned int pps_state = 0;

Ticker tick_DAC;
Ticker tick_test;
AnalogOut DAC(PTE30);

const long num_samp_per_sec = 10000;
const int freq_DAC[4] = {1,10,100,1000};
int count_ADC;
long count_DAC;
int sel_freq_DAC;
char ADC_string[6];
char final_string[7] = "V";
bool on_DAC;

AnalogIn in_0(A0);
//AnalogIn in_1(A1);
bool flag_for_d;

void sine_gen() {
    float tem = on_DAC? 0.5*sin(2*PI*freq_DAC[sel_freq_DAC]*count_DAC/num_samp_per_sec) + 0.5 : 0.0;
    //float temf = 0.1;
    //float tem = 0.5*sin(2*PI*temf*count_DAC/num_samp_per_sec) + 0.5;
    //if (count_DAC % 10 == 0) pc.printf("write%f\n",tem);
    DAC.write(tem);
    count_DAC += 1;
    if (count_DAC == num_samp_per_sec - 1) count_DAC = 0;
    //if (count_DAC == 10*num_samp_per_sec - 1) count_DAC = 0;
    count_ADC += 1;
    if (count_ADC == 10000)
    {
        //sprintf(str, "v%0.3f",in_0.read());
        //for(i=0; i<6; i++) rpi.putc(str[i]);
        //rpi.printf("V%0.3f",in_0.read());
        count_ADC = 0;
        }
}

void init() {
    d_out = false;
    flag_for_d = false;
    
    count_DAC = 0;
    count_ADC = 0;
    sel_freq_DAC = 0;
    on_DAC = true;
    led_r = true;
    //led_g = false;
}

void logichigh() {
    led_r=false;
    rpi.putc('H');
}
    
void logiclow() {
    led_r=true;
    rpi.putc('L');
}

int num_expire = 0;
void TPM0_handler() {
    unsigned int overflow = TPM0_SC_read() & 0x000000C0; 
    if(overflow == 0xC0) {
        TPM0_clear_overflow();
        flag++;
        if(state==0){
        if(pps_state == 0){
            if( sync_flag==0 && sync_tpm==0 ){
                pps = 1;
                pps_state = 1;
                if(dbg) pc.printf("pulse high!\n");
                TPM0_init(modulo_val);
                TPM0_start();
                //num_expire = 0;
            } else if ( sync_flag==0 ){
                //if(dbg) pc.printf("I shouldn't be here\n");
                TPM0_init(sync_tpm);
                TPM0_start();
                sync_tpm = 0;
            } else {
                sync_flag--;
            }
        }
        else {
            if( pulse_flag==0 && pulse_tpm==0 ){
                pps = 0;
                pps_state = 0;
                if(dbg) pc.printf("pulse low!\n");
                TPM0_init(modulo_val);
                //TPM0_start();
                state = 1;
            } else if ( pulse_flag==0 ){
                //if(dbg) pc.printf("I shouldn't be here\n");
                TPM0_init(pulse_tpm);
                TPM0_start();
                pulse_tpm = 0;
            } else {
                pulse_flag--;
            }            
        }
        } else if (state == 1){
        }          
        //if(dbg) pc.printf("flag = %d\n", flag);
        
        NVIC_ClearPendingIRQ(TPM0_IRQn);
    }
}

main()
{
    init();
    //pc.printf("Welcome\r\na:on/off (default: on) s:1Hz d:10Hz f:100Hz g:1kHz\r\nq:digital on w:digital off\r\np:print values\r\n");
    tick_DAC.attach_us(&sine_gen, (double)1000000/num_samp_per_sec);
    //tick_test.attach(&print_in, (double)1.0/sampling_freq);
    
    d_IRQ.rise(&logichigh);
    d_IRQ.fall(&logiclow);

    slcd.All_Segments(1);
    wait(1);
    slcd.All_Segments(0);
    wait(1);    
    
    led1 = 1; led2 = 1; pps = 1; 

    sprintf(message, "1234");
    slcd.printf(message);
    if(dbg) pc.printf("Hello World!\n");
    //pc.putc('1');
    NVIC_SetVector(TPM0_IRQn, (uint32_t) TPM0_handler);
    NVIC_SetPriority(TPM0_IRQn, 0);
    NVIC_EnableIRQ(TPM0_IRQn);    
    //TPM0_init(modulo_val);

    if(dbg) pc.printf("Setting up UART interrupts!\n");
// Setup a serial interrupt function to receive data
    rpi.attach(&Rx_interrupt, Serial::RxIrq);
// Setup a serial interrupt function to transmit data
    //rpi.attach(&Tx_interrupt, Serial::TxIrq);
    
    //char temp[4];
    while(1){
    }
        //wait(3);
        //pulse_flag = 100;
        //pulse_tpm = 5;
        //TPM0_init(modulo_val);
        //TPM0_start();
        //if(dbg) pc.printf("Timer started!\n");
/*
    while(1) {
        flag = 0;
        TPM0_start();
        //slcd.putc(pc.getc());
        //led1 = 0;
        wait(0.5);
        if(dbg) pc.printf("flag = %d, TPM = %x\n", flag, TPM0_read());
        //pc.putc('1');
        //led1 = 1;
    }
*/
}

unsigned int rx_state = 0;
unsigned int num_sync = 0;
unsigned int num_sec = 0; 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    char c = rpi.getc();
    //led1=0;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    if( c == 't'){
        state = 0; 
        rx_state = 0;
        num_sec++;
        if(num_sec==4) num_sec =0;
        if( pulse_flag==0 && pulse_tpm==0){
            pulse_flag = old_pulse_flag;
            pulse_tpm = old_pulse_tpm;
        }
        if( arrival_flag==0 && arrival_tpm==0){
            sync_flag = old_sync_flag;
            sync_tpm = old_sync_tpm;
        }
        TPM0_init(modulo_val);
        TPM0_start();
        arrival_flag= 0;
        arrival_tpm = 0;
    } else if ( c == 'n'){
        on_DAC = true; 
    } else if ( c == 'o'){
        on_DAC = false; 
    } else if ( c == 'x'){
        sel_freq_DAC = 0; 
    } else if ( c == 'y'){
        sel_freq_DAC = 1; 
    } else if ( c == 'z'){
        sel_freq_DAC = 2; 
    } else if ( c == 'u'){
        sel_freq_DAC = 3; 
    } else if ( c == 'q'){
        d_out = true; 
    } else if ( c == 'w'){
        d_out = false; 
    } else if ( c == 'p'){ 
            if(num_sync > 0){
                temp_pulse_flag[num_sync-1] = flag;
                temp_pulse_tpm[num_sync-1] = TPM0_read();
                if(dbg) pc.printf("temp_pulse_flag[%d] = %d, temp_pulse_tpm[%d] = %d\n", num_sync-1, temp_pulse_flag[num_sync-1], num_sync-1, temp_pulse_tpm[num_sync-1]);
            }
            flag = 0;
            TPM0_init(modulo_val);
            if(num_sync < TOTAL_SYNC){ 
                TPM0_start();
                num_sync++;
            } else {
                pulse_flag = 0;
                pulse_tpm = 0;
                for(i=0; i<TOTAL_SYNC; i++){
                    pulse_flag += temp_pulse_flag[i];
                    pulse_tpm += temp_pulse_tpm[i];
                }
                pulse_flag /= TOTAL_SYNC;  
                pulse_tpm /= TOTAL_SYNC;
                if(pulse_flag<50 || pulse_flag>150){
                    pulse_flag = 0;
                    pulse_tpm = 0;
                } else {
                    old_pulse_flag = pulse_flag;
                    old_pulse_tpm = pulse_tpm;
                }
                flag = 0;         
                TPM0_init(modulo_val);
                if(dbg) pc.printf("pulse_flag = %d, pulse_tpm = %x\n", pulse_flag, pulse_tpm);
                if(num_sec==0){ 
                    rpi.putc('S');
                    TPM0_start();  
                    num_sync=1;
                } else {
                    num_sync=0;
                }
            }
    } else if ( c == 's'){
            temp_sync_flag[num_sync-1] = flag;
            temp_sync_tpm[num_sync-1] = TPM0_read();
            if(dbg) pc.printf("temp_sync_flag[%d] = %d, temp_sync_tpm[%d] = %d\n", num_sync-1, temp_sync_flag[num_sync-1], num_sync-1, temp_sync_tpm[num_sync-1]);
            flag = 0;         
            TPM0_init(modulo_val);
            if(num_sync < TOTAL_SYNC){
                rpi.putc('S'); 
                TPM0_start();
                num_sync++;
            } else {
                arrival_flag = 0;
                arrival_tpm = 0;
                for(i=0; i<TOTAL_SYNC; i++){
                    arrival_flag += temp_sync_flag[i];
                    arrival_tpm += temp_sync_tpm[i];
                }
                arrival_flag /= (2*TOTAL_SYNC);  
                arrival_tpm /= (2*TOTAL_SYNC);
                old_arrival_flag = arrival_flag;
                old_arrival_tpm = arrival_tpm;  
                num_sync=0;
                if(dbg) pc.printf("arrival_flag = %d, arrival_tpm = %x\n", arrival_flag, arrival_tpm);
                rpi.putc('M');
                sprintf(str, "%02d", arrival_flag);
                rpi.putc(str[0]);
                rpi.putc(str[1]);
                sprintf(str, "%04x", arrival_tpm); 
                rpi.putc(str[0]);
                rpi.putc(str[1]);
                rpi.putc(str[2]);
                rpi.putc(str[3]);
            }
    } else if( c == 'm' ){ 
        rx_state = 1; 
    } else {
        //while ((rpi.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        if(rx_state == 0){
            //if(dbg) pc.printf("t_rx_in = %d\n", rx_in);
            rx_buffer[rx_in] = c;
            rx_in = (rx_in + 1) % buffer_size;
            if(rx_in == 4){
                slcd.Home();
                slcd.printf(rx_buffer);
                slcd.Colon(1);
                rx_in = 0;
                //rpi.printf("l%0.3f",lightSensor.read());
                //rpi.printf("V%0.3f",in_0.read());
                sprintf(str, "l%0.3f",lightSensor.read());
                for(i=0; i<6; i++) rpi.putc(str[i]);
                sprintf(str, "v%0.3f",in_0.read());
                for(i=0; i<6; i++) rpi.putc(str[i]);
            }
        } else if(rx_state == 1){
            //if(dbg) pc.printf("m_rx_in = %d\n", rx_in);
            rx_buffer[rx_in] = c;
            rx_in = (rx_in + 1) % buffer_size;
            if(rx_in >= 6){
                sync_flag = (10*(rx_buffer[0]-'0') + (rx_buffer[1]-'0'));
              if(sync_flag >= arrival_flag){
                sync_flag -= arrival_flag;
                for(i=0; i<6; i++){
                    if( i<4 ) {rx_buffer[i] = rx_buffer[i+2];} else { rx_buffer[i]=0; }
                }
                sync_tpm = (int)strtol(rx_buffer, NULL, 16);
                if(sync_tpm >= arrival_tpm){
                    sync_tpm -= arrival_tpm;
                } else {
                    sync_tpm = 0x10000 + sync_tpm - arrival_tpm;
                    sync_flag--;
                }
              } else { sync_flag =0; sync_tpm = 0; }
                if(dbg) pc.printf("sync_flag = %d, sync_tpm = %x\n", sync_flag, sync_tpm);
                rx_in = 0;
            }            
        }                 
    }
    //led1=1;
    return;
}