#include "TPM_init.h"

void TPM0_init(unsigned int modulo_val){
    volatile unsigned int *ptrMyReg;
    unsigned int prev;
    
    //ptrMyReg = (volatile unsigned int *) MCG_C1_ADDR;
    //pc.printf("MCG_C1 = 0x%x ", *ptrMyReg);
    
    ptrMyReg = (volatile unsigned int *) SIM_SOPT2_ADDR;
    prev = *ptrMyReg;

    // Use MCFGFLLCLK or MCGPLLCLK/2 for TPM ( [25:24] = 01 )    
    //pc.printf("Previous value of SIM_SOPT2 = 0x%x ", *ptrMyReg);
    prev = prev & 0xFDFFFFFF;  //16:PLLFLLSEL, 0:MCFGFLLCLK, 1:MCGPLLCLK/2  
    //pc.printf("prev after AND MASK = %x", prev);
    prev = prev | 0x01000000;
    //pc.printf("prev after AND MASK = %x", prev);
    *ptrMyReg = prev;

    //pc.printf("SIM_SOPT2 = 0x%x\n", *ptrMyReg);
    
    //Turn on TPM0 CLK
    ptrMyReg = (volatile unsigned int *) SIM_SCGC6_ADDR; //bit [26-24]: TPM3-0 CLK gating 
    prev = *ptrMyReg;
    prev = prev | 0x07000000;
    *ptrMyReg = prev;
    //pc.printf("New value of SIM_SCGC6 = 0x%x ", *ptrMyReg); 
    
    //clear TPM0_SC
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    *ptrMyReg = 0x0;
    //pc.printf("TPM0_SC = 0x%x\n", *ptrMyReg);
    
    ptrMyReg = (volatile unsigned int *) TPM0_C0SC_ADDR; 
    prev = *ptrMyReg;
    prev = prev | 0x00000040; // bit[6]: channel interrupt enable
    *ptrMyReg = prev;
    //pc.printf("TPM0_C0SC = 0x%x\n", *ptrMyReg);

    //clear the counter    
    ptrMyReg = (volatile unsigned int *) TPM0_CNT_ADDR; //all bits set to 0
    *ptrMyReg = 0x0;
    //pc.printf("TPM0_CNT = 0x%x\n", *ptrMyReg);
    
    ptrMyReg = (volatile unsigned int *) TPM0_MOD_ADDR; 
    *ptrMyReg = modulo_val;
    //*ptrMyReg = 0xFFFF;
    //pc.printf("TPM0_MOD = 0x%x\n", *ptrMyReg);

    // Enable overflow interrupt    
    //ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    //*ptrMyReg = 0x00000040; //bit [6]:1, Enable Overflow Interrupts
    //pc.printf("TPM0_SC = 0x%x\n", *ptrMyReg);
    
}

unsigned int TPM0_SC_read() {
    volatile unsigned int *ptrMyReg;
    unsigned int value;
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    value = *ptrMyReg;
    return value;
}

unsigned int TPM0_read() {
    volatile unsigned int *ptrMyReg;
    unsigned int value;
    ptrMyReg = (volatile unsigned int *) TPM0_CNT_ADDR; //all bits set to 0
    value = *ptrMyReg;
    return value;
}

void TPM0_clear_overflow() {
    volatile unsigned int *ptrMyReg;
    unsigned int prev;
        
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    prev = *ptrMyReg;
    *ptrMyReg = prev | 0x00000080;     //bit[4:3]: 0x01, on every TPM counter clk, bit[6]: Timer Overflow Interrupt Enable, bit[7]: Timer Overflow Flag
}

void TPM0_start() {   
    volatile unsigned int *ptrMyReg;

    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    *ptrMyReg = 0x00000000;     //bit[4:3]: 0x01, on every TPM counter clk, bit[6]: Timer Overflow Interrupt Enable, bit[7]: Timer Overflow Flag

    //clear the counter    
    ptrMyReg = (volatile unsigned int *) TPM0_CNT_ADDR; //all bits set to 0
    *ptrMyReg = 0x0;
    
    ptrMyReg = (volatile unsigned int *) TPM0_SC_ADDR; //all bits set to 0
    *ptrMyReg = 0x000000C8;     //bit[4:3]: 0x01, on every TPM counter clk, bit[6]: Timer Overflow Interrupt Enable, bit[7]: Timer Overflow Flag
}