#include "mbed.h"
//#include "SoftSerial.h"
//#include "SoftI2C.h"
//#include "DS1307.h"

#define typeIP 0
#define typeIL 1
#define typeIB 2

//Init debug port
Serial DBG(PA_9, PA_10);    //tx, rx

//Init xbee
Serial XB(PC_10, PC_11);    //tx, rx

//Init rtc
//I2C         luciI2C (PB_7,PB_6);    //sda, scl
//SoftI2C     luciI2C (PB_7,PB_6);    //sda, scl
//RtcDs1307   luciRTC(luciI2C);

//Init adc
AnalogIn anVP(PA_0);
AnalogIn anIP(PA_3);
AnalogIn anVL(PA_2);
AnalogIn anIL(PA_1);
AnalogIn anVB(PB_1);
AnalogIn anIB(PB_0);
AnalogIn anTE(PC_2);

//Init switch control
DigitalOut PB12(PB_12);

//Declared unused adc as digital out
//PA0 used      //PA1 used
//PA2 used      //PA3 used
//PA4 UN        //PA5 SPI UN
//PA6 SPI UN    //PA7 SPI UN
//PB0 used      //PB1 used
//PC0 UN        //PC1 UN
//PC2 Temp UN   //PC3 UN
//PC4 UN        //PC5 UN
DigitalOut PA4(PA_4);
DigitalOut PA5(PA_5);
DigitalOut PA6(PA_6);
DigitalOut PA7(PA_7);
DigitalOut PC0(PC_0);
DigitalOut PC1(PC_1);
DigitalOut PC2(PC_2);
DigitalOut PC3(PC_3);
DigitalOut PC4(PC_4);
DigitalOut PC5(PC_5);

//Sensor value
float valVP,valIP;
float valVL,valIL;
float valVB,valIB;
float valTE;

//Date and Time
int year,month,date;
int day,hr,min,sec;
//DateTime dt;

//Variables
int i;

float adcRead(AnalogIn an) {
    float s = 0;
    float sTotal = 0;
    int adcMax = 10000;
    
    for(int i=0; i<adcMax; i++) {   //Do adcMax readings
        s = an.read();
        sTotal  = sTotal + s;
        wait_us(10);
    }
    return sTotal/adcMax;
}

float currentCalculate(float adcVal, int type) {
    float res = 0;
    
    if(type == typeIP || type == typeIB) {
        adcVal = adcVal - 0.510980;  //Remove offset
    } else {
        adcVal = adcVal - 0.491730; //Remove offset for IL    
    }
    if(-0.0025 < adcVal && adcVal < 0.0025) { //No current
        res = 0;
    } else {
        res = (adcVal/13.2)*1000;   
    }
    
    if(type == typeIP) {
        if(res < 0) res = 0;    
    }
    return res;
}

/*
bool rtcUpdate(RtcDs1307 &rtc, int32_t bias) // this must be signed
{   bool bUpdated = false;
 
    // Use the compiled date/time as a basis for setting the clock.
    // We assign it to a signed integer so that negative biases work correctly
    int64_t compiledTime = DateTime(__DATE__,__TIME__).unixtime();
 
    // This assumes that the program is run VERY soon after the initial compile.
    time_t localt = DateTime(compiledTime + bias).unixtime(); // offset by bias
    
    // If the stored static time stamp does not equal the compiled time stamp,
    // then we need to update the RTC clock and the stored time stamp
    if(*((time_t *)&rtc[0]) != localt)
    {
        // Update the RTC time as local time, not GMT/UTC
        rtc.adjust(localt);
        // Store the new compiled time statically in the object ram image
        *((time_t *)&rtc[0]) = localt;
        // Push the object ram image to the RTC ram image
        bUpdated = rtc.commit();
    }
    return bUpdated;
}
*/
int main() {
    DBG.baud(115200);
    XB.baud(9600);
    
    // Uncomment to update time
    //DBG.printf("update time\r\n");
    //if(rtcUpdate(luciRTC, (7*60*60) )) // GMT+7
    //    DBG.printf("Updated RTC to compiled time\r\n");
    //DBG.printf("compiled %s %s\r\n",__DATE__,__TIME__);
    //DBG.printf("rtc clock is %s\r\n", (luciRTC.isRunning() ? "running" : "halted"));
    
    //Set switch control always on
    PB12.write(1);
    
    PA4.write(0);
    PA5.write(0);
    PA6.write(0);
    PA7.write(0);
    PC0.write(0);
    PC1.write(0);
    PC2.write(0);
    PC3.write(0);
    PC4.write(0);
    PC5.write(0);
        
    while(1){
        //Read sensor
        valVP = 0;
        valVL = 0;
        valVB = 0;
        valIP = 0;
        valIL = 0;
        valIB = 0;
        valTE = 0;
        
        //Read sensor
        valVP = adcRead(anVP)*48.21;
        valVL = adcRead(anVL)*48.21;
        valVB = adcRead(anVB)*48.21;
        valIP = currentCalculate(adcRead(anIP),typeIP);
        valIL = currentCalculate(adcRead(anIL),typeIL);
        valIB = currentCalculate(adcRead(anIB),typeIB);
        valTE = adcRead(anTE);
        
        //valVP = adcRead(anVP)*52.8;
        //valVL = adcRead(anVL)*52.8;
        //valVB = adcRead(anVB)*52.8;
        //valIP = currentCalculate(adcRead(anIP),typeIP);
        //valIL = currentCalculate(adcRead(anIL),typeIL);
        //valIB = currentCalculate(adcRead(anIB),typeIB);
        //valTE = adcRead(anTE);
        
        //Read time
        //dt = luciRTC.now();
        //DBG.printf("%02u%02u%02u %02u:%02u:%02u\r\n"
        //,dt.year(),dt.month(),dt.day(),dt.hour(),dt.minute(),dt.second());
        
        //Contruct and senddata
        //DBG.printf("[%d]{DT=\"%02u%02u%02u %02u:%02u:%02u\",VP=%.1f,IP=%.1f,VL=%.1f,IL=%.1f,VB=%.1f,IB=%.1f,TE=%.1f}\r\n"
        //,i,dt.year(),dt.month(),dt.day(),dt.hour(),dt.minute(),dt.second(),valVP,valIP,valVL,valIL,valVB,valIB,valTE);
        //XB.printf("{DT=\"%02u%02u%02u %02u:%02u:%02u\",VP=%.1f,IP=%.1f,VL=%.1f,IL=%.1f,VB=%.1f,IB=%.1f,TE=%.1f}"
        //,dt.year(),dt.month(),dt.day(),dt.hour(),dt.minute(),dt.second(),valVP,valIP,valVL,valIL,valVB,valIB,valTE);
        DBG.printf("[%d]{DT=\"YYYYMMDD HH:MM:SS\",VP=%.5f,IP=%.5f,VL=%.5f,IL=%.5f,VB=%.5f,IB=%.5f,TE=%.5f}\r\n"
        ,i,valVP,valIP,valVL,valIL,valVB,valIB,valTE);
        XB.printf("{DT=\"YYYYMMDD HH:MM:SS\",VP=%.1f,IP=%.1f,VL=%.1f,IL=%.1f,VB=%.1f,IB=%.1f,TE=%.1f}"
        ,valVP,valIP,valVL,valIL,valVB,valIB,valTE);
        wait(30);
        i++;
    }    
}