#include "mbed.h"

DigitalInOut DE_LD1(D14),
             DE_LD2(D11),
             DE_LD3(D9),
             DE_LD5(D12),
             DE_LD6(D10),
             DE_LD7(D15),
             DE_LD8(D13);

InterruptIn button(A0,PullUp);
int val=1;
void show_de(int value);
void button_handler() {
    show_de(0);
    wait(0.3); 
    show_de((rand()%6)+1);
    wait(2);
    show_de(0);
    wait(0.5); 
    val=1;
}


void show_de(int value) {
    switch(value) {
           case 0:
              DE_LD1=0;         DE_LD7=0;
              DE_LD2=0;DE_LD5=0;DE_LD8=0;
              DE_LD3=0;         DE_LD6=0;
              break;
           case 1:
              DE_LD1=0;         DE_LD7=0;
              DE_LD2=0;DE_LD5=1;DE_LD8=0;
              DE_LD3=0;         DE_LD6=0;
              break;       
           case 2:
              DE_LD1=0;         DE_LD7=0;
              DE_LD2=1;DE_LD5=0;DE_LD8=1;
              DE_LD3=0;         DE_LD6=0;
              break;   
           case 3:
              DE_LD1=1;         DE_LD7=0;
              DE_LD2=0;DE_LD5=1;DE_LD8=0;
              DE_LD3=0;         DE_LD6=1;
              break;    
           case 4:
              DE_LD1=1;         DE_LD7=1;
              DE_LD2=0;DE_LD5=0;DE_LD8=0;
              DE_LD3=1;         DE_LD6=1;
              break;   
           case 5:
              DE_LD1=1;         DE_LD7=1;
              DE_LD2=0;DE_LD5=1;DE_LD8=0;
              DE_LD3=1;         DE_LD6=1;
              break; 
           case 6:
              DE_LD1=1;         DE_LD7=1;
              DE_LD2=1;DE_LD5=0;DE_LD8=1;
              DE_LD3=1;         DE_LD6=1;
              break; 
        };
};

int main() {
    DE_LD1.output();
    DE_LD2.output();
    DE_LD3.output();
    DE_LD5.output();
    DE_LD6.output();
    DE_LD7.output();
    DE_LD8.output();
    button.fall(&button_handler);
    button.enable_irq();
    val=1;
    while(1) {
        //DE_LD1 = 1; // LED is ON
        wait(0.2); // 200 ms
        //DE_LD1 = 0; // LED is OFF
        wait(1.0); // 1 sec
        show_de(val);
        if (val>6) val=1;
        else val++;
    }
}
