#include "mbed.h"
#include "NeoStrip.h"

int N=2268; //number of leds

Serial pc(USBTX, USBRX);
NeoStrip strip(p22, N);
extern "C" void mbed_reset();

float bright = 1.0;

/*bool equal(float a, float b) {
    if (abs(a - b) < 0.00001)
        return true;
    else
        return false;
}*/

void SetAll()
{
    for (int i=0; i<N; i++) {
        strip.setPixel(i,255,255,255);
    }
    strip.write();
}

int main(int argc, char** argv) {
    pc.baud(115200);
    
    SetAll(1.0f);
    
    printf("Welcome!\n");
    
    while(1) {
        wait(0.5);
        
        //SetAll(1.0f);
        
        if (pc.readable()) {
            switch(pc.getc()) {
                case 'r':
                    printf("Resetting");
                    mbed_reset();
                    break;
                case 'b': {
                    bright += 0.1;
                    if (bright>1.01) bright=0;   // set default brightness
                    strip.setBrightness(bright);
                    SetAll(1.0f);
                    printf("brightness: %.2f\r\n",bright);  
                }
                break;
            }    
        }
    }
}