#include "mbed.h"
#include "HCSR04.h"
#include "NeoStrip.h"

#define MinDist 150
#define PeriodeTime 100
#define Nsensor 6

HCSR04 *sensor1;
HCSR04 *sensor2;
HCSR04 *sensor3;
HCSR04 *sensor4;
HCSR04 *sensor5;
HCSR04 *sensor6;

Timeout Delay;

Serial pc(USBTX, USBRX);
//int SectionSize[8]={16,16,16,16,16,16,16,16};
int SectionSize[8]= {500,343,285,270,395,443,16,16};
int N=2268;

int CombinedSectionSize[] = {121, 61, 36, 40+90, 152, 120, 122, 40+61, 169+36, 38+39, 37+39, 124, 37+35, 60, 91+94, 61, 89, 152+17, 122, 149}; // Sliser der hænger sammen er i samme section 

int TimeToNet=0;
int CallAgain=0;
bool ThereAreSomeThing=0;
int ThereAreNothing=0;

//int N=128;

NeoStrip strip(p22, N);

double LED[8]; //power status
int LedOnOff[8]; //Hvis 1 sættes skal den lave et loop
bool InAktive;
int color[3]= {255,255,255};

long DistArr[6];
int SensorTOCall=0;

int hueToRGB(float h);
void CallNewSensor();
void pattern1();
extern "C" void mbed_reset();
// display a shifting rainbow, all colors have maximum
// saturation and value, with evenly spaced hue
void pattern1()
{
    static float dh = 360.0 / N;
    static float x = 0;

    for (int i = 0; i < N; i++)
        strip.setPixel(i, hueToRGB((dh * i) - x));

    x += 1;
    if (x > 360)
        x = 0;
}

// Converts HSV to RGB with the given hue, assuming
// maximum saturation and value
int hueToRGB(float h)
{
    // lots of floating point magic from the internet and scratching my head
    float r, g, b;
    if (h > 360)
        h -= 360;
    if (h < 0)
        h += 360;
    int i = (int)(h / 60.0);
    float f = (h / 60.0) - i;
    float q = 1 - f;

    switch (i % 6) {
        case 0:
            r = 1;
            g = f;
            b = 0;
            break;
        case 1:
            r = q;
            g = 1;
            b = 0;
            break;
        case 2:
            r = 0;
            g = 1;
            b = f;
            break;
        case 3:
            r = 0;
            g = q;
            b = 1;
            break;
        case 4:
            r = f;
            g = 0;
            b = 1;
            break;
        case 5:
            r = 1;
            g = 0;
            b = q;
            break;
        default:
            r = 0;
            g = 0;
            b = 0;
            break;
    }

    // scale to integers and return the packed value
    uint8_t R = (uint8_t)(r * 255);
    uint8_t G = (uint8_t)(g * 255);
    uint8_t B = (uint8_t)(b * 255);

    return (R << 16) | (G << 8) | B;
}

void update()
{
    int LEDNr=0;
    for (int j=0; j<Nsensor; j++) {
        for (int i=0; i<SectionSize[j]; i++) {
            strip.setPixel(LEDNr,LED[j]*color[0],LED[j]*color[1],LED[j]*color[2]);
            LEDNr++;
        }
    }
    strip.write();
}

/*void updateInactive()
{
    int LEDNr=0;
    for (int j=0; j<sizeof(CombinedSectionSize)/sizeof(*CombinedSectionSize); j++) {
        for (int i=0; i<CombinedSectionSize[j]; i++) {
            if (j == whichSectionToShow) {
                strip.setPixel(LEDNr,color[0],color[1],color[2]);
            } else {
                strip.setPixel(LEDNr,0,0,0);
            }
            LEDNr++;
            strip.setPixel(182,0,0,0);
            strip.setPixel(1048,0,0,0);
        }
    }
    strip.write();    
}
void updateInactiveSection(int whichSectionToShow)
{
    int offset = 0;
    for (int i=0; i<whichSectionToShow; i++) {
        offset += CombinedSectionSize[i];   
    }
    
    int LEDNr=offset;
    
        for (int i=0; i<CombinedSectionSize[whichSectionToShow]; i++) {
                strip.setPixel(LEDNr,color[0],color[1],color[2]);
            LEDNr++;
            strip.setPixel(182,0,0,0);
            strip.setPixel(1048,0,0,0);
        }
        
    strip.write();    
}*/

void updateInactiveSections(int section1, int section2, int section3, int section4, int section5)
{
    int LEDNr=0;
    for (int j=0; j<sizeof(CombinedSectionSize)/sizeof(*CombinedSectionSize); j++) {
        for (int i=0; i<CombinedSectionSize[j]; i++) {
            if ((section1 > -1 && j == section1) || (section2 > -1 && j == section2) || (section3 > -1 && j == section3) || (section4 > -1 && j == section4) || (section5 > -1 && j == section5)) {
                strip.setPixel(LEDNr,color[0],color[1],color[2]);
            } else {
                strip.setPixel(LEDNr,0,0,0);
            }
            LEDNr++;
            strip.setPixel(182,0,0,0);
            strip.setPixel(1048,0,0,0);
        }
    }
    strip.write();    
}

void updateSections(int section1, int section2, int section3)
{
    int LEDNr=0;
    for (int j=0; j<sizeof(SectionSize)/sizeof(*SectionSize); j++) {
        for (int i=0; i<SectionSize[j]; i++) {
            if ((section1 > -1 && j == section1) || (section2 > -1 && j == section2) || (section3 > -1 && j == section3)) {
                strip.setPixel(LEDNr,color[0],color[1],color[2]);
            } else {
                strip.setPixel(LEDNr,0,0,0);
            }
            LEDNr++;
            strip.setPixel(182,0,0,0);
            strip.setPixel(1048,0,0,0);
        }
    }
    strip.write();    
}

void ReadColorFactor()
{
    LocalFileSystem local("local");               // Create the local filesystem under the name "local"
    char str[10];

    FILE *fp = fopen("/local/color.txt", "r");  // Open "out.txt" on the local file system for writing
    if (fp) {
        //fscanf(fp,"%[^\n]",str);
        printf("Reading color.txt \r\n");
        fgets(str, 10, fp);
        printf("%s\r\n",str);
        color[0]=atoi(str);
        fgets(str, 10, fp);
        printf("%s\r\n",str);
        color[1]=atoi(str);
        fgets(str, 10, fp);
        printf("%s\r\n",str);
        color[2]=atoi(str);
        fclose(fp);
    } else
        printf("Cant open file\r\n");
}

void CalcNew()
{
    for (int i=0; i<Nsensor; i++) {
        if ((LedOnOff[i]==2) && (LED[i]>=0)) LED[i]-=0.1; //falder
        if (LedOnOff[i]==1) {
            LED[i]+=0.1;
            //InAktive=0;                 //stiger
        }
        if (LED[i]>1) {                                    //Skift til at gå ned igen
            LedOnOff[i]=2;
            LED[i]=1;
        }
        if ((LedOnOff[i]==2) && (LED[i]<=0.02)) {          //SLuk
            LED[i]=0;
            LedOnOff[i]=0;
        }
    }
    update();
}


void SetAll(float p)
{
    for (int i=0; i<N; i++) {
        strip.setPixel(i,p*255,p*255,p*255);
    }
    strip.write();
}

void SetAllOn()
{
    for (int i=0; i<N; i++) {
        strip.setPixel(i,color[0],color[1],color[2]);
    }
    strip.write();
}


void distance6(long Duration)
{
    //printf("Distance2: %d   %.2f \n\r",Duration, LED[1]);
    DistArr[5]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[5]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=6; //kalder sig selv igen
        }
    } else  {
        LedOnOff[5]=2;
        CallAgain=0;
    }
}


void distance5(long Duration)
{
    //printf("Distance1: %d %.2f  \n\r",Duration, LED[0]);
    DistArr[4]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[4]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=5; //kalder sig selv igen
        }
    } else  {
        LedOnOff[4]=2;
        CallAgain=0;
        SensorTOCall=6;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor

//    sensor6->Trigger();
}

void distance4(long Duration)
{
    //printf("Distance4: %d   %.2f \n\r",Duration, LED[3]);
    DistArr[3]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[3]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=4; //kalder sig selv igen
        }
    } else  {
        LedOnOff[3]=2;
        CallAgain=0;
        SensorTOCall=5;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor

//    sensor5->Trigger();
}

void distance3(long Duration)
{
    //printf("Distance3: %d   %.2f \n\r",Duration, LED[2]);
    DistArr[2]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[2]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=3; //kalder sig selv igen
        }
    } else  {
        LedOnOff[2]=2;
        CallAgain=0;
        SensorTOCall=4;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor

    //sensor4->Trigger();
}

void distance2(long Duration)
{
    //printf("Distance2: %d   %.2f \n\r",Duration, LED[1]);
    DistArr[1]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[1]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=2; //kalder sig selv igen
        }
    } else  {
        LedOnOff[1]=2;
        CallAgain=0;
        SensorTOCall=3;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor
}


void distance1(long Duration)
{

    DistArr[0]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[0]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=1; //kalder sig selv igen
        }
    } else  {
        LedOnOff[0]=2;
        CallAgain=0;
        SensorTOCall=2;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor
}

void CallNewSensor()
{
    switch (SensorTOCall) {
        case 1:
            sensor1->Trigger();
            break;
        case 2:
            sensor2->Trigger();
            break;
        case 3:
            sensor3->Trigger();
            break;
        case 4:
            sensor4->Trigger();
            break;
        case 5:
            sensor5->Trigger();
            break;
        case 6:
            sensor6->Trigger();
            break;
    }
}

bool AreSame(float a, float b)
{
    return fabs(a - b) < 0.04f;
}

void setGroup(int i) {
    switch (i) {
        case 0:
            updateInactiveSections(0, 17, 14, 2, 5);
            break;
        case 1:
            updateInactiveSections(4, 13, 19, 18, 0);
            break;
        case 2:
            updateInactiveSections(16, 7, 1, 10, 3);
            break;
        case 3:
            updateInactiveSections(3, 9, 18, 8, 11);
            break;
        case 4:
            updateInactiveSections(8, 11, 15, 6, 0);
            break;
        case 5:
            updateInactiveSections(12, 3, 11, 16, 5);
            break;
        case 6:
            updateInactiveSections(5, 6, 16, 15, 7);
            break;
        case 7:
            updateInactiveSections(15, 10, 14, 2, 19);
            break;
        case 8:
            updateInactiveSections(19, 1, 11, 13, 4);
            break;
        case 9:
            updateInactiveSections(3, 12, 0, 8, 9);
            break;
        case 10:
            strip.setBrightness(0.85f);
            for (int j=0; j<sizeof(CombinedSectionSize)/sizeof(*CombinedSectionSize); j++) {
                updateInactiveSections(j, -1, -1, -1, -1);
                wait_ms(300);
            }
            break;
        case 11:
            strip.setBrightness(0.7f);
            for (int i=0; i<4; i++) {
                for (int j=0; j<6; j++) {
                    if (j == 4) { // brightness for section 4 (old sections) only.
                        strip.setBrightness(0.5f);
                    }
                    if (j == 5) { // sets to normal again immediatly after section 4
                        strip.setBrightness(0.7f);
                    }
                    
                    updateSections(j, -1, -1);
                    wait_ms(500);
                }
            }
            break;
        case 12:
            SetAllOn();
            break;
    }
}

int main()
{
    pc.baud(115200);
    printf("Test af sensor\r\n");
    sensor1= new HCSR04(p5,p6,distance1);
    sensor2= new HCSR04(p7,p8,distance2);
    sensor3= new HCSR04(p9,p10,distance3);
    sensor4= new HCSR04(p11,p12,distance4);
    sensor5= new HCSR04(p13,p14,distance5);
    sensor6= new HCSR04(p15,p16,distance6);
    ReadColorFactor();
    N=0;
    for (int a=0; a<8; a++) N+=SectionSize[a];
    printf("Numbers of LED %d\r\n",N);

    float bright = 0.2; // 20% is plenty for indoor use
    strip.setBrightness(bright);    // set default brightness

    SetAll(0);
    
    float brightness = 0.0f;
    strip.setBrightness(brightness);
    bool fadein = true;
    
    bool hold = false;
    float holdTime = 0.0f;
    
    int groupSelected = 0;
    
    bool lysshow = true;

    while(1) {
                
        ThereAreSomeThing=0;
        sensor1->Trigger();
        wait(0.05);
        
        if (ThereAreSomeThing) {
            ThereAreNothing=0; 
        }
        else {
            ThereAreNothing++;
        }
        
        if (ThereAreNothing>0) { //5 minutter ingenting før var den 6000. 100 = 5 sekunder
            InAktive= true; //Inaktiv på den måde at denskal lave noget        
        }
        /*if ((ThereAreSomeThing==0) && (InAktive)) {
            InAktive=false; //gå tilbage til almindeligt mode
            printf("Something\n");
        }*/
        if (ThereAreSomeThing && InAktive) {
            /*InAktive=false; //gå tilbage til almindeligt mode
            fadein = true;
            hold = false;
            holdTime = 0.0f;
            brightness = 0.0f;
            strip.setBrightness(brightness);
            SetAll(0.0f);
            printf("Something\n");*/
        }
        //if (InAktive) {
        //    printf("Inaktive");
        if (lysshow) {
            /*if (TimeToNet) TimeToNet--;
            
            if ((InAktive==2) && (TimeToNet==0)) { //gør noget
              LED[rand() % 6]=1; //Tænder for en tilfældig
              //Der skal gå et stykke tid
              TimeToNet=60; //3 sek
              CalcNew();
            }*/
            //SetAllOn();
            //updateInactive();
            //strip.setBrightness(0.35f); 
            
            if ((groupSelected == 10) || (groupSelected == 11) || AreSame(holdTime, 0.35f) ) { //Reset if hold time is reached or after whirl effect
                fadein = true;
                hold = false;
                holdTime = 0.0f;
                brightness = 0.0f;
                strip.setBrightness(brightness);
                
                int groupSelectedNew = rand() % 12; // normal is 15
                while(groupSelectedNew == groupSelected) { //set new 
                    groupSelectedNew = rand() % 12; // normal is 15
                }
                if ((groupSelectedNew == 13) && (groupSelectedNew == 14)) groupSelectedNew = 12; //Same effect with tri probability
                groupSelected = groupSelectedNew;
                printf("Case %d\r\n", groupSelected);
                
                SetAll(0.0f);
            }
            
            setGroup(groupSelected);
            
            if ((groupSelected == 12 && AreSame(brightness, 0.19f)) ||  //|| AreSame(brightness, 0.6f)) { //normal på 0.8
                (groupSelected == 0 && AreSame(brightness, 0.28f)) ||
                (groupSelected == 1 && AreSame(brightness, 0.20f)) ||
                (groupSelected == 2 && AreSame(brightness, 0.30f)) ||
                (groupSelected == 3 && AreSame(brightness, 0.25f)) ||
                (groupSelected == 4 && AreSame(brightness, 0.30f)) ||
                (groupSelected == 5 && AreSame(brightness, 0.20f)) ||
                (groupSelected == 6 && AreSame(brightness, 0.33f)) ||
                (groupSelected == 7 && AreSame(brightness, 0.22f)) ||
                (groupSelected == 8 && AreSame(brightness, 0.20f)) ||
                (groupSelected == 9 && AreSame(brightness, 0.30f))) { //Individual group brightness
                fadein = false;
                hold = true;
            } 
            if (fadein) {
                //brightness += 0.013f;
                brightness += 0.037f;
            }
            
            
            if (!fadein && hold && (groupSelected == 12)) {
                holdTime += 0.01f;
            } else if (!fadein && hold) {
                holdTime += 0.05f;
            }
            
            //printf("%f\n", brightness);
            
            strip.setBrightness(brightness);
        }
        if (!InAktive) {
            CalcNew();
            LedOnOff[0]=2;
            LedOnOff[1]=2;
            LedOnOff[2]=2;
            LedOnOff[3]=2;
            LedOnOff[4]=2;
            LedOnOff[5]=2;
            LedOnOff[6]=2;
            LedOnOff[7]=2;
            printf("Sensor %d %d %d %d %d %d             \r",DistArr[0],DistArr[1],DistArr[2],DistArr[3],DistArr[4],DistArr[5]);
        }
        if (pc.readable()) {
            switch(pc.getc()) {
                case '1':
                    LedOnOff[0]=1;
                    break;
                case '2':
                    LedOnOff[1]=1;
                    break;
                case '3':
                    LedOnOff[2]=1;
                    break;
                case '4':
                    LedOnOff[3]=1;
                    break;
                case '5':
                    LedOnOff[4]=1;
                    break;
                case '6':
                    LedOnOff[5]=1;
                    break;
                    //case 'a':  InAktive=1;     break;
                case 'k': {
                    if (lysshow) {
                        lysshow = false;
                        InAktive=1;
                        strip.setBrightness(1.0);
                        SetAllOn();
                        printf("All On 100% birghtness!!!!\r\n");
                    } else {
                        lysshow = true;
                        InAktive=0;
                        strip.setBrightness(0.2);
                        printf("Continuing normal lightshow!!!!\r\n");  
                    }
                }
                break;
                case 'K':
                    InAktive=0;
                    break;

                case 'c':
                    printf("Color R %d G %d B %d\r\n",color[0],color[1],color[2]);
                    break;
                case 'r':
                    mbed_reset();
                    break;
                case 'b': {
                    bright+=0.1;
                    if (bright>1.01) bright=0;
                    strip.setBrightness(bright);    // set default brightness
                    printf("brigth %.2f\r\n",bright);
                }
                break;
            }
        }
    }
}