
#ifndef RGB_H
#define RGB_H
#include "mbed.h"
#include "Color.h"

/** 
 *  Colors can be created by either giving in a value between 0 and 255 for red, green and blue,
 *  or giving in the name of a hardcoded color or giving the hexadecimal code for a color.
 */
class RGB{
    public:
    
    /** Create a new RGB instance
     *  @param r_pin mbed PinName linked to red led
     *  @param g_pin mbed PinName linked to green led
     *  @param b_pin mbed PinName linked to blue led
     */
     
        RGB(PinName r_pin, PinName g_pin, PinName b_pin);
    
    /** Set the color by giving in the name of a color
     *  @param color Pointer to a Color object
     *  @ref Color
     */
     
        void setColor(Color color);
        
    /** Set the color by giving in a value for red, green and blue
     *  @param red A value between 0 and 255 is assigned to red
     *  @param green A value between 0 and 255 is assigned to green
     *  @param blue A value between 0 and 255 is assigned to blue
     */
        
        void setColor(int red, int green, int blue);
        
    /** Set the color by giving an integer in hexadecimal notation
     *  @param color A Color is made by giving in red, green and blue: 0xRRGGBB
     */
        
        void setColor(int Color);
        
    /** Get the color of the led */
        
        Color* getColor();
        
    /** Turn off the led */
        
        void off();
    private:
        PwmOut* r_out;
        PwmOut* g_out;
        PwmOut* b_out;
        
        float toFloat(int intValue);
        
    
};

#endif