
#ifndef COLOR_H
#define COLOR_H


/** 
 *  Used to manage the colors, both the hardcoded ones and those that are not hardcoded. 
 *  The ones that are not hardcoded include making colors through assigning a number between 0 and 255
 *  for red, green and blue, and using a hexadecimal format of an integer: 0xRRGGBB
 */


class Color{
    
    
    int red, green, blue;
    
    int floatToColorValue(float value);
    
    static const int MAX_COLOR_VALUE = 255;
    
    public:
    
    /** Enum with a set of hardcoded colors */
    
    enum colors {RED = 0xFF0000,
                GREEN = 0x00FF00,
                BLUE = 0x0000FF,
                CYAN = 0x00FFFF,
                MAGENTA = 0xFF00FF,
                YELLOW = 0xFFFF00,
                WHITE = 0xFFFFFF};
    
    /** Create a color by giving in a value for red, green and blue
     *  @param red A value between 0 and 255 is assigned to red
     *  @param green A value between 0 and 255 is assigned to green
     *  @param blue A value between 0 and 255 is assigned to blue
     */
    
        Color(int red, int green, int blue);
        
    /** Create a color by giving in a value for the color
     *  This value is the integer value of the hexadecimal version: 0xRRGGBB
     */
        
        Color(int color);
        
    /** Create a color by giving in a value for red, green and blue
     *  @param red A value between 0.0 and 1.0 is assigned to red
     *  @param green A value between 0.0 and 1.0 is assigned to green
     *  @param blue A value between 0.0 and 1.0 is assigned to blue
     */
        
        Color(float red, float green, float blue);
        
    /** Get the hexadecimal value of the color
     *  Get the hex value in this format: 0xRRGGBB
     */
        
        int getHex();
        
    /** Get the value for the red component (from 0 to 255) */
        
        int getRed();
        
    /** Get the value for the green component (from 0 to 255) */
        
        int getGreen();
        
    /** Get the value for the blue component (from 0 to 255) */
        
        int getBlue();
        
    
};

#endif