
#include "Color.h"

Color::Color(int red, int green, int blue){
    this->red = red;
    this->green = green;
    this->blue = blue;
}

Color::Color(float red, float green, float blue){
    this->red   =  floatToColorValue(red);
    this->green =  floatToColorValue(green);
    this->blue  =  floatToColorValue(blue);
}

int Color::floatToColorValue(float value){
    return (int) (value * MAX_COLOR_VALUE);
}

Color::Color(int Color){ //AABBCC
    red   = (Color >> 16) & 0x0000FF;
    green = (Color >> 8)  & 0x0000FF;
    blue  =  Color        & 0x0000FF;
}

int Color::getHex(){
    return (red >> 16) + (green >> 8) + (blue >> 0); //verander shift register
}

int Color::getRed(){
    return red;
}

int Color::getGreen(){
    return green;
}

int Color::getBlue(){
    return blue;
}





