#include "mbed.h"
#include "coap.h"
#include "Color.h"
#include "RGB.h"
#include "LM75B.h"
#include "C12832.h"

    RGB* led = new RGB(p23,p24,p25);
    LM75B sensor(p28,p27);
    C12832 lcd(p5, p7, p6, p8, p11);
    DigitalIn fire(p14);
    PwmOut spkr(p26);

void get_hello(Request* req, Response* res)
{
    
    
    res->setContent("Hello World\r\n", 13);
    res->setCode(CONTENT);
    //res->setType(NON_CONFIRMABLE);
}

void post_led(Request* req, Response* res)
{
    
    
    led->setColor(255,0,0);
    
    if(req->hasContent()){
              printf("Content: %s\r\n", req->getContent());
              int x;
              x = strtol(req->getContent(), NULL, 16);
              led->setColor(x);
           }
           res->setCode(CHANGED);
    //res->setType(NON_CONFIRMABLE);
}


void get_led(Request* req, Response* res)
{
    
    char temp[100];
    int color = led->getColor()->getHex();
    int size = sprintf(temp, "%06x \r\n", color);
    
    res->setContent( temp, size);
    res->setCode(CONTENT);
    //res->setType(NON_CONFIRMABLE);
}


void get_temperature(Request* req, Response* res)
{
    
    
    char temp[100];
    int size = sprintf(temp, "temperatuur: %0.3f", sensor.read());
    
    res->setContent( temp, size);
    res->setCode(CONTENT);
    //res->setType(NON_CONFIRMABLE);
    
}


void post_lcd(Request* req, Response* res)
{
    
    if(req->hasContent()){
              lcd.cls();
              lcd.locate(0,3);
              lcd.printf(req->getContent());
           }
           res->setCode(CHANGED);
    //res->setType(NON_CONFIRMABLE);
    
}


void post_biep(Request* req, Response* res)
{
    
    if(req->hasContent()){
            for (float i=2000.0; i<10000.0; i+=100) {
            spkr.period(1.0/i);
            spkr=0.5;
            wait(0.1);
           }
           res->setCode(CHANGED);
    //res->setType(NON_CONFIRMABLE);
    
}

int main()
{
    Server server;
    
    server.enableBroadcast();
    
    server.add("/hello", &get_hello, GET);
    server.add("/led", &get_led, GET);
    server.add("/led", &post_led, POST);
    server.add("/temperature", &get_temperature, GET);
    server.add("/lcd", &post_lcd, POST);
    server.add("/biep", &post_lcd, POST);
    while(1){
        server.waitForRequest();
    }
    
}