
#include "RGB.h"

RGB::RGB(PinName r_pin, PinName g_pin, PinName b_pin){
    this->r_out = new PwmOut(r_pin);
    this->g_out = new PwmOut(g_pin);
    this->b_out = new PwmOut(b_pin);
}

float RGB::toFloat(int intValue){
    return (float) ((255-intValue)/255);
}

void RGB::setColor(Color color){
    delete this->color;
    r_out->write(toFloat(color.getRed()));
    g_out->write(toFloat(color.getGreen()));
    b_out->write(toFloat(color.getBlue()));
    this->color = &color;
}

void RGB::setColor(int red, int green, int blue){
    delete this->color;
    r_out->write(toFloat(red));
    g_out->write(toFloat(green));
    b_out->write(toFloat(blue));
    this->color = new Color(red, green, blue);
}

void RGB::setColor(int color){
    delete this->color;
    Color* kleur = new Color(color);
    r_out->write(toFloat(kleur->getRed()));
    g_out->write(toFloat(kleur->getGreen()));
    b_out->write(toFloat(kleur->getBlue()));
    this->color = kleur;
}

Color* RGB::getColor(){
    return color;
}
    