#ifndef Acc_Giro_H
#define Acc_Giro_H

/**
 * Includes
 */
#include "mbed.h"
#include "ADXL345_I2C.h"
#include "ITG3200.h"
#include "IMUfilter.h"

/**
 * Defines
 */
//Gravity at Earth's surface in m/s/s
#define g0 9.812865328
//Number of samples to average.
#define SAMPLES 4
//Number of samples to be averaged for a null bias calculation
//during calibration.
#define CALIBRATION_SAMPLES 128
//Convert from radians to degrees.
#define toDegrees(x) (x * 57.2957795)
//Convert from degrees to radians.
#define toRadians(x) (x * 0.01745329252)
//ITG-3200 sensitivity is 14.375 LSB/(degrees/sec).
#define GYROSCOPE_GAIN (1 / 14.375)
//Full scale resolution on the ADXL345 is 4mg/LSB.
#define ACCELEROMETER_GAIN (0.004 * g0)
//Sampling gyroscope at 200Hz.
#define GYRO_RATE   0.002
//Sampling accelerometer at 200Hz.
#define ACC_RATE    0.002
//Updating filter at 100Hz.
#define FILTER_RATE 0.01
#define CORRECTION_MAGNITUDE 50
 
class Acc_Giro {

public:

    //Constructor.
     Acc_Giro();
    //destructeur
   // ~Acc_Giro();
    
    //Set up the ADXL345 appropriately.
    void initializeAccelerometer(void);
    //Calculate the null bias.
    void calibrateAccelerometer(void);
    //Take a set of samples and average them.
    void sampleAccelerometer(void);
    //Set up the ITG3200 appropriately.
    void initializeGyroscope(void);
    //Calculate the null bias.
    void calibrateGyroscope(void);
    //Take a set of samples and average them.
    void sampleGyroscope(void);
    //Update the filter and calculate the Euler angles.
    void filter(void);
    void GetI2CAddress();
    void dataSender(void);
    
    //membre classe
    IMUfilter *imuFilter; 
    ADXL345_I2C *accelerometer;
    I2C *i2c;
    ITG3200 *gyroscope;
    Ticker accelerometerTicker;
    Ticker gyroscopeTicker;
    Ticker filterTicker;
    Ticker dataTicker;
    Ticker algorithmTicker; 
    
   
    
    int calibrate;
    int calibrated;
    int start;
    int started;
    int alg_enable;
    
    char data[128];
    //Offsets for the gyroscope.
    //The readings we take when the gyroscope is stationary won't be 0, so we'll
    //average a set of readings we do get when the gyroscope is stationary and
    //take those away from subsequent readings to ensure the gyroscope is offset
    //or "biased" to 0.
    double w_xBias;
    double w_yBias;
    double w_zBias;
    
    //Offsets for the accelerometer.
    //Same as with the gyroscope.
    double a_xBias;
    double a_yBias;
    double a_zBias;
    
    //Accumulators used for oversampling and then averaging.
    volatile double a_xAccumulator;
    volatile double a_yAccumulator;
    volatile double a_zAccumulator;
    volatile double w_xAccumulator;
    volatile double w_yAccumulator;
    volatile double w_zAccumulator;
    
    //Accelerometer and gyroscope readings for x, y, z axes.
    volatile double a_x;
    volatile double a_y;
    volatile double a_z;
    volatile double w_x;
    volatile double w_y;
    volatile double w_z;
    
    //Buffer for accelerometer readings.
    int readings[3];
    //Number of accelerometer samples we're on.
    int accelerometerSamples;
    //Number of gyroscope samples we're on.
    int gyroscopeSamples;
 
 };
 
 
 
 #endif /* PID_H */