 /* Copyright (c) 2012 - 2013 Gaëtan PLEYBER
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description
 * Input
 * Output
 */

#include "mbed.h"                    
#include "mbos.h"
#include "Module_Communication.h"
#include "Module_Mouvement.h"
#include "Acc_Giro.h"
 
#define TASK1_ID                1       // Id for task 1 (idle task is 0)
#define TASK1_PRIO              50      // priority for task 1
#define TASK1_STACK_SZ          32      // stack size for task 1 in words 
#define TASK2_ID                2       // Id for task 2 
#define TASK2_PRIO              60      // priority for task 2
#define TASK2_STACK_SZ          32      // stack size for task 2 in words 
#define TIMER0_ID               0       // Id for timer 0
#define TIMER0_PERIOD           1000    // Time period in milliseconds
#define TIMER0_EVENT            1       // Event flag (1 << 0)
#define T1_TO_T2_EVENT          2       // Event flag (1 << 1)

void task1(void);                       // task function prototypes
void task2(void);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
mbos os(2, 1);                          // Instantiate mbos with 2 tasks & 1 timer 
Acc_Giro Acc_Giro_test; 
Serial pc(USBTX, USBRX);  

int main(void)
{
    //Initialize inertial sensors.
    Acc_Giro_test.initializeAccelerometer();
    Acc_Giro_test.initializeGyroscope();
          
    Timer tmr;
    tmr.start();
    
    pc.printf("test started");
    Acc_Giro_test.calibrate=1;
    
    while(true)
    {
        //Net::poll();
        if(tmr.read() > 0.2){
           // led4=!led4;
            tmr.reset();
            wait(0.5);
        pc.printf("Ax:%f Ay:%f Az:%f || Gx:%f Gy:%f Gz:%f\n", Acc_Giro_test.a_x, Acc_Giro_test.a_y, Acc_Giro_test.a_z, toDegrees(Acc_Giro_test.imuFilter->getRoll()), toDegrees(Acc_Giro_test.imuFilter->getPitch()), toDegrees(Acc_Giro_test.imuFilter->getYaw()));
           
        }
        
        if(Acc_Giro_test.calibrate && !Acc_Giro_test.calibrated){
            Acc_Giro_test.calibrateAccelerometer();
            Acc_Giro_test.calibrateGyroscope();
            led2 = 1;
            Acc_Giro_test.calibrated = 1;
            Acc_Giro_test.start = 1;
          pc.printf("Calibrated\n");
        }
        
        
        if(Acc_Giro_test.calibrated && Acc_Giro_test.start && !Acc_Giro_test.started){
         
            //Accelerometer data rate is 500Hz, so we'll sample at this speed.
            Acc_Giro_test.accelerometerTicker.attach(&Acc_Giro_test, &Acc_Giro::sampleAccelerometer, 0.002);
            //Gyroscope data rate is 500Hz, so we'll sample at this speed.
            Acc_Giro_test.gyroscopeTicker.attach(&Acc_Giro_test, &Acc_Giro::sampleGyroscope,  0.002);
            //Update the filter variables at the correct rate.
            Acc_Giro_test.filterTicker.attach(&Acc_Giro_test, &Acc_Giro::filter, FILTER_RATE);
            //Acc_Giro_test.dataTicker.attach(&Acc_Giro_test, &Acc_Giro::dataSender, 0.2);
           // Acc_Giro_test.algorithmTicker.attach(&algorithm, 0.001);
            Acc_Giro_test.started = 1;
        }  
        
        
    }  
}

void task1(void)
{
    os.SetTimer(TIMER0_ID, TIMER0_PERIOD, TIMER0_PERIOD);
    while(1){
        os.WaitEvent(TIMER0_EVENT);
        led1 = !led1;
        os.SetEvent(T1_TO_T2_EVENT, TASK2_ID);
    }
}

void task2(void)
{
    while(1){
        os.WaitEvent(T1_TO_T2_EVENT);
        led2 = 1;
        wait_ms(100);
        led2 = 0;
   }
}
/*@endcode
 */