 /* Copyright (c) 2012 - 2013 AUTHEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description
 * Input
 * Output
 */
 
 #ifndef MODULE_MOUVEMENT_H
 #define MODULE_MOUVEMENT_H
 
 #include "mbos.h"
 #include "Service.h"
 #include "mbed.h"
 

 
 class ModuleMouvement
 {
 private :
    /* ATTRIBUTS */
    PwmOut * m_motor1;
    PwmOut * m_motor2;
    PwmOut * m_motor3;
    PwmOut * m_motor4;
    
    
    /*Parametres*/
    int pVitesseFonctionnement;
    /*commande*/
    int m_uiCommand;
    float m_uiDistance;
    
 
 public :
 
    /* Get param*/
    int GetpVitesseFonctionnement();
    int GetuiCommand();
    float GetuiDistance();
    
    
    
    /*Set param*/
    void SetpVitesseFonctionnement(int);
    void SetuiCommand(int);
    void SetuiDistance(float);
    
    /* CONSTRUCTEUR(S) */
    ModuleMouvement();
    //faut-il un constructeur pour initialiser les moteur (vol stationnaire à l'allumage de 20cm)?
    
    /* DESTRUCTEUR */
    ~ModuleMouvement();
    
    /* METHODES */
    /* Point d'entrée de la tache du Module Mouvement */
    void ModuleMouvement_Task(void);
    void GestionVitesseMotors(int m_uiCommand, float m_uiDistance);
    void GestionStabilisation(void);
    void VolStationnaire(void);
    void TestMotor(void);
    void InitMotor(void);
    void DeconnexionMotor(void);
 
    /* FONCTIONS */
 
 };
 
 #endif