     /* Copyright (c) 2012 - 2013 AUTHEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description
 * Input
 * Output
 */
 
 #include "Module_Mouvement.h"
 
 // Pointeur sur la classe systeme d'exploitation instancié dans le main
 extern mbos *os;
 
 //communication série USB
 Serial pc1(USBTX,USBRX);
    
 
 /* CONSRTRUCTEUR(S) */
 ModuleMouvement::ModuleMouvement()
 {
 m_motor1 = new PwmOut (p23);
 m_motor2 = new PwmOut (p24);
 m_motor3 = new PwmOut (p25);
 m_motor4 = new PwmOut (p26); 
 }
 
 /* DESTRUCTEUR */
 ModuleMouvement::~ModuleMouvement()
 {
 delete m_motor1;
 delete m_motor2;
 delete m_motor3;
 delete m_motor4;
 }
 
 
 /*Get*/ 
 int ModuleMouvement::GetpVitesseFonctionnement()
  { return pVitesseFonctionnement; } 
  
 int ModuleMouvement::GetuiCommand()
  { return m_uiCommand; }
  
 float ModuleMouvement::GetuiDistance()
  { return m_uiDistance; } 
   
  
  /*Set*/
  void ModuleMouvement::SetpVitesseFonctionnement(int m)
   { pVitesseFonctionnement = m ; }
   
  void ModuleMouvement::SetuiCommand(int n)
   { m_uiCommand = n ; }
   
  void ModuleMouvement::SetuiDistance(float o)
   { m_uiDistance = o ; }
   
   
 
 /* Point d'entrée de la tache Module Mouvement */
 void ModuleMouvement::ModuleMouvement_Task(void)
 {
    //init moteurs
    InitMotor();
    
    //décollage
    m_uiCommand = 0;
    m_uiDistance = 0.6; //60cm 
    GestionVitesseMotors(m_uiCommand, m_uiDistance);
     
    
    while(1){
   
    //vol stationnaire
    //attente recuperation commande provenant de trajectoire,
    VolStationnaire();
     
    // gestion motors
    GestionVitesseMotors(m_uiCommand, m_uiDistance);
    
    
    // gestion stabilisation
    }
 }
 
 void ModuleMouvement::VolStationnaire(void)
 {
     m_motor1->write(0.68); // a def
     m_motor2->write(0.68); // a def
     m_motor3->write(0.68); // a def
     m_motor4->write(0.68); // a def
     /*while ( pas de nouvelle commande )
      {
        wait(0.1);
      }*/
      
     return;
 }
 
 void ModuleMouvement::GestionVitesseMotors(int m_uiCommand, float m_uiDistance)
 {
    bool CommandFin = false;
    
     switch (m_uiCommand)
      {
        /*haut*/      
        case 0 :
        //Liste infos;
        break;
        
        /*bas*/
        case 1 :
        //liste infos;
        break;
        
        /*rotation gauche*/
        case 2 :
        //liste infos;
        break;
        
        /*rotation droite*/
        case 3 :
        //Liste infos;
        break;
        
        /*gauche*/
        case 4 :
        //Liste infos;
        break;
        
        /*droite*/
        case 5 :
        //liste infos;
        break; 
        
        /*avance*/
        case 6 :
        //Liste infos;
        break;
        
        /*recule*/
        case 7 :
        //Liste infos
        break;
     
        default :
        break;
        /*erreur pas de commande*/
   
        
      }
      CommandFin = true;
 }
 
 void ModuleMouvement::GestionStabilisation(void)
 {
 
 }
 
 void ModuleMouvement::TestMotor(void)
 {

       //frequence à 500Hz (init à 0.40 PWMmax = 0.99)
       m_motor1->period(0.002); 
       
       //initialisation, attends du premier bip
       for (float s= 0; s < 0.40; s += 0.01) 
       {
       m_motor1->write(s);
       m_motor2->write(s);
       m_motor3->write(s);
       m_motor4->write(s);
       wait(0.2); 
       pc1.printf("%f", s);
       }
       wait(2);
       
       m_motor1->write(0.96);
       m_motor2->write(0.96);
       m_motor3->write(0.96);
       m_motor4->write(0.96);
       pc1.printf("test motor");
       
       
 } 
 
 
 void ModuleMouvement::InitMotor(void)
 {
       //frequence à 500Hz (init à 0.40 PWMmax = 0.99)
       m_motor1->period(0.002);
       m_motor2->period(0.002);
       m_motor3->period(0.002);
       m_motor4->period(0.002);
       
       //frequence à 400HZ  (attention : init à 0.30 et PWMmax=0.85, trés rapide à l'acceleration )
       //m_motor1->period(0.0025);
       
       //initialisation, attends du premier bip
       for (float s= 0; s < 0.40; s += 0.01) 
       {
       m_motor1->write(s);
       m_motor2->write(s);
       m_motor3->write(s);
       m_motor4->write(s); 
       wait(0.02); 
       pc1.printf("%f", s);
       }
       wait(1);      
 }
 
 
  void ModuleMouvement::DeconnexionMotor(void)
 {
       //deconnexion 
       for(float s= 0.40; s > 0; s-= 0.01)
       {
       m_motor1->write(s); 
       m_motor2->write(s);
       m_motor3->write(s);
       m_motor4->write(s); 
       wait(0.02);
       pc1.printf("%f", s);
       }
       wait(1);
 }