///////////////////////////////////////////////////////////////////////////////////
// Machine A Etats (MAE) - Gestion d'un chronometre
// Cible : MBED LPC1768
// Langage C
//
// PhC OK le 02-03-2020
///////////////////////////////////////////////////////////////////////////////////
// INCLUDES
#include "mbed.h"
#include "TextLCD.h"

// DEFINES
// Definition des constantes etats
#define STOP    0
#define RUN    1
#define LAP   2


// Constantes generales
#define LCD_SIZE    20      // la taille de l'afficheur LCD


// PROTOTYPES
void Init(void) ;
void A01(),A02(),A03(),A04(),A05(),A06(),A08();
void affiche ();
void gestion();


// OBJETS
DigitalIn BPMS(p12);
DigitalIn BPLR(p11);
Timer T1;
TextLCD MyLCD(p26,p25,p21,p22,p23,p24,TextLCD:: LCD20x4);


// GLOBALS
// Variable d'etat
int iEtat, iMs_avant=0, iLr_avant=0,iLap=0;


// Variables de gestion Heure, Minute, Seconde, Dixieme
unsigned char byH, byM,byS, byD;


// MAIN
int main()
{
   // printf("\n\rDemarrage du programme\n\r") ;
    int iMs=0, iLr=0;
    Init() ;


    while(true) {
        iMs=BPMS.read();
        iLr=BPLR.read();
        switch(iEtat) {
            case STOP:
                if(iMs>iMs_avant) {
                   // printf("Evenement=MS\n\r");
                    A01();
                    //printf("Etat=RUN\n\r");
                    iEtat=RUN;
                   // wait(0.2);
                    break;
                }
                if(iLr>iLr_avant) {
                   // printf("Evenement=LR\n\r");
                    A08();
                   // printf("Etat=STOP\n\r");
                    iEtat=STOP;
                   // wait(0.2);
                    break;
                }
                break;

            case RUN:
                if(iMs>iMs_avant) {
                    //printf("Evenement=MS\n\r");
                    A02();
                    //printf("Etat=STOP\n\r");
                    iEtat=STOP;
                    //wait(0.2);
                    break;
                }
                if(iLr>iLr_avant) {
                    //printf("Evenement=LR\n\r");
                    A04();
                    //printf("Etat=LAP\n\r");
                    iEtat=LAP;
                    //wait(0.2);
                    break;
                }
                if(T1.read_ms()>=10) {
                    //printf("Evenement=TIME\n\r");
                    A03();
                    //printf("Etat=RUN\n\r");
                    iEtat=RUN;
                    break;
                }
                break;
            case LAP:
                if(iMs>iMs_avant) {
                    //printf("Evenement=MS\n\r");
                    A02();
                    //printf("Etat=STOP\n\r");
                    iEtat=STOP;
                    
                    break;
                }
                if(iLr>iLr_avant) {
                    //printf("Evenement=LR\n\r");
                    A05();
                    //printf("Etat=RUN\n\r");
                    iEtat=RUN;
                    break;
                }
                if(T1.read_ms()>=10) {
                    //printf("Evenement=TIME\n\r");
                    A06();
                    //printf("Etat=LAP\n\r");
                    iEtat=LAP;
                    break;
                }
                break;
        }



    } // end while
} // end main




///////////////////////////
// Les actions elementaires
///////////////////////////
void Init(void)
{
    BPMS.mode(PullDown);
    BPLR.mode(PullDown);
    // Etat initial
    iEtat = STOP ;
   // printf("Etat initial = STOP\n\r") ;

    MyLCD.cls();
    MyLCD.printf("Time=00.00.00.00.00\n\r");
    MyLCD.printf("Lap=0");
}
void A01()
{
    //printf("Action=A01\n\r");
    T1.start();
    affiche();
}

void A02()
{
    //printf("Action=A02\n\r");
    T1.stop();
    affiche();
}

void A03()
{
    //printf("Action=A03\n\r");
    T1.reset();
    affiche();
    gestion();
}

void A04()
{
    iLap++;
    wait(0.2);
    //printf("Action=A04\n\r");
}

void A05()
{
    //printf("Action=A05\n\r");
    affiche();
}

void A06()
{
    //printf("Action=A06\n\r");
    T1.reset();
    gestion();
}

void A08()
{
    //printf("Action=A08\n\r");
    byD=byS=byM=byH=0;
    MyLCD.cls();
    affiche();
}

void affiche()
{
    MyLCD.locate(0,0);
    //sprintf(,"TIME=%02d %02d %02d %02d",gbyH, gbyM, gbyS, gbyD);
    MyLCD.locate(0,0);
    MyLCD.printf("TIME=%02d:%02d:%02d:%02d:%02d\n\r",00,byH, byM, byS, byD);
    MyLCD.printf("LAP=%d",iLap);
} 

void gestion()
{
    byD++;
    if(byD>99) {
        byD=0;
        byS++;
        if(byS>59) {
            byS=0;
            byM++;
            if(byM>59) {
                byM=0;
                byH++;
                if(byH>23) byH=0;
            }
        }
    }
}