#include "mbed.h"

extern float TemporisationDemarreur,commandeLimite,comptDem,vitesseMin;
extern int courantLim;
extern int tensionMin, tensionMax;
extern char Etat_Precedant, Etat;
extern int compteur_Demarreur,compteur_Tempo;
extern char demInfini,infini;
DigitalIn frein(p12);
AnalogIn Volts(p20);
AnalogIn Ampere(p17);

void Etat_Futur() {
    switch (Etat_Precedant){
           //Etat normal
           case 0:
            if(frein.read()==1)
                Etat=6;
            else{
                if(Volts.read()*100<=tensionMin)
                    Etat=1;
                else{
                    if(Ampere.read()*48>=commandeLimite)
                        Etat=3;
                    else
                        Etat=0;
                }
            }
            break;
            // detection d'une batterie faible
            case 1:
                if(frein.read()==1)
                    Etat=6;
                else{
                    if(int(Volts.read()*100)>=(tensionMax))
                        Etat=0;
                    else
                    {
                        if((infini==0)&&(compteur_Demarreur>=(TemporisationDemarreur*10)))
                            Etat=2;
                        else
                            Etat=1;
                    }
                }
            break;
            //compteur du demarreur finit
            case 2:
                if(frein.read()==1)
                    Etat=7;
                else{
                    if(int(Volts.read()*100)>=(tensionMax))
                        Etat=0;
                    else
                        Etat=2;
                }
                break;
            //detection fort courant
            case 3:
                if(frein.read()==1)
                    Etat=6;
                else{
                    if(Ampere.read()*48>=commandeLimite)
                        Etat=0;
                    else
                    {
                        if(compteur_Tempo>=(comptDem*10))
                            Etat=4;
                        else
                            Etat=3;
                    }
                }
                break;
            // temporisation lors du fort courant fini
            case 4:
                if(frein.read()==1)
                    Etat=6;
                else{
                    if(Ampere.read()*48>=commandeLimite)
                         Etat=0;
                    else
                    {
                        if((infini==0)&&(compteur_Demarreur>=(TemporisationDemarreur*10)))
                        {
                            if(int(Volts.read()*100)<=(tensionMin))
                                Etat=2;
                            else
                                Etat=5;
                        }
                        else
                        Etat=4;
                    }
                }
                break;
            // fin du demarreur pour un fort courant
            case 5:
                if(frein.read()==1)
                    Etat=6;
                else{
                    if(Ampere.read()*48>=commandeLimite)
                         Etat=0;
                    else
                    {
                        if(int(Volts.read()*100)<=(tensionMin))
                             Etat=2;
                        else
                            Etat=5;
                    }
                }
                break;
            // freinage
            case 6 :
                if(frein==0)
                    Etat=0;
                else
                    Etat=6;
                break;
            // freinage lors de la recharge de la batterie
            case 7:
                if(frein==0)
                    Etat=0;
                else
                    Etat=7;
                break;
            }
}
        