#include "mbed.h"

extern char Etat_Precedant, Etat;
extern int compteur_Demarreur,compteur_Tempo;
extern char Demarreur, moteur, accelerateur;
DigitalOut led0(LED1);
DigitalOut led1(LED2);
DigitalOut led2(LED3);


void Etat_machine() {
    switch(Etat){
        ///Etat normal
        case 0:
            compteur_Demarreur=compteur_Tempo=0;
            Demarreur=moteur=accelerateur=0;
            led0=led1=led2=0;
            break;
        // detection d'une batterie faible
        case 1:
            compteur_Tempo=0;
            Demarreur=moteur=accelerateur=1;
            led0=1;
            led1=led2=0;
            break;       
        //compteur du demarreur finit     
        case 2:
            compteur_Demarreur=compteur_Tempo=0;
            Demarreur=0;
            moteur=accelerateur=1;
            led0=led2=0;
            led1=1;
            break;  
        //detection fort courant          
        case 3:
            compteur_Demarreur=0;
            Demarreur=moteur=accelerateur=0;
            led0=led1=1;
            led2=0;
            break;
        // temporisation lors du fort courant fini
        case 4:
            compteur_Tempo=0;
            Demarreur=moteur=1;
            accelerateur=0;
            led0=led1=0;
            led2=1;
            break;
        // fin du demarreur pour un fort courant
        case 5:
            compteur_Demarreur=compteur_Tempo=0;
            Demarreur=accelerateur=0;
            moteur=1;
            led1=0;
            led0=led2=1;
            break;
        // freinage
        case 6:
            compteur_Demarreur=compteur_Tempo=0;
            Demarreur=moteur=0;
            accelerateur=3;
            led0=0;
            led1=led2=1;
            break;
        // freinage lors de la recharge de la batterie
        case 7 :
            compteur_Demarreur=compteur_Tempo=0;
            Demarreur=0;
            moteur=1;
            accelerateur=3;
            led0=led1=led2=1;   
            break;
    }
}