/* A waterflow system based on a demo program for DebounceIn
 * Takuo WATANABE
 * http://mbed.org/users/takuo/code/DebounceIn/
 * Uses a rotary encoder Ky-040 and a YF-S201 as a water flow sensor
 */

#include "mbed.h"
#include "DebounceIn.h"
#include "TextLCD.h"
DigitalOut rele(PA_12);
DigitalOut led(PC_13);
I2C i2c_lcd(PB_9,PB_8); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type 
InterruptIn sensor(PA_15);// Interrupt pin for the water flow sensor YF-S201
float Calc; //The sensor gives 450 pulses per liter
float FlowMililiter,TotalMililiter,mil; //Variables to calculate the water flow
float CorrectionFactor=0.23;//to correct the volume through the sensor
int NbTopsFan; // To keep track os YF-S201 pulses
DebounceIn buttonSW(PB_6);//Roary encoder button switch
DebounceIn buttonA(PB_3);//CLK of sensor. Pin to generate the interrupt
bool flag=false; //flag used to control the program
volatile float virtualPosition=0;//Position of the shaft



int i=0;

void lcd_initiation()
        {
        lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
        lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn /LightOff BackLight is on!!
        lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn
        
        }

void setpoint()
{    
    lcd.cls();
    lcd.locate(5,0);
    lcd.printf("ZarBeer");
    lcd.locate(0,1);
    lcd.printf("Setpoint:  %.1f",virtualPosition);
}
       


void cw() {if (!DigitalIn(PB_4)) virtualPosition+=0.5;
                else
                virtualPosition-=0.5;
            if(virtualPosition>20){virtualPosition=20;}
            if(virtualPosition<0){virtualPosition=0;}
            setpoint();
          }
   
void rpm()     //This function increments on the rising edge of the hall effect sensors signal
{ 
  NbTopsFan++;  
}   
        
//After define the set point the valve is open and the water is added until the setpoint.
void adiciona()
    { 
   while(1) {
        rele=1;//Open solenoid valve 
        NbTopsFan = 0;                  //Set NbTops to 0 ready for calculations
        
        sensor.rise(&rpm);              //Enables rising edge interrupt
        wait_ms(1000);                  //Wait 1 second and count HALL pulses
        sensor.rise(NULL);              //Disable interrupt
                
        Calc = (NbTopsFan / 7.5)*(1+CorrectionFactor);  //(Pulse frequency x 60) / 7.5Q, = flow rate in L/hour
        FlowMililiter=Calc/60;//Flow in minutes. The sensor gives Pulse Frequency/7.5 equals l/min
        TotalMililiter+=FlowMililiter;//Add the flow to calculate the total volume that was added.
        lcd.cls(); //Clear the LCD screen
        lcd.locate(0,0);//
        lcd.printf("Fl:%.2f",Calc);
        lcd.locate(0,1);
        lcd.printf("V:%.2f",TotalMililiter);
        lcd.locate(8,1);
        lcd.printf("SP: %.1f",virtualPosition);
           if(TotalMililiter>=virtualPosition) 
           {rele=0; //Turn off solenoid valve 
           lcd.cls();
           lcd.locate(0,1);
           lcd.printf("     Acabou!");
           led=0;
           Calc=0;
           FlowMililiter=0;
           TotalMililiter=0;
           virtualPosition=0;
           wait(3);
           return;
            }
            
        }
    }
    //Set the desired volume
void confirma() {
    
    lcd.locate(0,1);
    lcd.printf("Confirma: %.1f L", virtualPosition);
    while(flag==true) {
        led=1;
    }
    return;
        }
void SW() {
        lcd.cls();
    if (flag==true) {flag=false;}
    else {flag=true;}
            }
            

int main() {
    lcd_initiation();
 
    
    buttonA.rise(cw);
    buttonSW.fall(SW);
    while (true) {
       if (flag==true){
        confirma();
        adiciona(); 
        
        }
    }
}
