
/*
Copyright (c) 2015 John Magyar

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef QT2100_H
#define QT2100_H

#include "mbed.h"

/*

Header file for the Atmel QT2100 Capacative Touch sensor device Mbed library.

The QT2100 is a capacitive touch controller device with 10 configurable QTouch channels,
supporting up to seven touch buttons, and either a single slider (or wheel).

Datasheet: http://www.atmel.com/images/at42qt2100_e_level0%2013ww04.pdf

*/

class QT2100
{
public:
    QT2100(PinName mosi,
           PinName miso,
           PinName sck,
           PinName cs,
           PinName tx,
           PinName rx);
    ~QT2100();

public:
    void init();
    void terminalDisplay();
    void xfer3bytes(int byte0, int byte1, int byte2);
    void verifyChannels();
    void devId();
    int8_t keys();
    int8_t slider();
    int8_t wheel();

private:
    SPI        _spi;
    DigitalOut _cs;
    Serial     _pc;
};

#endif // QT2100_H
