#include "mbed.h"
#include "TextLCD.h"
#include "DHT.h"

DigitalOut myled(LED1);
DHT sensor(p21,DHT11);

TextLCD lcd(p15, p16, p17, p18, p19, p20); 

int main() {
     
    int err;
    float T;
    float H;
    
    while (1) {
        myled = 1;
        err = sensor.readData();
        wait(1);
        T = sensor.ReadTemperature(CELCIUS);
        H = sensor.ReadHumidity();
        
        if (err == 0) 
        {
            lcd.printf(" Temp:%4.2f C \n",T);
            lcd.printf("  Hum:%4.2f \n",H);
        } 
        myled = 0;
        wait(1);
    }
}
    

