#define SCLK   p14
#define IO     p13
#define CE     p12

//Comment this line if the DS1302 is already running
#define INITIAL_RUN

#include "mbed.h"
#include "DS1302.h"

DS1302 clk(SCLK, IO, CE);

int main() {
    #ifdef INITIAL_RUN
    clk.set_time(1543510189);
    #endif
    
    char storedByte = clk.recallByte(0);
    //printf("\r\nStored byte was %d, now increasing by one\r\n", storedByte);
    clk.storeByte(0, storedByte + 1);
    
    while(1) {
        time_t seconds = clk.time(NULL);
        printf("Fecha - Hora = %s\r", ctime(&seconds));
        wait(1);
    }
}
