#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "Websocket.h"
#include <stdio.h>
#include "SimpleSMTPClient.h"

#define SERIAL 4
#define SIGNAL_LEN 256

#define DOMAIN "smtp2go.com"
#define SERVER "mail.smtp2go.com"//"aspmx.l.google.com" 
#define PORT "2525" // Port 25 doesn't require TSL
#define USER "arlindonm"
#define PWD "SmartMeter"
#define FROM_ADDRESS "arlindonm@smtp2go.com"
// less than 128 characters.
#define TO_ADDRESS "arlindonm@gmail.com" 
#define SUBJECT "EnergySmartMeter msg"

IWDG_HandleTypeDef hiwdg;

const char* SERVER_ADDRESS = "200.133.229.238";
//const char* SERVER_ADDRESS = "192.168.1.110";
const int SERVER_PORT = 1080;

bool STOPEMAIL = true,flagSendNoBreak=0;

Ticker tickerTensaoCorrente;

//8 pinos da placa
AnalogIn correnteA(PC_2);
AnalogIn correnteB(PC_3);
//-
//tx
//rx
DigitalOut scale(PD_7);  
DigitalOut  getVoltagem(PE_3);
//gnd

//4pinos da placa
DigitalOut  picWatchDog(PC_11);
AnalogIn tensaoA(PC_0);
DigitalIn  noBreak(PD_3);
//DigitalIn   xxx(PG_2);


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
int cntTick=0;
int cntTickHora=0;
int cntSinal=0;
int cntBK=0;
bool flagHorVerao=true,scaleIA=0,scaleIB=0,scaleIC=0;
unsigned int energiaA = 0,energiaB=0,energiaC=0;
//int vetorTensaoA[62];
//int vetorTensaoB[62];
//int vetorTensaoC[62];
int vetorCorrenteA[62];
int vetorCorrenteB[62];
int vetorCorrenteC[62];


int sinalVA[SIGNAL_LEN];
int sinalVB[SIGNAL_LEN];
int sinalVC[SIGNAL_LEN];
int sinalIA[SIGNAL_LEN];
int sinalIB[SIGNAL_LEN];
int sinalIC[SIGNAL_LEN];

//int rmsVA,rmsVB,rmsVC;
int rmsIA,rmsIB,rmsIC;
char serBuf[50],strTimeInterrupt[50],strTimeReturn[50],str485[300];
char picCmd;

bool EthernetOK=false,flagNoBreak=false;
    time_t seconds;
bool flagSend=false;

EthernetInterface eth;

TCPSocketServer     server;
TCPSocketConnection client;
bool serverIsListening = false;

DigitalOut sw(LED2); 

RawSerial serial(USBTX,USBRX);//(USBTX,USBRX); //tx,rx
RawSerial serialPic(PD_5,PD_6);
RawSerial serialRS485(PE_8,PE_7);

int cnt=0;

string              httpHeader;     // HTTP header
string              httpContent;    // HTTP content
const string        HTTP_OK = "HTTP/1.0 200 OK";

NTPClient ntp;


void setClock()
{
    
    int res =ntp.setTime("0.uk.pool.ntp.org");
    if ( res == 0)
    {
        time_t ctTime;
        ctTime = time(NULL);
        //serial.printf("Time is set to : %s \r\n", ctime(&ctTime));
        int fusoBR= -10800;//-3*3600 
        if(flagHorVerao) fusoBR= -7200;
        set_time(ctTime+ fusoBR);
        char strtime[80];
        time_t seconds;
        seconds = time(NULL);
        strftime(strtime, 20, "%D %H:%M:%S\n", localtime(&seconds));
        //serial.printf("Hora:%s", strtime);
    }
    else
    {
        serial.printf("Error getting time \r\n");
    }        
}


void getSinal()
{

    for(int j=0;j<SIGNAL_LEN;j++)
    {
        getVoltagem=1;
        sinalVA[j]=(int)1000*tensaoA.read();
        sinalVB[j]=(int)1000*tensaoA.read();        
        sinalVC[j]=(int)1000*tensaoA.read();
        getVoltagem=0;
        sinalIA[j]=(int)1000*correnteA.read();
        sinalIB[j]=(int)1000*correnteB.read();
        sinalIC[j]=(int)1000*tensaoA.read();
        wait_us(240);  //4ciclos           
    }
}
void Rms()
{
    
    getSinal();
    float somaVA=0,somaVB=0,somaVC=0,somaIA=0,somaIB=0,somaIC=0;
    float dcVA,dcVB,dcVC,dcIA,dcIB,dcIC;
    //DC
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        //somaVA = somaVA + sinalVA[j];
        //somaVB = somaVB + sinalVB[j];
        //somaVC = somaVC + sinalVC[j];
        somaIA = somaIA + sinalIA[j];
        somaIB = somaIB + sinalIB[j];
        somaIC = somaIC + sinalIC[j];
    }
    //dcVA = somaVA/SIGNAL_LEN;
    //dcVB = somaVB/SIGNAL_LEN;
    //dcVC = somaVC/SIGNAL_LEN;
    dcIA = somaIA/SIGNAL_LEN;
    dcIB = somaIB/SIGNAL_LEN;
    dcIC = somaIC/SIGNAL_LEN;
    //serial.printf("\ndcIA = %f  dcIB = %f",dcIA,dcIB);
    somaVA=somaVB=somaVC=somaIA=somaIB=somaIC=0;
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        //somaVA = somaVA + ((sinalVA[j]-dcVA) * (sinalVA[j]-dcVA));
        //somaVB = somaVB + ((sinalVB[j]-dcVB) * (sinalVB[j]-dcVB));
        //somaVC = somaVC + ((sinalVC[j]-dcVC) * (sinalVC[j]-dcVC));
        somaIA = somaIA + ((sinalIA[j]-dcIA) * (sinalIA[j]-dcIA));
        somaIB = somaIB + ((sinalIB[j]-dcIB) * (sinalIB[j]-dcIB));
        somaIC = somaIC + ((sinalIC[j]-dcIC) * (sinalIC[j]-dcIC));
    }
     //serial.printf("\nsomaIA = %f  somaIB = %f",somaIA,somaIB);
    //rmsVA =  (int)sqrt(somaVA / SIGNAL_LEN);
    //rmsVB =  (int)sqrt(somaVB / SIGNAL_LEN);
    //rmsVC =  (int)sqrt(somaVC / SIGNAL_LEN);
    scaleIA=scaleIB=scaleIC=0;
    rmsIA =  (int)sqrt(somaIA / SIGNAL_LEN);
    if(rmsIA> 50)
        scaleIA=1;
    rmsIB =  (int)sqrt(somaIB / SIGNAL_LEN);
    if(rmsIB> 50)
        scaleIB=1;    
    rmsIC =  (int)sqrt(somaIC / SIGNAL_LEN);
    if(rmsIC> 50)
        scaleIC=1;
    //serial.printf("\nrmsIA = %d  rmsIB = %d",rmsIA,rmsIB);
        
}
void TickTensaoCorrente()
{
    led2=!led2;
               
    Rms();   
    //if(scaleIA||scaleIB||scaleIC)
    //    Rms();    
    if(rmsIA-4<2)rmsIA=4;
    if(rmsIB-4<2)rmsIB=4;
    if(rmsIC-4<2)rmsIC=4;
    energiaA += rmsIA-4;
    energiaB += rmsIB-4;
    energiaC += rmsIC-4;    
       
    //vetorTensaoA[cntTick]=rmsVA;
    //vetorTensaoB[cntTick]=rmsVB;
    //vetorTensaoC[cntTick]=rmsVC;
    vetorCorrenteA[cntTick]=rmsIA-4;
    vetorCorrenteB[cntTick]=rmsIB-4;
    vetorCorrenteC[cntTick]=rmsIC-4;

    cntTick++;
    cntTickHora++;
    if(cntTick>61) cntTick=0; //ERRO
       
    

}

int sendData()
{
     char str[7000]=""; //A conta tem que ser certa!!!
     TCPSocketConnection socket;
    while (socket.connect(SERVER_ADDRESS, SERVER_PORT) < 0) 
    {
        serial.printf("Unable to connect to (%s) on port (%d)\n", SERVER_ADDRESS, SERVER_PORT);
        wait(1);
        return -1;
    }  
    time_t ctTime;
    ctTime = time(NULL);
    sprintf(str,"%d;%s;",SERIAL,ctime(&ctTime));
    
    /*strcat(str,"VA;"); //Nao precisa enviar a tensao pois e' quase cte a cada 5s
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorTensaoA[i]);//tensao cada 5s
    
    strcat(str,"VB;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorTensaoB[i]);//tensao cada 5s
    
    strcat(str,"VC;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorTensaoC[i]);//tensao cada 5s
    */    
   // strcat(str,"E");

    sprintf(str,"%s%10d%10d%10d",str,energiaA,energiaB,energiaC);
    
    
    strcat(str,"IA");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d",str,vetorCorrenteA[i]);//correntecada 10s   
    
    strcat(str,"IB");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d",str,vetorCorrenteB[i]);//correntecada 10s
        
    strcat(str,"IC");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d",str,vetorCorrenteC[i]);//correntecada 10s
        
    //--------------
    
    getSinal();
    sprintf(str,"%sSVA",str);
    for(int j=0;j<SIGNAL_LEN;j++)
        sprintf(str,"%s%03d",str,sinalVA[j]);//sinal tensao    
    
    sprintf(str,"%sSVB",str);
    for(int j=0;j<SIGNAL_LEN;j++)
        sprintf(str,"%s%03d",str,sinalVB[j]);//sinal tensao   
    
    sprintf(str,"%sSVC",str);
    for(int j=0;j<SIGNAL_LEN;j++)
        sprintf(str,"%s%03d",str,sinalVC[j]);//sinal tensao
    
    //-----------------
    sprintf(str,"%sSIA",str);
    for(int j=0;j<SIGNAL_LEN;j++)
        sprintf(str,"%s%03d",str,sinalIA[j]); 
    
    sprintf(str,"%sSIB",str);
    for(int j=0;j<SIGNAL_LEN;j++)
        sprintf(str,"%s%03d",str,sinalIB[j]);
    
    sprintf(str,"%sSIC",str);
    for(int j=0;j<SIGNAL_LEN;j++)
        sprintf(str,"%s%03d",str,sinalIC[j]);    
    
    
    sprintf(str,"%sRS485%s$\0",str,str485);      
    
    int ret = socket.send(str, sizeof(str) - 1);
    serial.printf("Socket send n: %d\n",ret);
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    serial.printf("Received % d message from server: '%s'\n",n, buf);
    socket.close();
    if(buf[0]=='1')
     STOPEMAIL=false;
    else
    STOPEMAIL = true; 
    
    if(n>=1)
    return 0; 
    else
    return -1;
    
}
int sendNoBreak()
{
     TCPSocketConnection socket;
    while (socket.connect(SERVER_ADDRESS, SERVER_PORT) < 0) 
    {
        serial.printf("Unable to connect to (%s) on port (%d)\n", SERVER_ADDRESS, SERVER_PORT);
        wait(1);
        return -1;
    }  
    char str[256];
    
    sprintf(str,"%d;\nQueda de Energia: %s\nRetorno de Energia: %s$",SERIAL,strTimeInterrupt,strTimeReturn);
    socket.send(str, sizeof(str) - 1);
    
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    serial.printf("Received % d message from server: '%s'\n",n, buf);
    socket.close();
    if(buf[0]=='1')
     STOPEMAIL=false;
    else
    STOPEMAIL = true; 
     
    if(n>=1)
    {
        flagSendNoBreak = true;
        return 0; 
    }
    else
    return -1;
    
}
int sendEmail()
{   
    /*SimpleSMTPClient smtp;
    int ret;
    char str[36560];
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress(TO_ADDRESS);
    
    smtp.setMessage(SUBJECT,"Mensagen enviada por e-mail\n");

    time_t ctTime;
    ctTime = time(NULL);
    sprintf(str,"Energy Smart Meter - Serial A1%04d.\nHora da placa: %s",SERIAL,ctime(&ctTime));
    smtp.addMessage(str);
    ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN,PORT,SMTP_AUTH_LOGIN);
    strcpy(str,"VA;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorTensaoA[i]);//tensao cada 5s
    smtp.appendMessage(str);
    strcpy(str,"VB;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorTensaoB[i]);//tensao cada 5s
    smtp.appendMessage(str);
    strcpy(str,"VC;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorTensaoC[i]);//tensao cada 5s
    smtp.appendMessage(str);
    
    strcpy(str,"IA;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorCorrenteA[i]);//corrente cada 5s
    smtp.appendMessage(str);
    
    strcpy(str,"IB;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorCorrenteB[i]);//corrente cada 5s
    smtp.appendMessage(str);
    
    strcpy(str,"IC;");
    for(int i=0;i<60;i++)
        sprintf(str,"%s%03d;",str,vetorCorrenteC[i]);//corrente cada 5s
    smtp.appendMessage(str);
    
    
    
    for(int i=0;i<5;i++)
    {
    sprintf(str,"SVA%d;",i);
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        sprintf(str,"%s%03d;",str,sinalVA[i][j]);//sinal tensao
        
    }
    smtp.appendMessage(str);
    }
    for(int i=0;i<5;i++)
    {
    sprintf(str,"SVB%d;",i);
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        sprintf(str,"%s%03d;",str,sinalVB[i][j]);//sinal tensao
        
    }
    smtp.appendMessage(str);
    }
    for(int i=0;i<5;i++)
    {
    sprintf(str,"SVC%d;",i);
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        sprintf(str,"%s%03d;",str,sinalVC[i][j]);//sinal tensao
        
    }
    smtp.appendMessage(str);
    }
    //-----------------
    for(int i=0;i<5;i++)
    {
    sprintf(str,"SIA%d;",i);
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        sprintf(str,"%s%03d;",str,sinalIA[i][j]);//sinal corrente
        
    }
    smtp.appendMessage(str);
    }
    for(int i=0;i<5;i++)
    {
    sprintf(str,"SIB%d;",i);
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        sprintf(str,"%s%03d;",str,sinalIB[i][j]);//sinal corrente
        
    }
    smtp.appendMessage(str);
    }
    for(int i=0;i<5;i++)
    {
    sprintf(str,"SIC%d;",i);
    for(int j=0;j<SIGNAL_LEN;j++)
    {
        sprintf(str,"%s%03d;",str,sinalIC[i][j]);//sinal corrente
        
    }
    smtp.appendMessage(str);
    }
    
    
   smtp.endMessage();
    if (ret) 
    {
        serial.printf("E-mail Transmission Error\r\n");
        return -1;           
    } 
    else
    {
        serial.printf("E-mail Transmission OK\r\n");
        return 0;
    }*/
}

void SerialPicReceiver()
{
        int i=0;
        char c;
        led1=!led1;
        while(1)  
        {
            //if(!serialPic.readable())
            //    break;
            c=serialPic.getc();
            serBuf[i++] = c;
            if(c=='\n'||i>49) break;
            
        }
        
        
}
void SerialRS485Receiver()
{
        int i=0;
        char c;
        led1=!led1;
        while(1)  
        {
            //if(!serialPic.readable())
            //    break;
            c=serialRS485.getc();
            str485[i++] = c;
            if(c=='\n'||i>258) break;
            
        }
        
        
}
void BackUpRam()
{
    serial.printf("BackUpRam:%d",++cntBK);
}
int main()
{
    serial.baud(115200);
    serialPic.baud(9600);
    
    led2=1;
    

 

    serial.printf("*** ENERGY SMART METER ***\r\n");
    serial.printf("Serial: %04d\n",SERIAL);

    if(eth.init()!=0)                    //for DHCP Server
    {
        //if(eth.init(IP,MASK,GATEWAY)!=0) { //for Static IP Address
        serial.printf("EthernetInterface Initialize Error \r\n");       
        led3=1;
        wait(2);
        NVIC_SystemReset();

    }

    if(eth.connect()!=0)
    {
        serial.printf("EthernetInterface Connect Error \r\n");
        led3=1;
        wait(2);
        NVIC_SystemReset();

       
    }
    tickerTensaoCorrente.attach(&TickTensaoCorrente,10);//cada 10s
    
    
    serial.printf("IP Address is %s\n", eth.getIPAddress());
 //   serial.printf("NetMask is %s\n", eth.getNetworkMask());
 //   serial.printf("Gateway Address is %s\n", eth.getGateway());
    //serial.printf("Ethernet Setup OK\n");
    //serial.printf("Getting time, 10s timeout. \r\n");
    setClock();
    int flagE=false,flagD=false;


//----------
   serialPic.attach(&SerialPicReceiver);
   serialPic.printf("*");//ler eeprom
   wait_ms(500);
   //serial.printf("SB: %s\n",serBuf);
   char aux[11];
   aux[10]=0;
   for(int i=0;i<10;i++)
    aux[i] =  serBuf[i];
   energiaA = atoi(aux); 
   serial.printf("EnergiaA: %d\n",energiaA); 
   for(int i=0;i<10;i++)
    aux[i] =  serBuf[i+10];
   energiaB = atoi(aux); 
   serial.printf("EnergiaB: %d\n",energiaB); 
   for(int i=0;i<10;i++)
    aux[i] =  serBuf[i+20];
   energiaC = atoi(aux); 
   serial.printf("EnergiaC: %d\n",energiaC); 
   
   
   for(int i=0;i<8;i++)
    aux[i] =  serBuf[i+30];
    aux[8]=0;
    sprintf(strTimeInterrupt,"%s ",aux);
    
   for(int i=0;i<2;i++)
    aux[i] =  serBuf[i+38];
    aux[2] =0; 
    sprintf(strTimeInterrupt,"%s%s:",strTimeInterrupt,aux);
    for(int i=0;i<2;i++)
    aux[i] =  serBuf[i+40];
    aux[2] =0; 
    sprintf(strTimeInterrupt,"%s%s",strTimeInterrupt,aux);
   serial.printf("Data Interrupcao de energia:\t%s\n",strTimeInterrupt);  
    //char strtime[30];
    time_t seconds;
    seconds = time(NULL);
    strftime(strTimeReturn, 20, "%D %H:%M\n", localtime(&seconds));   
    serial.printf("Data Retorno de energia:\t%s\n", strTimeReturn);  
    flagSendNoBreak=false;
    sendNoBreak();
//------
    serialRS485.attach(&SerialRS485Receiver);
    
    sprintf(str485,"%s","12345678901234567890123456789012345678901234567890");
    while(1)
    {
         if(noBreak==0 &&flagNoBreak==false)
        {
            serial.printf("Tensao Baixa\n");
            char strtime[14];
            time_t seconds;
            seconds = time(NULL);
            strftime(strtime, 14, "%D%H%M", localtime(&seconds));
            
            serialPic.printf("%10d%10d%10d%s#",energiaA,energiaB,energiaC,strtime);
            flagNoBreak=true;
            led3= 1;
        }
        
   
        if(cntTick>=60) //60 = 10minutos
        {  
                  
            tickerTensaoCorrente.detach();//??????????????????            
            cntTick=0; 
            
            serial.printf("Send data\n");  
            //WatchdogRefresh();   
            picWatchDog =0;
            flagD = sendData();
            picWatchDog =1;
            if(flagD!=0)  //0 = OK
            {
                wait(0.1);
                                
                picWatchDog =0;
                flagD = sendData();
                picWatchDog =1;
                if(flagD!=0)
                {
                    
                    if(!STOPEMAIL)//debug
                    {
                      picWatchDog =0;
                      flagE = sendEmail();
                      picWatchDog =1;
                    if(flagE!=0)
                    {
                    
                        picWatchDog =0;
                        flagE = sendEmail();                        
                        picWatchDog =1;
                    }
                    }
                }
            }
            if(flagD !=0 && flagE!=0)
                BackUpRam();            
            tickerTensaoCorrente.attach(&TickTensaoCorrente,10);//cada 5s
            
            
        }
        if(cntTickHora>720)//1hora
        {
            cntTickHora=0;
            if(flagSendNoBreak==false)
                sendNoBreak();
            setClock();        
        }
      //  if(flagD==0)
      //      led1=!led1;
        wait_ms(50);
    }
    

}
