#include "mbed.h"
#include "neopixel.h"                                   // Bibliothèque pour les LED's neopixel WS2812

#define nb_led                   3                      // Nombre de LED utiliser
#define tension_min              0.265f                 // Tension min de la pile égale à 0.9V
#define tension_max              0.455f                 // Tension max de la pile égale à 1.55V
#define tension_non_alcaline     0.6f                   // Tension d'une pile qui dépasse les 2V donc ce n'est pas alcaline
#define mode_max                 5                      // Nombre de mode
#define cycle_nb                 10                     // Le nombre de charge et décharge au meme temps

uint32_t rouge       = 0xFF0000;
uint32_t jaune       = 0xFFFF00;
uint32_t vert        = 0x00FF00;                        // Pour allumer les LED's
uint32_t bleu        = 0x0000FF;
uint32_t violet      = 0xFF00FF;
uint32_t non_couleur = 0x000000;

float    adj_lum     = 0.05f;                            // Adjustement de l'intensité lumineuse
float    mes_pile    = 0;                               // Mesurer la tension de la pile
int      mode        = 0;                               // Initialiser le mode

PwmOut charge(D9);                                      // Pin PWM charge
NeoPixelOut neoPixel(D11);                              // Pin DIN LED
Pixel pixels[nb_led];                                   // Fonction pour allumer les LED's
DigitalIn BP(D5, PullDown);                             // Bouton poussoir
AnalogIn  mes(A0);                                      // Mesure la tension de la pile
int etat_BP = 0;
//Fonctions
void init();                                            // Fonction pour Initialiser
void changement_mode();                                 // Fonction pour changer le mode
void led_init(float adj_lum);                           // Fonction pour initialiser les LED's
void led_reset();  
void eteindre_led(int led);                                   // Fonction pour étaindre les LED's
void led_controlle(int led, uint32_t color);            // Fonction pour controller les LED's

int main()
{
    init();
    //led_reset();
    
    while (1) {

        switch(etat_BP) {

            case 0 :
                if (BP) {
                    wait_ms(50);
                    changement_mode();
                    etat_BP ++;

                }
                break;

            case 1 :
                if (!BP) {

                    wait_ms(50);
                    etat_BP ++;
                }
                break;

            case 2 :
                etat_BP = 0;
                break;

            default :
                etat_BP = 0;
                break;
        }
    }
}


void init()
{
    led_init(adj_lum);
}
void changement_mode()
{
    mode++;

    switch(mode) {
        case 0:
            //led_reset();
            break;
        case 1:
            led_controlle(1, jaune);
            break;
        case 2:
            led_controlle(2, bleu);
            break;
        case 3:
            led_controlle(3, rouge);
            break;
        case 4:
            led_controlle(3, non_couleur);
            break;
        default:
            //led_reset();
            mode = 0;
            break;
    }
    wait_ms(10);
}

////////////////////////////////////  LED  ////////////////////////////////////
void led_init(float adj_lum)
{
    wait_ms(20); // wait for HSE to stabilize
    neoPixel.global_scale = adj_lum; // Adjust brightness
    neoPixel.normalize = false; // Equalize brightness to make r + g + b = 255
}

void led_reset()
{
    for(int i=1; i==4; i++) {
        //pixels[i].hex = non_couleur;
        led_controlle(i,jaune);
    }
}

void led_controlle(int led, uint32_t color)
{
    
    pixels[led-1].hex = color;
    neoPixel.send(pixels, nb_led);
}

void eteindre_led(int led)
{
    
    
}