#include "affichage.h"
#include <stdio.h>
FT800 TFT (PB_5,PB_4,PB_3,PA_8,PB_10,PA_9);                                         // mosi, miso, sck, cs, int, pd
char _phrase[50];

void EcranPrincipale()
{

    TFT.DLstart();                                                                  //
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));                                         //  Les 3 lignes sont à laisser tel quel pour le démarrage de l'afficheur
    TFT.DL(CLEAR(1, 1, 1));                                                         //
    TFT.FgColor(0xC618);
    TFT.DL(COLOR_RGB(0, 0, 0));                                                     // Couleur utilisée

    drawline(20,20,20,250);                                                         // Ligne verticale Gauche
    drawline(460,20,460,250);                                                       // Ligne verticale Droite

    drawline(20,20,460,20);                                                         // Ligne horizontale Haute
    drawline(20,250,460,250);                                                       // Ligne horizontale Basse


    // Partie Haute  avec  \\\\\\\\\\\\\

    drawline(0,0,20,20);
    drawline(20,20,40,40);
    drawline(55,20,35,0);
    drawline(90,20,70,0);
    drawline(130,20,110,0);
    drawline(165,20,145,0);
    drawline(200,20,180,0);
    drawline(220,40,200,20);
    TFT.Text(210,0,27,0,"L.V.H");                                                   // Affiche L.V.H
    drawline(240,40,260,20);
    drawline(260,20,280,0);
    drawline(300,20,320,0);
    drawline(340,20,360,0);
    drawline(380,20,400,0);
    drawline(420,20,440,0);
    drawline(460,20,480,0);
    drawline(460,20,440,40);


    // Partie Basse  avec  \\\\\\\\\\\\\

    drawline(0,270,20,250);
    drawline(20,250,40,270);
    drawline(60,250,80,270);
    drawline(100,250,120,270);
    drawline(140,250,160,270);
    drawline(180,250,200,270);
    TFT.Text(210,252,27,0,"BESANCON");                                              // Affiche BESANCON
    drawline(300,250,320,270);
    drawline(340,250,360,270);
    drawline(380,250,400,270);
    drawline(420,250,440,270);
    drawline(460,250,480,270);

    // Chapeau gauche avec  \\\\\\\\\\\\\


    drawline(0,40,20,60);
    drawline(0,80,40,120);
    drawline(20,140,0,160);
    drawline(20,180,0,200);
    drawline(20,220,0,240);

    // Chapeau droit avec  \\\\\\\\\\\\\

    drawline(440,120,480,80);
    drawline(460,60,480,40);
    //drawline(460,100,480,120);
    drawline(460,140,480,160);
    drawline(460,180,480,200);
    drawline(460,220,480,240);


    // Premier rectangle

    drawline(40,40,220,40);
    drawline(40,120,220,120);
    drawline(40,40,40,120);
    drawline(220,40,220,120);
    sprintf(_phrase,"FZ = %0.1f",FZ);
    TFT.Text(44,45,27,0,_phrase);
    TFT.Text(45,72,21,0,"FZ est le poids de");   // 21 Police petite
    TFT.Text(45,90,21,0,"portance de l'aile d'avion");


    // Differential pressure


    TFT.Text(30,125,21,0,"Diff. pressure");
    TFT.Text(50,140,21,0,"1 - 4");
    TFT.Text(30,165,21,0,"1 :");
    sprintf(_phrase,"%0.0fPa",CH0);
    TFT.Text(50,165,27,0,_phrase);
    TFT.Text(30,185,21,0,"2 :");
    sprintf(_phrase,"%0.0fPa",CH1);
    TFT.Text(50,185,27,0,_phrase);
    TFT.Text(30,205,21,0,"3 :");
    sprintf(_phrase,"%0.0fPa",CH2);
    TFT.Text(50,205,27,0,_phrase);
    TFT.Text(30,225,21,0,"4 :");
    sprintf(_phrase,"%0.0fPa",CH3);
    TFT.Text(50,225,27,0,_phrase);


    // Deuxième rectangle

    drawline(240,40,440,40);
    drawline(240,120,440,120);
    drawline(440,40,440,120);
    drawline(240,40,240,120);
    sprintf(_phrase,"FX = %0.1f",FX);
    TFT.Text(244,45,27,0,_phrase);
    TFT.Text(245,72,21,0,"FX est le poids de");
    TFT.Text(245,90,21,0,"trainee de l'aile d'avion");


    // Differential pressure


    TFT.Text(365,125,21,0,"Diff. pressure");
    TFT.Text(400,140,21,0,"5 - 8");
    TFT.Text(385,165,21,0,"5 :");
    sprintf(_phrase,"%0.0fPa",CH4);
    TFT.Text(410,165,27, 0,_phrase);
    TFT.Text(385,185,21,0,"6 :");
    sprintf(_phrase,"%0.0fPa",CH5);
    TFT.Text(410,185,27,0,_phrase);
    TFT.Text(385,205,21,0,"7 :");
    sprintf(_phrase,"%0.0fPa",CH6);
    TFT.Text(410,205,27,0,_phrase);
    TFT.Text(385,225,21,0,"8 :");
    sprintf(_phrase,"%0.0fPa",CH7);
    TFT.Text(410,225,27, 0,_phrase);



    // Aile d'avion

    drawline(160,160,355,175);  // Grande ligne haute
    drawline(160,160,140,170);  // trait tombant avant
    drawline(140,170,130,185);  // trait tombant avant
    drawline(355,175,365,185);  // Petit trait haut tombant derrière
    drawline(365,185,365,195);  // Trait entre les deux ailes derrière
    drawline(130,185,130,195);


    
    TFT.Text(140,180,21,0,"Angle inc.");
 
    sprintf(_phrase,"C : %0.0fdg M : %0.1fdg",AngleIncCons,AngleIncMes);
    TFT.Text(210,180,27, 0,_phrase);
    
 //   TFT.Number(270,180,27, 0, AngleIncMes);

    drawline(160,220,355,205);  // Grande ligne basse
    drawline(160,220,140,210);  // trait montant avant
    drawline(140,210,130,195);  // trait montant avant
    drawline(355,205,365,195);  // Petit trait haut montant derrière


    // Coordonnées aile au dessus

    drawline(140,169,120,169);  // 1er trait
    TFT.Text(115,169,20,0,"1.");
    drawline(160,158,150,148);  // 2ème trait
    TFT.Text(140,144,20,0,"2.");
    drawline(180,160,180,149);  // 3ème trait
    TFT.Text(170,146,20,0,"3.");
    drawline(210,162,210,152);  // 4ème trait
    TFT.Text(200,149,20,0,"4.");
    drawline(240,165,240,155);  // 5ème trait au dessus au milieu
    TFT.Text(230,152,20,0,"5.");
    drawline(275,168,275,158);  // 6ème trait
    TFT.Text(265,155,20,0,"6.");
    drawline(310,171,310,161);  // 7ème trait
    TFT.Text(300,158,20,0,"7.");
    drawline(345,174,345,164);  // 8ème trait
    TFT.Text(335,161,20,0,"8.");

    // coordonnées aile en dessous

    drawline(140,210,120,210);  // 1er trait
    TFT.Text(115,210,20,0,"1.");
    drawline(160,220,150,230);  // 2ème trait
    TFT.Text(140,220,20,0,"2.");
    drawline(180,220,180,230);  // 3ème trait
    TFT.Text(170,222,20,0,"3.");
    drawline(210,218,210,228);  // 4ème trait
    TFT.Text(200,220,20,0,"4.");
    drawline(240,215,240,225);  // 5ème trait en dessous au milieu
    TFT.Text(230,217,20,0,"5.");
    drawline(275,212,275,222);  // 6ème trait
    TFT.Text(265,216,20,0,"6.");
    drawline(310,209,310,219);  // 7ème trait
    TFT.Text(300,211,20,0,"7.");
    drawline(345,206,345,216);  // 8ème trait
    TFT.Text(335,208,20,0,"8.");





    TFT.DL(DISPLAY());                                                              // permet l'affichage sur l'ecran
    TFT.Swap();                                                                     // Permet l'affichage sur l'ecran


}

void EcranMessage(char *messageecr)
{

    TFT.DLstart();                                                                  //
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));                                         //  Les 3 lignes sont à laisser tel quel pour le démarrage de l'afficheur
    TFT.DL(CLEAR(1, 1, 1));                                                         //
    TFT.FgColor(0xC618);
    TFT.DL(COLOR_RGB(0, 0, 0));                                                     // Couleur utilisée

    drawline(20,20,20,250);                                                         // Ligne verticale Gauche
    drawline(460,20,460,250);                                                       // Ligne verticale Droite

    drawline(20,20,460,20);                                                         // Ligne horizontale Haute
    drawline(20,250,460,250);                                                       // Ligne horizontale Basse


    // Partie Haute  avec  \\\\\\\\\\\\\

    drawline(0,0,20,20);
    drawline(20,20,40,40);
    drawline(55,20,35,0);
    drawline(90,20,70,0);
    drawline(130,20,110,0);
    drawline(165,20,145,0);
    drawline(200,20,180,0);
    drawline(220,40,200,20);
    TFT.Text(210,0,27,0,"L.V.H");                                                   // Affiche L.V.H
    drawline(240,40,260,20);
    drawline(260,20,280,0);
    drawline(300,20,320,0);
    drawline(340,20,360,0);
    drawline(380,20,400,0);
    drawline(420,20,440,0);
    drawline(460,20,480,0);
    drawline(460,20,440,40);


    // Partie Basse  avec  \\\\\\\\\\\\\

    drawline(0,270,20,250);
    drawline(20,250,40,270);
    drawline(60,250,80,270);
    drawline(100,250,120,270);
    drawline(140,250,160,270);
    drawline(180,250,200,270);
    TFT.Text(210,252,27,0,"BESANCON");                                              // Affiche BESANCON
    drawline(300,250,320,270);
    drawline(340,250,360,270);
    drawline(380,250,400,270);
    drawline(420,250,440,270);
    drawline(460,250,480,270);

    // Chapeau gauche avec  \\\\\\\\\\\\\


    drawline(0,40,20,60);
    drawline(0,80,40,120);
    drawline(20,140,0,160);
    drawline(20,180,0,200);
    drawline(20,220,0,240);

    // Chapeau droit avec  \\\\\\\\\\\\\

    drawline(440,120,480,80);
    drawline(460,60,480,40);
    //drawline(460,100,480,120);
    drawline(460,140,480,160);
    drawline(460,180,480,200);
    drawline(460,220,480,240);

    TFT.Text(170,135,21,0,messageecr);

    TFT.DL(DISPLAY());                                                              // permet l'affichage sur l'ecran
    TFT.Swap();                                                                     // Permet l'affichage sur l'ecran


}


// permet de faire varier la luminosité 128 est le plus lumineux.
ft_void_t luminosite( ft_int32_t lum)
{
    TFT.DLstart();                                                                  // wait until after the swap
    TFT.MemWrite(REG_PWM_DUTY, 4);                                                  // write to the PWM_DUTY register
    TFT.StartFunc( FT_CMD_SIZE*1);
    TFT.SendCmd(lum);
    TFT.EndFunc( (FT_CMD_SIZE*1));
    TFT.Flush_Co_Buffer();                                                          // Download the command list into fifo
    TFT.WaitCmdfifo_empty();
}
ft_void_t drawline( ft_int32_t x0, ft_int32_t y0,ft_int32_t x1,ft_int32_t y1)
{
    TFT.DL(BEGIN(LINES));
    TFT.DL(VERTEX2F(x0*16,y0*16));
    TFT.DL(VERTEX2F(x1*16,y1*16));
}