#include "mbed.h"
#include "affichage.h"
#include "ltc2309.h"
#include "wifiesp8266.h"
#include "constante.h"
#include "ADS1231.h"

float FZ;
float FX;
float AngleIncMes;
float AngleIncCons;
float CH0; // PRESSION
float CH1;
float CH2;
float CH3;
float CH4;
float CH5;
float CH6;
float CH7;
AnalogIn potmesureangle(PC_2); // potentiometre dans l'aile
DigitalOut MoteurIN1(PC_8); // rotation anti horaire (-20°) fil vert PB0
DigitalOut MoteurIN2(PC_9); // rotation horaire (+20°) fil blanc PC1
signed int comptage;
DigitalIn VoieB(PA_1);
InterruptIn  VoieA(PB_0);
char BoutonChange;
DigitalOut AdsA0(_A0);
DigitalOut AdsPwd(_Pwd);
DigitalOut AdsTemp(_Temp);
ADS1231  Ads1232  ( _Sclk, _Dout );

ADS1231::ADS1231_status_t      aux;
ADS1231::Vector_count_t        myData;
ADS1231::Vector_mass_t         myCalculatedMass;
ADS1231::Vector_voltage_t      myCalculatedVoltage;

/***********************************************************************************************************************/
/* Main function */
bool NewAffichage = true;
bool Acquisition = false;
RawSerial PC(USBTX, USBRX);
WifiEsp8266 Wifi(PA_11,PA_12); // WifiEsp8266(PinName Txd, PinName Rxd);
//float MesureAngle;   // mesure du potentiometre dans l'aile
//float ConsigneAngle;  //= 0.47; // valeur entre 0,44 et 0,56  // consigne en pourcentage ou degré

Ticker EventAcq;

void FEventAcq()
{
    Acquisition = true;
}
void FrontMontantA(void)
{
    if (VoieB.read()==1) AngleIncCons = AngleIncCons + 1;
    else AngleIncCons = AngleIncCons - 1;
    BoutonChange++;
}
void FrontDescendantA(void)
{
    if(VoieB.read()==0) AngleIncCons = AngleIncCons + 1;
    else AngleIncCons = AngleIncCons - 1;
    BoutonChange++;

}
int main()
{
    luminosite(128);
    LTC2309Init();
    LTC2309Autozero();
    char WifiPhrase[maxdata];
    MoteurIN1.write(0);
    MoteurIN2.write(0);
    PC.baud(921600);
    PC.printf("Hello je suis SP2-10\r\n");
    EventAcq.attach(&FEventAcq, 0.5); //
    AngleIncCons = 0;
    comptage = 0;
    BoutonChange = false;
    VoieA.rise(&FrontMontantA);
// mesure de poids
    AdsA0.write(1);    // chanel 1 selectionne
    AdsTemp.write(0);  // entree temp selectionne
    AdsPwd.write(1);   // ADC On
    aux = Ads1232.ADS1231_PowerDown    ();
    aux = Ads1232.ADS1231_Reset        ();
    EcranMessage("Soufflerie arretee avec aile en place");
    PC.printf("ne rien placer\r\n");
    wait(5);
    aux = Ads1232.ADS1231_ReadData_WithoutMass ( &myData, 10 );
    EcranMessage("Ajoutez 2 kg pour tarage");    
    PC.printf("placer qqch\r\n");
    wait(5);
    EcranMessage("Patientez");    
    aux = Ads1232.ADS1231_ReadData_WithCalibratedMass ( &myData, 10 );
    wait(3);
        while(1) {
// acquisition des capteurs et envoi wifi.
        if (Acquisition==true) {     // Si une valeur change
            CH0 = LTC2309read(CH0c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 0
            CH1 = LTC2309read(CH1c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 1
            CH2 = LTC2309read(CH2c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 2
            CH3 = LTC2309read(CH3c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 3
            CH4 = LTC2309read(CH4c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 4
            CH5 = LTC2309read(CH5c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 5
            CH6 = LTC2309read(CH6c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 6
            CH7 = LTC2309read(CH7c);        //  Acquisition de la  valeur de champ de pression en Pascal pour la voie 7
            NewAffichage = true;
            Acquisition = false;
            Wifi.printf("$z,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f\r\n",CH0,CH1,CH2,CH3,CH4,CH5,CH6,CH7,FX,FZ,AngleIncMes);
            PC.printf("$z,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f\r\n",CH0,CH1,CH2,CH3,CH4,CH5,CH6,CH7,FX,FZ,AngleIncMes);
            AdsA0.write(1);    // chanel 1 selectionne
            AdsTemp.write(0);  // entree temp selectionne
            AdsPwd.write(1);   // ADC On

            aux                 =    Ads1232.ADS1231_ReadRawData       ( &myData, 4);
            myCalculatedMass  =    Ads1232.ADS1231_CalculateMass     ( &myData, 2.0, ADS1231::ADS1231_SCALE_kg );
            myCalculatedVoltage =    Ads1232.ADS1231_CalculateVoltage  ( &myData, 5.0 );
            FZ = myCalculatedMass.myMass;
            PC.printf("Raw Data: %ld  Mass %0.5f  kg Voltage: %0.5f  mV\r\n", (uint32_t)myData.myRawValue,  myCalculatedMass.myMass,  1000*myCalculatedVoltage.myVoltage);
        }

        if (NewAffichage==true) {       //  Si NewAffichage est égale à True, on raffraichit l'écran
            NewAffichage = false;
            EcranPrincipale();
        }
// gestion moteur dangle
        float AngleIncMesnew = 166.0-(potmesureangle.read()*333.0);  // mesure d'angle en degré
        if (AngleIncMesnew != AngleIncMes) {
            AngleIncMes = AngleIncMesnew;
            NewAffichage = true;
        }
        if (BoutonChange) {
            PC.printf("Valeur angle %i\r\n",AngleIncCons);
            BoutonChange = 0;
        }
        //sleep();
// bouger moteur
        if ((AngleIncCons-AngleIncMes)>1) {
            MoteurIN1.write(0);
            MoteurIN2.write(1);
        } else if ((AngleIncCons-AngleIncMes)<-1) {
            MoteurIN1.write(1);
            MoteurIN2.write(0);
        } else {
            MoteurIN1.write(0);
            MoteurIN2.write(0);
        }

//acquisition des donnees wifi
        if (Wifi.dataready()) {
            strcpy(WifiPhrase,Wifi.read());
            Wifi.printf("$l%s\r\n",WifiPhrase);
            switch (WifiPhrase[1]) {
                case 'm':
                    if (AngleIncCons<20) AngleIncCons=AngleIncCons+1;
                    Wifi.printf("$l%.0f\r\n",AngleIncCons);
                    break;
                case 'n' :
                    if (AngleIncCons>-20) AngleIncCons=AngleIncCons-1;
                    Wifi.printf("$l%.0f\r\n",AngleIncCons);
                    break;
            }
        }
    }
}