#include "mbed.h"
#include "Wifly.h"

Serial pc(USBTX, USBRX);

/* wifly object where:
*     - p13 and p14 are for the serial communication
*     - p21 is for the reset pin (optional, not needed for our test)
*     - "your_ssid" is the ssid of the network
*     - "your_password" is the password
*     - true means that the security of the network is WPA
*/
Wifly wifly(p13, p14, p21, "your_ssid", "your_password", true);

void header(void) 
    {    
    //Very important: set comm remote 0
    //Otherwise the header will not load correctly
    wifly.send("HTTP/1.1 200 OK\r\n");
    wifly.send("Content-Type: text/html\r\n\r\n");  
    }

void web_page( )
    {
    wifly.send("<HTML><BODY><H1>Hi</H1><P>This is very minimal HTML document.</P></BODY></HTML>\r\n","NO"); 
    //wifly.send("","NO"); 
    wait(0.5);  
    }
 
void close_connection( )
    {
    wifly.send("$$$","NO");
    wait(1);
    wifly.send("close\n\r","NO");
    wait(1);
    wifly.send("exit\n\r","NO");
    }


int main() {
    char recv[129];
    
    // join the network specified in the constructor
    while (!wifly.join()) {
        printf("cannot to join the network, will retry!\r\n");
        wifly.reset();
    }
    
    printf("network joined!\r\n");
    
    
    while(1)
    {
        //prints all received messages from the RN-XV module
        if(wifly.readable()) 
        {
            wifly.read(recv);
            printf("%s\r\n", recv);        
        }
        
        wait(0.2);
        
        //sends to the RN-XV module the characteres we type on the console
        if(pc.readable())
        {                
             wifly.putc(pc.getc());                
        }    
        
        if(strstr (recv,"alive\r\n\r\n")) 
        {
        header( );
        web_page( );
        close_connection( );
        }
    }
}