#include "mbed.h"
#include "MMA7660.h"
#include "rtos.h"


#define DIM 3
#define N 8
#define NLEDS 4

MMA7660 accel(p28, p27);
DigitalOut led[] = { LED1, LED2, LED3, LED4 };

DigitalIn button(p14);
DigitalIn button2(p14);
bool buttonValue = false;

MMA7660 acc(p28, p27);
Serial pc(USBTX, USBRX);
PwmOut speaker(p26);
PinName led_pin[] = { LED1, LED2, LED3, LED4 };
int led_period[] = { 5000, 10000, 15000, 20000 };
int gps_x=0,gps_y=0;
int timer_end=0;

float r[DIM], s[DIM], nv[DIM][N];


void initialize_led(void const *led){
    *(DigitalOut *)led=1;    
}
void initialize_led0(void const *led){
    *(DigitalOut *)led=0;    
}

void beamSound(void const *arg) {
    
    for (float f = 2000; f > 100; f -= 50) {
        speaker.period(1.0 / f);
        speaker = 0.5;
    }
    Thread::wait(50);
    speaker = 0.0;
}

void errorSound(void const *arg) {
    
    for (float f = 2000; f > 100; f -= 50) {
        speaker.period(1.0 / f);
        speaker = 0.7;
    }
    Thread::wait(500);
    speaker = 0.0;
}

void endSound(void const *arg) {
    for (float f = 2000; f > 100; f -= 50) {
        speaker.period(1.0 / f);
        speaker = 0.5;
        wait(0.01);
    }
    speaker = 0.0;
}

void led_off(void const *led) {
    *(DigitalOut *)led = 0;
}

void led_job(void const *arg){
    for (int i = 0; i < NLEDS; i++) {
        DigitalOut *led = new DigitalOut(led_pin[i]);
        initialize_led(led);
    }
    
    for (int i = 0; i < NLEDS; i++) {
        DigitalOut *led = new DigitalOut(led_pin[i]);
        RtosTimer *timer = 
            new RtosTimer(led_off, osTimerPeriodic, led);
        timer->start(led_period[i]);
    } 
    while(true);
    
}
void led_job_3(void const *arg){
    for (int i = 0; i < NLEDS; i++) {
        DigitalOut *led = new DigitalOut(led_pin[i]);
        initialize_led0(led);
    }
    while(true);
    
}
void sound_job(void const *arg){
    //Thread::wait(5000);
    //beamSound((void *)1);
   
    while(true);
    
}
void end_job(void const *arg){
    Thread::wait(21000);
    
    timer_end=1;
    while(true) wait(1000);
    
}


int main() {
    int loop_count=0;
    int game=0;
    int rec_s=0;
    
    bool b0 = false, b1 = false;
    bool b2 = false, b3 = false;
    
    int old_pos = 0;
    accel.setActive(true);
    accel.setSampleRate(16);
    while(true) {
        float y = accel.y();
        int pos = y < 0 ? 2 : 0;
        if (pos != old_pos) {
            led[old_pos] = 0;
            led[old_pos+1] = 0;
            led[pos] = 1;
            led[pos+1] = 1;
            old_pos = pos;
        }
        b0 = b1;
        b1 = button;
        if (!b0 && b1) {
            game=pos+1;
            break;
        }
    }
    
    if(game==1){
        Thread led_j(led_job);
        Thread sound_j(sound_job);
        //sound_job((void *)0);
        Thread end_j(end_job);
    
        //end_job((void *)0);
        pc.baud(38600);
        int k = 0;
        int x=0,y=0;
        int rex=0, rey=0;
        int point_count=0;
        float v=0;
        srand(1);
        gps_x=rand()%226+15;
        gps_y=rand()%226+15;
        
        while (timer_end==0) {
            unsigned char sum = 0;  
            acc.readData(r);
            pc.putc(0);
            for (int i = 0; i < DIM; i++) {
                s[i] -= nv[i][k];
                s[i] += r[i];
                nv[i][k] = r[i];
                v = s[i] / N;
                unsigned char d = (char)((v+1) * 64);
                
                if(i==0){
                    x=(x+(d-64)/2);
                    rex=(unsigned int)x%256;
                    pc.putc(rex);
                    //dx=(d-64)/10;
                    //dx=d;
                }
                if(i==1){
                    y=(y+(d-64)/2);
                    rey=(unsigned int)y%256;
                    pc.putc(rey);
                    //dy=y;
                }
                if(i==2){
                    pc.putc(10);
                }                        
            }
            sum=x+y+10;
            pc.putc(sum);
            
            if((gps_x)<rex&&rex<(gps_x+20)){
                if((gps_y-15)<rey&&rey<(gps_y+5)){
                    gps_x=rand()%226+15;
                    gps_y=rand()%226+15;
                    
                    point_count++;
                    beamSound((void *)1);
                }
            }
            
            pc.putc(gps_x);
            pc.putc(gps_y);
            pc.putc(point_count);
            rec_s=1;
            pc.putc(rec_s);
            
            k = (k + 1) % N;
            wait(0.05);
        }
    }
    if(game==3){
        Thread led_j(led_job_3);
        Thread sound_j(sound_job);
        //sound_job((void *)0);
        //Thread end_j(end_job);  
    
        pc.baud(38600);
        int k = 0;
        int x=0,y=0;
        int rex=0, rey=0;
        int point_count=0;
        float v=0;
        srand(7);
        gps_x=rand()%226+15;
        gps_y=rand()%226+15;
        
        while (timer_end==0) {
            unsigned char sum = 0;  
            acc.readData(r);
            pc.putc(0);
            for (int i = 0; i < DIM; i++) {
                s[i] -= nv[i][k];
                s[i] += r[i];
                nv[i][k] = r[i];
                v = s[i] / N;
                unsigned char d = (char)((v+1) * 64);
                
                if(i==0){
                    x=(x+(d-64)/2);
                    rex=(unsigned int)x%256;
                    pc.putc(rex);
                    //dx=(d-64)/10;
                    //dx=d;
                }
                if(i==1){
                    y=(y+(d-64)/2);
                    rey=(unsigned int)y%256;
                    pc.putc(rey);
                    //dy=y;
                }
                if(i==2){
                    pc.putc(10);
                }                        
            }
            sum=x+y+10;
            pc.putc(sum);
            
            if((gps_x-rex)*(gps_x-rex)+(gps_y-rey)*(gps_y-rey)<4900){
                led[3]=1;
            } 
            else led[3]=0;    
            if((gps_x-rex)*(gps_x-rex)+(gps_y-rey)*(gps_y-rey)<2500){
                led[2]=1;
            }
            else led[2]=0;
            if((gps_x-rex)*(gps_x-rex)+(gps_y-rey)*(gps_y-rey)<900){
                led[1]=1;
            }
            else led[1]=0;
            if((gps_x-rex)*(gps_x-rex)+(gps_y-rey)*(gps_y-rey)<400){
                led[0]=1;
            }
            else led[0]=0;
                   
            if(button2) buttonValue = true;
            else buttonValue = false;
            
            b3 = buttonValue;
            
            if (!b2 && b3) {
                if(loop_count!=0){
                    if((gps_x-rex)*(gps_x-rex)+(gps_y-rey)*(gps_y-rey)<400){
                        timer_end=1;
                    }
                    //else{
                        //beamSound((void *)1);
                    //}
                }
            }
            loop_count=1;
            
            pc.putc(gps_x);
            pc.putc(gps_y);
            pc.putc(point_count);
            rec_s=3;
            pc.putc(rec_s);
            
            
            k = (k + 1) % N;
            wait(0.05);
        }
    }        
    endSound((void *)1);
    endSound((void *)1);
    endSound((void *)1);
}