#include "mbed.h"
#include "MFRC522.h"
#include "DHT.h"
#include "ESP8266.h"               // Include header file 
#include "math.h"
#include <string>

#define APIKEY D9BGPWTNAGUAZPMB    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "Archit"
#define WIFI_PASS "archit12"

ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

// FRDM-K64F (Freescale) Pin for MFRC522 reset
#define MF_RESET PTB19

// Defining the serial ports for PC and Bluetooth
#define SERIAL_1
AnalogIn check(PTB3); //thermocouple Analog input

Serial pc(USBTX, USBRX);
DHT sensor(PTC2,DHT22); //DHT Sensor
DigitalOut LedGreen(LED2), LedRed(LED1);
DigitalIn inputPin(PTB13); // pir senor input

int val=1;
float tmp_f, tmp_c, hum;
Timer timeBetweenCards;
char tagname;

uint8_t user[10];
char Richard[17]="A6027B026802A102";
char tempo[17];
char snd[255],rcv[1000],snd_Data[255];
float x=0;

//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
MFRC522    RfChip   (PTC6, PTC7, PTC5, PTC3, PTB19);

void esp_initialize(void);
void esp_send(void);

int main(void)
{
    pc.baud(115200);
    esp_initialize();
    LedRed= 0;

    // Initialising RC522 Chip
    RfChip.PCD_Init();

    while (true)

    {
        if(inputPin==1)

        {
            printf("Motion Detected!\r\n");
            printf("************************************************\r\n");
            printf("You have approached Omnisite Monitioring Solutions!\r\n");
            printf("------------------------------------------------------------\r\n");
            printf("Place Your ID to get access:\r\n");
            printf("------------------------------------------------------------\r\n");
            wait(2);
            tagname = '\0';
            LedRed= 1;
            LedGreen = 1;

            // checking for new cards
            if ( ! RfChip.PICC_IsNewCardPresent()) {
                wait_ms(100);
                continue;
            }

            // Selecting one of the cards or key chains
            if ( ! RfChip.PICC_ReadCardSerial()) {
                wait_ms(1000);
                continue;
            }

            // When a card is detected, a Green Led flashes!
            timeBetweenCards.start();
            LedGreen = 0;

            for (uint8_t i = 0; i < RfChip.uid.size; i++) {
                user[i]=RfChip.uid.uidByte[i];
            }

            sprintf(tempo,"%X02%X02%X02%X02",user[0],user[1],user[2],user[3]);
            printf("\n\r");
            if (strcmp(tempo, Richard)==0) {
                //Thermocouple program
                pc.printf("Thermocouple Output:\r\n");
                x=0;
                x= check.read_u16();
                x=x/65536; // ADC Scaling
                x=x*330;   // GPIO Scaling and IC Scaling(*100)
                pc.printf("Voltage Difference = %.2f C\n\r",x);
                wait(3);


                //DHT
                int err;
                printf("\r\nDHT Test program");
                printf("\r\n******************\r\n");
                err = sensor.readData();
                if (err == 0) {
                    printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
                    printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
                    printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
                    printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
                    printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
                    printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
                    printf("--------------------------------------------\r\n");
                }
                wait(2);

                tmp_f = sensor.ReadTemperature(FARENHEIT);
                tmp_c = sensor.ReadTemperature(CELCIUS);
                hum = sensor.ReadHumidity();

                esp_send();
            } else if (strcmp(tempo, Richard)!=0) {
                printf("NOT AUTHORISED\n\r");

            }

        } else if(inputPin==0) {
        }
        wait(5);
    }
}

void esp_initialize(void)
{
    pc.printf("Initializing ESP\r\n");

    pc.printf("Reset ESP\r\n");
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    wait(2);

    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    esp.RcvReply(rcv, 400);
    pc.printf(rcv);
    wait(0.1);

    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");

    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);
    pc.printf("\n %s \n", rcv);

    strcpy(snd,"AT+CIPMUX=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    esp.RcvReply(rcv, 400);
    pc.printf("\n %s \n", rcv);

}

void esp_send(void)
{
    //ESP updates the Status of Thingspeak channel//

    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");

    esp.SendCMD(snd);
    pc.printf("Send\r\n%s",snd);
    esp.RcvReply(rcv, 1000);
    pc.printf("Receive\r\n%s",rcv);
    wait(1);

    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=D9BGPWTNAGUAZPMB&field1=%f&field2=%f&field3=%f&field4=%.2f\r\n",tmp_f,tmp_c,hum,x);

    int i=0;
    for(i=0; snd[i]!='\0'; i++);
    i++;
    char cmd[255];

    sprintf(cmd,"AT+CIPSEND=%d",i);           //Send Number of open connection and Characters to send
    esp.SendCMD(cmd);
    pc.printf("Send\r\n%s",cmd);
    while(i<=20 || rcv == ">") {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);

    esp.SendCMD(snd);       //Post value to thingspeak channel
    pc.printf("Send\r\n%s",snd);

    while(i<=20 || rcv == "OK") {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);
}

