/*---------------------------------------------------------------------------------------*
*Script pour Tableau de bord Scania PGRT                                                 *
*  ________________                                                                      *
* / Olivier Flayols\_____________________________________________________________________*
* V 1.2                                                                                  *
* Version de test                                                                        *
*----------------------------------------------------------------------------------------*
*/

#include "mbed.h"
#include "FastPWM.h"

//---------- Declaration des Variables et constantes et assigation des broches -----------

DigitalOut led2                     (LED2);
DigitalOut led1                      (D12);

CAN can1                        (D15, D14);
CAN can2                         (D4, D10);

Serial COM                  (USBTX, USBRX);
Serial COM_AR                 (PA_0, PA_1);

Ticker                         CANTransmit;
Ticker                         CAN0Receive;
Ticker                         CAN1Receive;
CANMessage                           BUFRx;
Ticker                           Send_data;

FastPWM speed_pulse                   (D9);

DigitalIn   input                  (PA_15);

int                        Serial_data[54];
int                            serial_byte;
bool                             OCTET0[8]; 
bool                             OCTET1[8]; 
bool                             OCTET2[8];
bool                             OCTET3[8];
bool                             OCTET4[8];
int                                counter;
char                               DATA[8];
float                               Period;
int                            truck_speed;

//information du CAN rouge

int                      MainBeamIntended;
int                    DirectionIndicator;
int                       OpticruiseLever;
int                       Retarder = 0xFF;
int                    CUV_Information[8];
int                         Tachograph[8];
int                      CCVS_information;
int                         speed_mem = 0;
int                               DLN5[8];
int         CruiseControl_VehicleSpeed[8];
int                             HiVeDi[8];
int                               DATE[8];

enum  OCTET0 {brake_air_press_warning, park_brake, high_beam, low_beam, right_blinker, left_blinker, light_parking};
enum  OCTET1 {water_temperature_warning, oil_pressure_warning,  batterie_voltage_warning, fuel_warning, brake_air_emergency, motor_brake, wipers};
enum  OCTET2 {engine_enabled, electric_enabled, left_blinker_state, right_blinker_state, adblue_warning, light_brake,  trailer_connected};
enum  OCTET3 {wheel_lift_0, wheel_lift_1, wheel_lift_2, wheel_lift_3, wheel_lift_4, wheel_lift_5,  wheel_lift_6, wheel_lift_7};
enum  OCTET4 {trailer_wheel_lift_0, trailer_wheel_lift_1, trailer_wheel_lift_2, trailer_wheel_lift_3, trailer_wheel_lift_4, trailer_wheel_lift_5,  trailer_wheel_lift_6, trailer_wheel_lift_7};
enum  Serial_data { speed_ms, LSB_rpm, MSB_rpm, brake_air_pressure_int, fuel_int, oil_pressure_int, oil_temperature_int, water_temperature_int, batterie_voltage_int, average_cosumption_int, adblue, displayed_gear, engine_gear, effective_throttle, effective_brake, effective_clutch, LSB_Fuel_liters,  MSB_Fuel_liters, 
                    odometer_split_1, odometer_split_2, odometer_split_3, odometer_split_4, game_time_split_1, game_time_split_2, game_time_split_3, game_time_split_4, next_rest_stop_split_1, next_rest_stop_split_2, next_rest_stop_split_3, next_rest_stop_split_4, cruise_control, retarder_steps, 
                    decimal_oil_pressure, decimal_battery_voltage, decimal_average_consumption, speed_ms_decimal, decimal_fuel_liters, decimal_odometer, decimal_water_temperature, decimal_fuel, decimal_engine_rpm, decimal_brake_air_pressure, wear_engine, wear_transmission, wear_chassis, wear_wheels,
                    wear_cabin, forward_gear_count, reverse_gear_count, OCTET_0, OCTET_1, OCTET_2, OCTET_3, OCTET_4};

//                       |------------------------------------------------DMI DIAGNOSTIC--------------------------------------------|    ASP1      ASC1-K        CC/VS       CUV       DashDisp      EEC1      EngFLuid      TC01        HiRes       EBC1        ETC1                   20 par ligne  
const int  PGN[33]     = {0x18FECA0B, 0x18FECA27, 0x18FECA10, 0x18FECA03, 0x18FECA2F, 0x18FECA00, 0x18FECA30, 0x18FECA1E, 0x18FECA3D, 0x18FEAE30, 0x0CFE5A27, 0x18FEF100, 0x18FFB11E, 0x18FEFC27, 0x0CF00400, 0x18FEEF27, 0x0CFE6CEE, 0x18FEC1EE, 0x18F0010B, 0x0CF00203, 
//                           ETC2        TP2       EngTemp       IEC       FuelEco       DLN7       Weight       ERC1       Cruise       DLN2       EAC1-K       EBS5        DATE
                          0x18F00503, 0x18FFA103, 0x18FEEE00, 0x18FEF600, 0x18FEF200, 0x18FF8700, 0x18FEEA2F, 0x18F00010, 0x10FF8E11, 0x0CFF8100, 0x18F00627, 0x1CFEAC0B, 0x18FEE6EE};
              
                    
//-------------Mappage des données--------------

int map(int x, int in_min, int in_max, int out_min, int out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

float mapf(float x, float in_min, float in_max, float out_min, float out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}


void data_roll()
{
    if (counter < 9)
        {
        
      // brake, APS, AWD, Engine, SMS, COO, 53, Transmission, WTA
        
        bool engine_malfunction             = Serial_data[wear_engine] / 10;
        bool transmission_malfunction       = Serial_data[wear_transmission] / 10;
        
        bool DM1_amber [9]    = {0, 0, 0, transmission_malfunction, 0, engine_malfunction  , 0, 0};
        bool DM1_red [9]      = {0, 0, 0, transmission_malfunction, 0, engine_malfunction  , 0, 0};
    
        DATA[0] = DM1_amber[counter]*4 + DM1_red[counter]*16;;
        DATA[1] = 0xFF;
        DATA[2] = 0xFF;
        DATA[3] = 0xFF;
        DATA[4] = 0xFF;
        DATA[5] = 0xFF;
        DATA[6] = 0xFF;
        DATA[7] = 0xFF;
        }

switch(counter)
  {
      
// AIR1 - Air Supply Pressure
    case(9):
    
    int FrontRearCircuitPressure    = map((Serial_data[brake_air_pressure_int]*10)  + (Serial_data[decimal_brake_air_pressure]/10), 0, 1450, 0, 150);  //1030
    int ParkBrakePressure           = (FrontRearCircuitPressure < 0) ? 0 : ((FrontRearCircuitPressure > 106) ? 106 : FrontRearCircuitPressure);                 
    
    DATA[0] = 0x02;
    DATA[1] = ParkBrakePressure;   //106 = 8.5 bar park
    DATA[2] = FrontRearCircuitPressure;
    DATA[3] = FrontRearCircuitPressure;
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = 0xFD;
    DATA[7] = 0xFF;
    break;

// ASC1 - Air Suspension Control 1
    case(10):
    
    bool truck_axle_lifted      = (Serial_data[OCTET_3] < 0) ? 0 : ((Serial_data[OCTET_3] > 1) ? 1 : Serial_data[OCTET_3]);
    bool trailer_axle_lifted    = (Serial_data[OCTET_4] < 0) ? 0 : ((Serial_data[OCTET_4] > 1) ? 1 : Serial_data[OCTET_4]);   
    
    DATA[0] = 0xFF;
    DATA[1] = 0xFF;
    DATA[2] = 0xFF;
    DATA[3] = (trailer_axle_lifted*2) * 16;
    DATA[4] = truck_axle_lifted  * 64;    
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;
    break;

// CC/VS - Cruise Control / Vehicle Speed
    case(11):
    DATA[0] = (OCTET0[park_brake]*4);
    DATA[1] = CruiseControl_VehicleSpeed[1];
    DATA[2] = CruiseControl_VehicleSpeed[2];
    DATA[3] = CruiseControl_VehicleSpeed[3];
    DATA[4] = CruiseControl_VehicleSpeed[4];
    DATA[5] = Serial_data[cruise_control];
    DATA[6] = CruiseControl_VehicleSpeed[6];
    DATA[7] = CruiseControl_VehicleSpeed[7];
    break;

// CUV - CUV Information
    case(12):
    
    DATA[0] = (OCTET0[left_blinker]*64) + (OCTET0[right_blinker]*16) + (OCTET0[low_beam]*4) + (OCTET0[high_beam] && OCTET0[low_beam]) ;
    DATA[1] = CUV_Information[1];
    DATA[2] = (OCTET0[right_blinker]*64)+(OCTET0[left_blinker]*16);
    DATA[3] = ((OCTET2[trailer_connected] & OCTET0[right_blinker]) *4) + (OCTET0[left_blinker] & OCTET2[trailer_connected]);
    DATA[4] = CUV_Information[4];
    DATA[5] = CUV_Information[5];
    DATA[6] = CUV_Information[6];
    DATA[7] = CUV_Information[7];
    break;

//DASH - Dash Display
    case(13):
    DATA[0] = 0xFF;
    DATA[1] = map((Serial_data[fuel_int]*10) + (Serial_data[decimal_fuel]/10), 0, 1000, 0, 250);
    DATA[2] = 0xFF;
    DATA[3] = 0xFF;
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;
    break;

//EEC1 - Electronic Engine Controler
    case(14):
    DATA[0] = 0x02;
    DATA[1] = 0x00;
    DATA[2] = 0x00;
    DATA[3] =  map((((Serial_data[MSB_rpm] << 8) + Serial_data[LSB_rpm])*10) + (Serial_data[decimal_engine_rpm]/10), 0, 25000, 0, 20000) & 0x00FF;
    DATA[4] = (map((((Serial_data[MSB_rpm] << 8) + Serial_data[LSB_rpm])*10) + (Serial_data[decimal_engine_rpm]/10), 0, 25000, 0, 20000) & 0xFF00)>> 8; 
    DATA[5] = 0x11;
    DATA[6] = 0x00;
    DATA[7] = 0x00;
    break;

//ENGfLVL - Engine Fluid Level Pressure 1
    case(15):
    DATA[0] = 0x09;
    DATA[1] = 0xFF;
    DATA[2] = 0xFF;
    DATA[3] = map((Serial_data[oil_pressure_int]*10) + (Serial_data[decimal_oil_pressure]/10), 0, 810, 0, 175);
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0x00;
    break;


//TCO1
    case(16):
    
     float speed_kmh = 127.0f;
    //float speed_kmh     = mapf((float(Serial_data[speed_ms]) + (float(Serial_data[speed_ms_decimal]) / 100.0f)) * 3.6f, 0.0f, 125.0f, 1.0f,265.0f);                               //127 = 60kmh
    truck_speed         = mapf (((Serial_data[speed_ms]*100) + Serial_data[speed_ms_decimal]) *3.6f, 0, 25000, 0, 65023);
    Period              =  1.0f / speed_kmh;
    speed_pulse.period  (Period);
  /*  
    if (Serial_data[speed_ms] ==  0 && Serial_data[speed_ms_decimal] == 0)
        {
        speed_pulse.write                       (1.0f);
        }else{
        speed_pulse.write                       (0.5f);
        }
  
    */
    
    DATA[0] = Tachograph[0];
    DATA[1] = Tachograph[1];
    DATA[2] = Tachograph[2];
    DATA[3] = 0x00;
    DATA[4] = Tachograph[4];
    DATA[5] = Tachograph[5];
    DATA[6] = truck_speed & 0x00FF;
    DATA[7] = (truck_speed >> 8) & 0x00FF;
    break;
    
//HiResVDist - Hi Resolution Vehicle Distance
    case(17):
    
    int odometer = (((((Serial_data[odometer_split_4]) << 24)  + ((Serial_data[odometer_split_3]) << 16) + ((Serial_data[odometer_split_2]) << 8) + (Serial_data[odometer_split_1])) *10) + Serial_data[decimal_odometer]) *20;
    
    DATA[0] = (odometer & 0x000000FF);
    DATA[1] = (odometer & 0x0000FF00) >> 8;
    DATA[2] = (odometer & 0x00FF0000) >> 16;
    DATA[3] = (odometer & 0xFF000000) >> 24;
    DATA[4] = HiVeDi[4];
    DATA[5] = HiVeDi[5];
    DATA[6] = HiVeDi[6];
    DATA[7] = HiVeDi[7];
    break;
    
//EBC1
    case(18):
    DATA[0] = 0x00;
    DATA[1] = 0x00;
    DATA[2] = 0xF3;
    DATA[3] = 0xFF;
    DATA[4] = 0xFF;
    DATA[5] = 0x01;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;   
    break;
    
//ETC1
    case(19):
    DATA[0] = 0xCC;
    DATA[1] = 0x00;
    DATA[2] = 0x00;
    DATA[3] = 0xFF;
    DATA[4] = 0xFC;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;  
    break;
    
//ETC2
    case(20):
    //                          N       C1      C2       1       2      3        4       5       6       7       8       9      10      11      12      R1      R2
    int gear_14[17]        = {0x204E, 0x4331, 0x4332, 0x2031, 0x2032, 0x2033, 0x2034, 0x2035, 0x2036, 0x2037, 0x2038, 0x2039, 0x3130, 0x3131, 0x3132, 0x5231, 0x5232};
    
    //                          N        1       2      3        4       5       6       7       8       9      10      11      12      R1      R2
    int gear_12[15]        = {0x204E, 0x2031, 0x2032, 0x2033, 0x2034, 0x2035, 0x2036, 0x2037, 0x2038, 0x2039, 0x3130, 0x3131, 0x3132, 0x5231, 0x5232};

    DATA[0] = Serial_data[displayed_gear] + 0x7D;
    DATA[1] = 0x00;
    DATA[2] = 0xFF;
    DATA[3] = Serial_data[engine_gear] + 0x7D;
    
    if(Serial_data[forward_gear_count] == 12)
        {
        DATA[4] = (gear_12[Serial_data[displayed_gear]] >> 8) & 0x00FF;
        DATA[5] = (gear_12[Serial_data[displayed_gear]]) & 0x00FF;
        DATA[6] = (gear_12[Serial_data[engine_gear]] >> 8) & 0x00FF;
        DATA[7] = (gear_12[Serial_data[engine_gear]]) & 0x00FF;
        }
    
    if(Serial_data[forward_gear_count] == 14)
        {
        DATA[4] = (gear_14[Serial_data[displayed_gear]] >> 8) & 0x00FF;
        DATA[5] = (gear_14[Serial_data[displayed_gear]]) & 0x00FF;
        DATA[6] = (gear_14[Serial_data[engine_gear]] >> 8) & 0x00FF;
        DATA[7] = (gear_14[Serial_data[engine_gear]]) & 0x00FF;
        }
    
    break;
    
//TP2
    case(21):
    //                 R     RL    RC    RH    R0    RP    RM    RE    N    NL    NC    NH    NO    NP    NM    NE    A     AL    AC    AH    AO    AP    AM    AE    M     ML    MC    MH    MO    MP    MM    ME   blank Blank
//  int GbMode[34] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21};
    
    int GbMode;
    
    if (Serial_data[displayed_gear] == 0)
        {
        GbMode = 0x08;
        }
        
     
     if (Serial_data[displayed_gear] > 0 && Serial_data[displayed_gear]  < 15)
        {
        if(OpticruiseLever == 0x12)
            {
            GbMode = 0x10;
            }
            if(OpticruiseLever == 0x1A){
            GbMode = 0x18;
            }
        }
        
     
     if ((Serial_data[displayed_gear] > 12 && Serial_data[forward_gear_count] == 12) || (Serial_data[displayed_gear] > 14 && Serial_data[forward_gear_count] == 14))
        {
        GbMode = 0x00;
        }
   /*     
    
    if (Serial_data[displayed_gear] > 14 && Serial_data[forward_gear_count] == 14)
        {
        GbMode = 0x00;
        }
        
        
        }else{
             GbMode = 0x20; 
    }
*/
    DATA[0] = 0xD0;
    DATA[1] = 0xFF;
    DATA[2] = 0x1F;
    DATA[3] = 0xFE;
    DATA[4] = GbMode;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFE;  
    break;
    
//EngTemp
    case(22):
    DATA[0] = map((Serial_data[water_temperature_int]*10)   + (Serial_data[decimal_water_temperature]/10), -400, 2100, 0, 250);
    DATA[1] = 0x00;
    DATA[2] = 0x00;
    DATA[3] = 0xFF;
    DATA[4] = 0xFC;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;  
    break;
    
//IEC
    case(23):
    DATA[0] = 0xFF;
    DATA[1] = map(Serial_data[effective_throttle], 0, 100, 0, 75);
    DATA[2] = 0x3F;
    DATA[3] = 0xFF;
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;  
    break;
    
//FuelEco
    case(24):
    
    int FuelRate = map(Serial_data[effective_throttle], 0, 100, 0, 1920);
    int InstFuelEco = map(Serial_data[effective_throttle], 0, 100, 64254, 425); 
    int derivation = map(Serial_data[effective_throttle], 0, 100, 55000, 0);
    
    if(Serial_data[effective_throttle] > 5){
    InstFuelEco = InstFuelEco - derivation;
    }
    
    if(OCTET2[engine_enabled] == 1){
        FuelRate = FuelRate + 40;
        }
    
  
    DATA[0] = FuelRate & 0x00FF;
    DATA[1] = (FuelRate >> 8) & 0x00FF;
    DATA[2] = InstFuelEco & 0x00FF;
    DATA[3] = (InstFuelEco >> 8)  & 0x00FF;
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = map(Serial_data[effective_throttle], 0, 100, 0, 250);
    DATA[7] = 0xFF;  
    break;
    
    
//DLN7
    case(25):
    
    int EmptyAdBlue;
    if(Serial_data[adblue] == 0){
        EmptyAdBlue = 0x02;
        }else{
            EmptyAdBlue = 0x00;
            }
        
        
    DATA[0] = map(Serial_data[adblue], 0, 100, 0, 250);
    DATA[1] = EmptyAdBlue;
    DATA[2] = 0xFF;
    DATA[3] = 0xFF;
    DATA[4] = map((Serial_data[fuel_int]*10) + (Serial_data[decimal_fuel]/10), 0, 1000, 0, 250);
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;  
    break;
    
 
//Wheight
    case(26):
    DATA[0] = rand() % 255;
    DATA[1] = 0xF8;
    DATA[2] = 0x11;
    DATA[3] = 0xFF;
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;  
    break;
    
//ERC1
    case(27):
    DATA[0] = 0xC0;
    DATA[1] = 0x7D - ((Serial_data[retarder_steps] < 0) ? 0 : ((Serial_data[retarder_steps] > 1) ? 1 : Serial_data[retarder_steps]));
    DATA[2] = 0x7D - ((Serial_data[retarder_steps] < 0) ? 0 : ((Serial_data[retarder_steps] > 1) ? 1 : Serial_data[retarder_steps]));
    DATA[3] = 0xF3;
    DATA[4] = 0xFF;
    DATA[5] = 0xFF;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;  
    break;
    
//Cruise
    case(28):
    
    bool CC_active;
  
    if(Serial_data[cruise_control] > 0)
        {
            CC_active = 1;
            speed_mem = Serial_data[cruise_control];
        }else{
            CC_active = 0;
        }
    
     if(OCTET2[engine_enabled] == 0)
        {
            speed_mem = 0;
        }
    
    DATA[0] = 0x00;
    DATA[1] = speed_mem;
    DATA[2] = 0xFF;
    DATA[3] = 0xFF;
    DATA[4] = CC_active *2;
    DATA[5] = CC_active;
    DATA[6] = 0xFF;
    DATA[7] = 0xFF;
    break;
    
//DLN2   
   
   case(29):
   
    bool adblue_low;
    
    if(Serial_data[adblue] < 11)
    {
        adblue_low = 1;
        }else{
            adblue_low = 0;
            }
    
    DATA[0] = 0xA1;  
    DATA[1] = 0xFF; 
    DATA[2] = ((OCTET1[oil_pressure_warning] && OCTET2[engine_enabled]) * 16); 
    DATA[3] = OCTET1[water_temperature_warning] + (adblue_low*16); 
    DATA[4] = 0xFF; 
    DATA[5] = 0xFF; 
    DATA[6] = 0x00;  // champ economie 
    DATA[7] = 0x00;  // champ economie 
    break;
    
    
//EAC1 - K   
    
    case(30):
    DATA[0] = 0; 
    DATA[1] = 0; 
    DATA[2] = 0; 
    DATA[3] = 0;
    DATA[4] = 0;
    DATA[5] = 0;
    DATA[6] = 0;
    DATA[7] = 0; 
    break;
    
    
 //EBS5
 
    case(31):
    DATA[0] = map(Serial_data[wear_wheels], 100, 0, 0, 250); 
    DATA[1] = map(Serial_data[wear_wheels], 100, 0, 0, 250); 
    DATA[2] = map(Serial_data[wear_wheels], 100, 0, 0, 250); 
    DATA[3] = map(Serial_data[wear_wheels], 100, 0, 0, 250);
    DATA[4] = map(Serial_data[wear_wheels], 100, 0, 0, 250);
    DATA[5] = map(Serial_data[wear_wheels], 100, 0, 0, 250);
    DATA[6] = map(Serial_data[wear_wheels], 100, 0, 0, 250);
    DATA[7] = map(Serial_data[wear_wheels], 100, 0, 0, 250);
    break; 
    
 
    case(32):

    
    DATA[0] = DATE[0];  
    DATA[1] = DATE[1]; 
    DATA[2] = DATE[2]; 
    DATA[3] = DATE[3]; 
    DATA[4] = DATE[4]; 
    DATA[5] = DATE[5]; 
    DATA[6] = DATE[6]; 
    DATA[7] = DATE[7]; 
    break; 
    
    }
} 
//------------ envoi des données -------------------

void send()
{
    data_roll();
    
    if(can1.write(CANMessage(PGN[counter], DATA, 8, CANData, CANExtended)));
        {
        counter++;
        
        if (counter > 32)
            {
            counter = 0;
            }
        }
} 


void CAN0receive()
{
    if(can1.read(BUFRx)) 
        {
        int RX_PGN_0 = BUFRx.id;
        
        char SPN[8];
            
        for(int i = 0; i < 8; i ++)
            {
            SPN[i] =  char(BUFRx.data[i]);  
            }
        
         
         int filter = RX_PGN_0 & 0x00FFFFFF;
            
         if(filter == 0x00FEE617) 
            {
            for(int i = 0; i < 8; i ++)
                {
                DATE[i] =  char(BUFRx.data[i]);  
                }
                
                //printf("Message recu de : %x \n", BUFRx.id);
                //printf("%x, %x, %x, %x, %x, %x, %x, %x \n", DATE[0],DATE[1],DATE[2],DATE[3],DATE[4],DATE[5],DATE[6],DATE[7]);
                //printf("----------------------------------- \n");
                }
        }
}

void CAN1receive()
{
   if(can2.read(BUFRx)) 
        {
            int RX_PGN = BUFRx.id;
            char SPN[8];
            
            for(int i = 0; i < 8; i ++)
            {
            SPN[i] =  char(BUFRx.data[i]);  
            }
            
            
           
            if(RX_PGN == 0x18FFB11E)
                {
                for(int i = 0; i < 8; i ++)
                    {
                    CUV_Information[i] =  char(BUFRx.data[i]);  
                    }
                }
        
            if(RX_PGN == 0x18FFA103) //infos du levier opticruise (boite de vitesse) RED CAN
                {
                OpticruiseLever = SPN[4];
                }
         
            if(RX_PGN == 0x0C001027) //infos du retarder RED CAN
                {
                Retarder = SPN[3];
                
                }
                
            if(RX_PGN == 0x18FEF127) //CC/VS RED CAN
                {
                for(int i = 0; i < 8; i ++)
                    {
                    CruiseControl_VehicleSpeed[i] =  char(BUFRx.data[i]);  
                    }
                CCVS_information = SPN[4] & 0x54;                             // mask: 0b01010100  bouton du cruise control
                CCVS_information = CCVS_information + ((SPN[3] & 0x04) >> 2); // bouton du cruise control
                CCVS_information = CCVS_information + ((SPN[0] & 0x04) << 5); // information du frein de park
                }
                
            if(RX_PGN == 0x0CFE6CEE) //infos du TCO
                {
                for(int i = 0; i < 8; i ++)
                    {
                    Tachograph[i] =  char(BUFRx.data[i]);  
                    }
                 } 
                
            if(RX_PGN == 0x18FFA027) //accelerateur, rapport haut/bas manuel, retarder auto, selecteur de vitesse (toutes commandes levier opticruise)
                {
                for(int i = 0; i < 8; i ++)
                    {
                    DLN5[i] =  char(BUFRx.data[i]);  
                    }
                }   
                
            if(RX_PGN == 0x18FEC1EE) // HiVehicle distance
                {
                 for(int i = 0; i < 8; i ++)
                    {
                    HiVeDi[i] =  char(BUFRx.data[i]);  
                    }
                }   
     } 
}
//-------------------------------------------------------------------------------------------------------Initialisation LOOP ---------------------------------------------------------------------------------------------------    

int main()
{
  
    
    COM.baud                              (115200);
    COM_AR.baud                           (115200);    
    can1.frequency                        (250000);
    can2.frequency                        (250000);
    CANTransmit.attach              (&send, 0.001);  
    CAN0Receive.attach        (&CAN0receive, 0.05);
    CAN1Receive.attach      (&CAN1receive, 0.0004);
    speed_pulse.write                       (0.5f);
    input.mode(PullUp);
  
    led1 =  1;
    wait(1.0);
    led1  = 0;
  
    while(1){
        
    if(COM.readable()) {

        serial_byte = COM.getc();

            if(serial_byte != 0xFF) {
                return;
            }
  
            __disable_irq();
            
           serial_byte = COM.getc();

            if(serial_byte != 0x02) {
                return;
            }
            
            for (int i = 0; i<54; i++)
            {
                Serial_data[i] = COM.getc();
                led1 = !led1;
            }
        
            COM_AR.putc(0xFE);
            COM_AR.putc(0xFD);
          
            COM_AR.putc(OpticruiseLever);
            COM_AR.putc(Serial_data[OCTET_0]);
            COM_AR.putc(Serial_data[OCTET_1]);
            COM_AR.putc(Serial_data[OCTET_2]);
            COM_AR.putc(Serial_data[OCTET_3]);
            COM_AR.putc(Serial_data[OCTET_4]);
            COM_AR.putc(Serial_data[engine_gear]);
            COM_AR.putc(Serial_data[displayed_gear]);
            COM_AR.putc(Retarder);
            COM_AR.putc(Serial_data[retarder_steps]);
            COM_AR.putc(CUV_Information[0]);
            COM_AR.putc(CUV_Information[2]);
            COM_AR.putc(CUV_Information[3]);
            COM_AR.putc(CUV_Information[7]);
            COM_AR.putc(CCVS_information);
            COM_AR.putc(Serial_data[cruise_control]);
            COM_AR.putc(DLN5[2]);
            COM_AR.putc(DLN5[5]);
                     
            
            for(int i = 0; i < 8; i ++)
                {
                OCTET0[i] = ((int (Serial_data[OCTET_0]) >> i) & 0x01);
                OCTET1[i] = ((int (Serial_data[OCTET_1]) >> i) & 0x01);
                OCTET2[i] = ((int (Serial_data[OCTET_2]) >> i) & 0x01);
                OCTET3[i] = ((int (Serial_data[OCTET_3]) >> i) & 0x01);
                OCTET4[i] = ((int (Serial_data[OCTET_4]) >> i) & 0x01);
                }
            __enable_irq();
        }
    }
}
//******************************************************************************************************************************************************************************************************************************  
//******************************************************************************************************** END PROGRAM *********************************************************************************************************
//******************************************************************************************************************************************************************************************************************************  
      
