/*
* Prikazana vrednost na displeju ne pokazuje ono sto se moze cuti. To se desava zbog razlicitih stanja na potenciometru koja se desavaju usled  pritiska na taster SW1.
*/

// Biblioteke za uvoz

#include "mbed.h"

// Definisanje makroa
 
#define PERIOD_1    5
#define SCALE       100
#define ZERO        0

// Globalne promenljive

AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
PwmOut buzzer(PA_11);
InterruptIn sw1(PC_9);

// Deklaracija funkcija

void ISR_sw1(void);
void screenMux(void);

// Glavna funkcija

int main() 
{
    // Zadatak 2
    if (pot2.read() == ZERO)
    {
        buzzer.period_ms(PERIOD_1));
    }
    else
    {
        buzzer.period_ms(PERIOD_1 / pot2.read() * SCALE);
    }
    
    // Zadatak 1
    
    buzzer.write(pot1.read()); 
    
    sw1.fall(&ISR_sw1);
    while(1);    
    
}

void ISR_sw1 ()
{
    screenMux();
}

void screenMux()
{
    
}