//instantiate rtc object
#include "mbed.h"
#include "ds3231.h"
#include "ds3231.h"

//instantiate rtc object
Serial pc(USBTX, USBRX);
Ds3231 rtc(PTE0, PTE1); 


int epoch_ref = 900000000;

DigitalOut segA(D12);
DigitalOut segB(D8);
DigitalOut segC(D5);
DigitalOut segD(D3);
DigitalOut segE(D2);
DigitalOut segF(D11);
DigitalOut segG(D6);
DigitalOut segPt(D4);

//display pins
//int segA = 5;  // >>  11
//int segB = 13; // >>  7
//int segC = 10; // >>  4
//int segD = 8;  // >>  2
//int segE = 7;  // >>  1
//int segF = 4;  // >>  10
//int segG = 11; // >>  5
//int segPt = 9; // >>  3
//------------//

//display digit
DigitalOut d1(D13);
DigitalOut d2(D10);
DigitalOut d3(D9);
DigitalOut d4(D7);

//int d1 = 6;   // >> 12
//int d2 = 3;   // >> 9
//int d3 = 2;   // >> 8
//int d4 = 12;  // >> 6
//------------//

int delayTime = 5000; //delayTime <Don't change it, if you don't know where is it!>

int i=0;





//=============================================//
void zero(){
  segA = 1;
  segB = 1;
  segC = 1;
  segD = 1;
  segE = 1;
  segF = 1;
  segG = 0;
  segPt = 0;
}
//=============================================//
void one(){
  segA = 0;
  segB = 1;
  segC = 1;
  segD = 0;
  segE = 0;
  segF = 0;
  segG = 0;
  segPt = 0;
}
//=============================================//
void two(){
  segA = 1;
  segB = 1;
  segC = 0;
  segD = 1;
  segE = 1;
  segF = 0;
  segG = 1;
  segPt = 0;
}
//=============================================//
void three(){
  segA = 1;
  segB = 1;
  segC = 1;
  segD = 1;
  segE = 0;
  segF = 0;
  segG = 1;
  segPt = 0;
}
//=============================================//
void four(){
  segA = 0;
  segB = 1;
  segC = 1;
  segD = 0;
  segE = 0;
  segF = 1;
  segG = 1;
  segPt = 0;
}
//=============================================//
void five(){
  segA = 1;
  segB = 0;
  segC = 1;
  segD = 1;
  segE = 0;
  segF = 1;
  segG = 1;
  segPt = 0;
}
//=============================================//
void six(){
  segA = 1;
  segB = 0;
  segC = 1;
  segD = 1;
  segE = 1;
  segF = 1;
  segG = 1;
  segPt = 0;
}
//=============================================//
void seven(){
  segA = 1;
  segB = 1;
  segC = 1;
  segD = 0;
  segE = 0;
  segF = 0;
  segG = 0;
  segPt = 0;
}
//=============================================//
void eight(){
  segA = 1;
  segB = 1;
  segC = 1;
  segD = 1;
  segE = 1;
  segF = 1;
  segG = 1;
  segPt = 0;
}
//=============================================//
void nine(){
  segA = 1;
  segB = 1;
  segC = 1;
  segD = 1;
  segE = 0;
  segF = 1;
  segG = 1;
  segPt = 0;
}
//=============================================//
void point(){
  segA = 0;
  segB = 0;
  segC = 0;
  segD = 0;
  segE = 0;
  segF = 0;
  segG = 0;
  segPt = 1;
}
//=============================================//
void none(){
  segA = 0;
  segB = 0;
  segC = 0;
  segD = 0;
  segE = 0;
  segF = 0;
  segG = 0;
  segPt = 0;
}


//=============================================//
//Select Wich Digit (selectD) is going to Display (writeL)
void disp(int d){

  switch (d) { // choose a Number
    case 0: zero();
            break;
    case 1: one();
            break;
    case 2: two();
            break;
    case 3: three();
            break;
    case 4: four();
            break;
    case 5: five();
            break;
    case 6: six();
            break;
    case 7: seven();
            break;
    case 8: eight();
            break;
    case 9: nine();
            break;
    case 10: point(); // print a Point
            break;
    case 11: none(); // make all them off !
            break;
  }
}



int epoch_time;
int epoch_diff;
int digit;

int main()
{
    pc.printf("Hello World!\n");
    epoch_time = rtc.get_epoch();
    printf("\nTime as seconds since January 1, 1970 = %d\n", epoch_time);
    // for selecting the second digit
    d1 = 1; 
    d2 = 1;
    d3 = 0;
    d4 = 1;
    
    while (true) {
          epoch_time = rtc.get_epoch();
          epoch_diff = epoch_time - epoch_ref;
          printf("Elapsed : %d\n", epoch_diff);
          digit = epoch_diff % 10;
          disp(digit);


    wait(1);
    }
}