#include "mbed.h"
#include "Sht31.h"
#include "DmTftIli9341.h"
#include <string>

DigitalOut myled(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);
InterruptIn mybutton(USER_BUTTON);
Sht31 sht31(I2C_SDA,I2C_SCL);
DmTftIli9341 tft(D10, D9, D11, D12, D13); 
string str = "";
char c;
float temp;
char temp_buf[6] = "";

void echouart(){
    c = pc.getc();
    if(c == '\r'){
        tft.drawString(60, 60, "                ");
        tft.drawString(60, 60, str.c_str());
        //printf("str = %s\n", str.c_str());
        str = "";    
    }else if(c == '\n'){   
    }else{
        str += c;    
    }
}

int main(){
    //int i = 1;
    pc.attach(&echouart,SerialBase::RxIrq);
    tft.init();
    tft.drawRectangle(10, 50, 300, 80, GREEN);
    tft.drawString(20, 20, "temp:");
    tft.drawString(20, 60, "str:");
    while(1) {
        wait(1);
        myled = !myled;
        //pc.printf("This program runs since %d seconds.\n", i++);
        temp = sht31.readTemperature();
        printf("temp: %.1fC\n", temp);
        sprintf(temp_buf,"%.1f", temp);
        tft.drawString(70, 20, temp_buf);
    }
}
