#include "mbed.h"
#include "FastAnalogIn.h"
#include "EthernetInterface.h"
 
AnalogIn input1(p15);
AnalogIn input2(p16);
AnalogIn input3(p17);
AnalogIn input4(p18);
DigitalOut led1(LED1);
Timer t;

const int BROADCAST_PORT = 58083;

typedef struct{
   int times[512];
   uint16_t samples1[512];
   uint16_t samples2[512];
   uint16_t samples3[512];
   uint16_t samples4[512];
} packet_t;

int main() {
    
    packet_t sample_data;  
    
    //Setting up the Ethernet
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    
    UDPSocket sock;
    sock.init();
    sock.set_broadcasting();
    
    Endpoint broadcast;
    broadcast.set_address("255.255.255.255", BROADCAST_PORT);
    
//    uint16_t sample_buffer[2560];
    t.start();
    t.reset();
    t.start();
    while(1){
        printf("Executing Read Loop");
        for(int i=0; i<512; i++) {
            sample_data.times[i] = 6;
            //t.read_us();
            sample_data.samples1[i] = 1;
            //input1.read_u16();
            sample_data.samples2[i] = 2;
            //input2.read_u16();
            sample_data.samples3[i] = 3;
            //input3.read_u16();
            sample_data.samples4[i] = 4;
            //input4.read_u16();
            //wait_ms(1);
        }
        
        printf("Size of struct: %i \n", sizeof(sample_data));
        printf("Copying to char array \n");
        //char* data = static_cast<char*>(static_cast<void*>(&sample_data));
        char *out_buffer = (char*)(&sample_data);
        
        //char out_buffer[6144];
        //memcpy(out_buffer, data, sizeof(sample_data));
        //out_buffer[6144] = '\0';
        
        printf("Sending to Ethernet \n");
        //sock.sendTo(broadcast, out_buffer, sizeof(out_buffer));
        sock.sendTo(broadcast, out_buffer, 6144);
    }
}