#include "mbed.h"
#include "nRF24L01P.h"

#define TRANSFER_SIZE 2
#define MAX_HOPS 3

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut mL(p24);
DigitalOut mR(p23);

Ticker send;
Ticker recv;


Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

void sendData();
void recvData();
void retransmit(char (&txData)[TRANSFER_SIZE]);

char status = 'n';

int main() {
    pc.printf("started mbed\r\n");
    my_nrf24l01p.powerUp();
    pc.baud(57600);
    my_nrf24l01p.setRfFrequency(2480);
    my_nrf24l01p.setAirDataRate(2000);
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    recv.attach(&recvData, 0.01);
    
    while(1){
        if(pc.readable()){
            status = pc.getc();
            send.attach(&sendData, 0.05);
            pc.printf("set status to %c \n\r", status);
        }
    }
    
    
}

void sendData(){
    char txData[TRANSFER_SIZE]; //transferring 17bits
    txData[0] = status;
    txData[1] = MAX_HOPS;
    pc.printf("sent packet %c, %d \n\r", txData[0], txData[1]);
    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE);
    led1 = !led1;
}

void recvData(){
    if ( my_nrf24l01p.readable() ) {

        led2 = !led2;

        char rxData[TRANSFER_SIZE];
        my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
        retransmit(rxData);  //rtr
        switch(rxData[0]){
            case 'g': 
                mL = true;
                mR = true;
                break;
            case 's':
                mR = false;
                mL = false;
                break;
            case 'l':
                mR = true;
                mL = false;
            case 'r':
                mR = false;
                mL = true;
        }
    }
}

void retransmit(char (&txData)[TRANSFER_SIZE]){
    char trs[TRANSFER_SIZE];
    for(int i = 0; i < TRANSFER_SIZE; i++) {
        trs[i] = txData[i];
    }

    trs[1]--;
    if(trs[1] == 0) {
        //pc.printf("Message expired");
    } else {
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, trs, TRANSFER_SIZE);
    }
}

