
#include "mbed.h"
#include "stampdock.h"
#include <stdarg.h>     // var_args

Serial serial(USBTX, USBRX);   // tx, rx     default 9600 8N1

//stampdock *stampdock::instance;

// millisecs

void qwait(int v)
{
#ifdef qmbed
   // wait(1000*v);       // 0.001
   wait_ms(v);
#endif
#ifdef qarduino

#endif
#ifdef qlpcxpresso
   vTaskDelay(configTICK_RATE_HZ * v / 1000);
#endif
}


// pinhigh, pinlow, togglepin
// pinin, pinout, readpin
// AnalogIn()

Stampdock::Stampdock(void)
{

#ifdef qmbed
   //serial.baud(9600);          // causes error
   //serial.baud(19200);
   //serial.baud(38400);
   //serial.baud(57600);
   //serial.baud(115200);
   //serial.format(8,None,1);
#endif
#ifdef qarduino
   serial.begin( 9600 );
#endif

}

Stampdock::~Stampdock(void)
{

}


int Stampdock::init(void)
{
   // set baud ?
   return 0;
}
  
int Stampdock::print(char *str)
{
/*
   while (!serial.writeable()){
      wait(0.001);
   }
   
   serial.printf("%s", str); 
*/
   unsigned char *p;
   int c, t, len, ready;
   
   len = strlen(str);
   
   p = (unsigned char *) &str[0]; 
   //p = buffer;
   t = 0;
   ready = 0;

   if (len == 0) ready = 1;

   while (!ready){
      if (!serial.writeable()){
         wait(0.001);
      }else{
         c = *p++;         // (int) (char) ?
         //if (c < 0) c += 256;
         serial.putc( c );
         t++;
         if (t == len) ready = 1;
      }
   }
   
   return len;
}

int qprint(char *str);
int qprint(char *str)
{
/*
   while (!serial.writeable()){
      wait(0.001);
   }
   
   serial.printf("%s", str); 
*/
   unsigned char *p;
   int c, t, len, ready;
   
   len = strlen(str);
   
   p = (unsigned char *) &str[0]; 
   //p = buffer;
   t = 0;
   ready = 0;

   if (len == 0) ready = 1;

   while (!ready){
      if (!serial.writeable()){
         wait(0.001);
      }else{
         c = *p++;         // (int) (char) ?
         //if (c < 0) c += 256;
         serial.putc( c );
         t++;
         if (t == len) ready = 1;
      }
   }
   
   return len;
}

int Stampdock::printf(const char *fmt, ... )
{
   va_list var_args;
   char string[80];  // char string[256];
   unsigned char *p;
   int len = 0, t, c, ready;

   va_start(var_args, fmt);
   len = vsprintf(string, fmt, var_args);
 //len = vsprintf(buffer, fmt, var_args);
   va_end(var_args);

   while (!serial.writeable()){
      wait(0.001);
   }

   //serial.printf( string );
   //serial.printf( buffer );
   //serial.printf( "%s", string );
   //serial.printf( "%s", buffer );   
   //wait(0.01);
   
      
   p = (unsigned char *) &string[0]; 
   //p = buffer;
   t = 0;
   ready = 0;

   if (len == 0) ready = 1;
   
   while (!ready){
      if (!serial.writeable()){
         wait(0.001);
      }else{
         c = *p++;         // (int) (char) ?
         //if (c < 0) c += 256;
         serial.putc( c );
         t++;
         if (t == len) ready = 1;
      }
   }

   //if (len > 60) serial.printf("-=%d.=-", len );

   return len;
}

int qprintf(const char *fmt, ... );
int qprintf(const char *fmt, ... )
{
   va_list var_args;
   char string[80];  // char string[256];
   unsigned char *p;
   int len = 0, t, c, ready;

   va_start(var_args, fmt);
   len = vsprintf(string, fmt, var_args);
 //len = vsprintf(buffer, fmt, var_args);
   va_end(var_args);

   while (!serial.writeable()){
      wait(0.001);
   }

   //serial.printf( string );
   //serial.printf( buffer );
   //serial.printf( "%s", string );
   //serial.printf( "%s", buffer );   
   //wait(0.01);
   
      
   p = (unsigned char *) &string[0]; 
   //p = buffer;
   t = 0;
   ready = 0;

   if (len == 0) ready = 1;
   
   while (!ready){
      if (!serial.writeable()){
         wait(0.001);
      }else{
         c = *p++;         // (int) (char) ?
         //if (c < 0) c += 256;
         serial.putc( c );
         t++;
         if (t == len) ready = 1;
      }
   }

   //if (len > 60) serial.printf("-=%d.=-", len );

   return len;
}


 int Stampdock::GetEvent(void)
  {
      int e = 0, c, ready = 0, cnt = 0;
      char v;
      //  DEBUG "?Q;"     'query for events .. also sync with PC
      //  SERIN 16, Baud, [x]             '16468
      //  PAUSE 1   ' millisecs .. let serial bus settle

      //serial.printf("?Q;");     // query for event .. also sync with PC
      qprint("?Q;");     // query for event .. also sync with PC
//      qprint(" ");   // fix
//wait_ms(175);

      //qprint("?i1;");

      do{
      if (serial.readable()){
         //v = Serial.read();
/*
         v = serial.getc();
         e = v;
         if (e < 0) e += 256;      // signed char to int ?
         //e = (255-v) + 1;   // 2's complement
*/
         e = serial.getc();
         if (e != 0) qprintf(".ID:%d.", e);

         //serial.printf("EVENT:");
         //serial.printf(e);
         //serial.printf("<-");
         ready = 1;
      }else{
         //serial.printf("no event");
         wait(0.0001);
         cnt++;
         if (cnt == 1000) ready = 1;
         //Blink(0);
      }
      }while(!ready);
      //CPU.delay(10);

      // .. flush out of sync events ..
      //while (serial.readable()){
      if (serial.readable()){
         // Serial.read();
         c = serial.getc();
         if (e == 0 && c != 0) e = c;
         if (e != 0) qprintf(".ID2:%d.", e);
         //Blink(1);
      }

      if (serial.readable()){
         // Serial.read();
         c = serial.getc();
         if (e == 0 && c != 0) e = c;
         if (e != 0) qprintf(".ID3:%d.", e);
         //Blink(2);
      }
      
      qprint(" ");   // fix   
      //wait_ms(175);   
      return e;
  }

  // request the state of GUI element i

int Stampdock::GetValue(int i)
  {
      int e = 0, ready = 0, cnt = 0;
      char v;
      //StringBuffer buf=new StringBuffer(12);

      // DEBUG "?i",DEC x,";"      'get state of gui element x
      // SERIN 16, Baud, [s]             '16468
      // PAUSE 1   ' millisecs

      //serial.printf("?i");     // query for event
      //serial.printf(i);
      //serial.printf(";");

      //buf.clear();
      //buf.append("?i");
      //buf.append( i );
      //buf.append(";");
      //System.out.print(buf.toString());
 
      //serial.printf("?i%d;", i );
      qprintf("?i%d;", i );

      //wait(0.1);         //CPU.delay(1);         // ??
      do {
      if (serial.readable()){
         //v = Serial.read();
/*
         v = serial.getc();
         e = v;
         if (e < 0) e += 256;    // signed char to int ?
         //e = (255-v) + 1;   // 2's complement
*/
         e = serial.getc();

         ready = 1;
      }else{
         wait(0.0001);
         cnt++;
         if (cnt == 1000) ready = 1;
      }
      //CPU.delay(10);
      }while(!ready);

      qprint(" ");   // fix  
      
      return e;
  }

  // set the state (v) of gui element i

 void Stampdock::SetValue(int i, int v)
  {
      //StringBuffer buf=new StringBuffer(16);

      // DEBUG "?i",DEC x,";"      'get state of gui element x
      // SERIN 16, Baud, [s]             '16468
      // PAUSE 1   ' millisecs

      //serial.printf("!i");     // set value
      //serial.printf(i);
      //serial.printf(",")
      //serial.printf(v);
      //serial.printf(";");

      //buf.clear();      // slow ascii method to allow values > 255
      if (i <= 255){
         //buf.append("!ib");      // fast binary way
         //buf.append((char) 2 );  // write 2 bytes
         //buf.append((char) i );  // write id
         //buf.append((char) v );  // always smaller als 256

         //serial.printf("!ib%c%c%c;", 2 , i , v );
         qprintf("!ib%c%c%c;", 2 , i , v );
      }else{
         //buf.append("!i");   // slow ascii way
         //buf.append( i );    // in case ID greater as 255
         //buf.append(",");
         //buf.append( v );

         //serial.printf("!i%d,%d;", i, v);
         qprintf("!i%d,%d;", i, v);
      }
      //buf.append(";");
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }


char Stampdock::ReadByte(void)
  {
     char v = 0, ready = 0, cnt = 0;

     //wait(0.1);
     do {
     if (serial.readable()){
         //v =  Serial.read();
         v = serial.getc();

         //e = v;
         //if (e < 0) e += 256;    // signed char to int ?
         ready = 1;
     }else{
        wait(0.0001);
        cnt++;
        if (cnt == 1000) ready = 1;
     }
     }while(!ready);
     return v;
  }


void Stampdock::SetColor(int r, int g, int b)
  {
     // StringBuffer buf=new StringBuffer(12);

    //serial.printf(" ");   // flush test
    
   //while (!serial.writeable()){
   //   wait(0.001);
   //}
       
    if (r == 0 && g == 0 && b == 0){
      //serial.printf("!s;");      // black
      qprint("!s;");      // black
    }else{
      //buf.clear();
      //buf.append("!sb");     // fast binary method .. so values <= 255
      //buf.append((char) 3 ); // write 3 bytes
      //buf.append((char) r );
      //buf.append((char) g );
      //buf.append((char) b );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      //serial.printf("!s%d,%d,%d;",     r, g, b );          // slow ascii
      //serial.printf("!sb%c%c%c%c;", 3, r, g, b );   // fast binary
      qprintf("!sb%c%c%c%c;", 3, r, g, b );   // fast binary
    }
      //CPU.delay(1);         // ??
  }


void Stampdock::SetGrey(int g)
  {
     // StringBuffer buf=new StringBuffer(12);

    // DEBUG "!fb", 1, dat, ";"

    if (g == 0){
      //System.out.print("!f;");      // black
      //serial.printf("!f;");      // black
      qprint("!f;");      // black
    }else{
      //buf.clear();
      //buf.append("!fb");     // fast binary method .. so values <= 255
      //buf.append((char) 1 ); // write 3 bytes
      //buf.append((char) g );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      //serial.printf("!fb%c%c;", 1, g );
      qprintf("!fb%c%c;", 1, g );
    }
      //CPU.delay(1);         // ??
  }



void Stampdock::SetLED(int i, int r, int g, int b)
  {
     // StringBuffer buf=new StringBuffer(12);

      //buf.clear();
      //buf.append("!jb");     // fast binary method .. so values <= 255
      //buf.append((char) 4 ); // write 4 bytes
      //buf.append((char) i );
      //buf.append((char) r );
      //buf.append((char) g );
      //buf.append((char) b );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      //serial.printf("!jb%c%c%c%c%c;", 4, i, r, g, b );
      qprintf("!jb%c%c%c%c%c;", 4, i, r, g, b );
      
      //CPU.delay(1);         // ??
  }

void Stampdock::DrawLine(int x1, int y1, int x2, int y2)
  {
      //StringBuffer buf=new StringBuffer(36);

      //if (x1 < 0) x1 = 0;
      //if (y1 < 0) y1 = 0;
      //if (x2 < 0) x2 = 0;
      //if (y2 < 0) y2 = 0;

      //buf.clear();
      if (x1 >= 0 && x1 <= 255 && y1 >= 0 && y1 <= 255 && x2 >= 0 && x2 <= 255 && y2 

>= 0 && x2 <= 255){
        //buf.append("!lb");        // fast binary method
        //buf.append((char) 4  );   // write 4 bytes
        //buf.append((char) x1 );
        //buf.append((char) y1 );
        //buf.append((char) x2 );
        //buf.append((char) y2 );

        //serial.printf("!lb%c%c%c%c%c;", 4, x1, y1, x2, y2 );
        qprintf("!lb%c%c%c%c%c;", 4, x1, y1, x2, y2 );
     }else{
        //buf.append("!l");     // slow method .. so values > 255
        //buf.append( x1 );
        //buf.append("," );
        //buf.append( y1 );
        //buf.append("," );
        //buf.append( x2 );
        //buf.append("," );
        //buf.append( y2 );

        //serial.printf("!l%d,%d,%d,%d;", x1, y1, x2, y2);
        qprintf("!l%d,%d,%d,%d;", x1, y1, x2, y2);
      }
      //buf.append(";" );
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }

void Stampdock::Plot(int x, int y)
  {
      //StringBuffer buf=new StringBuffer(16);

      //if (x < 0) x = 0;
      //if (y < 0) y = 0;

      //buf.clear();
      if (x >= 0 && x <= 255 && y >= 0 && y <= 255){
         //buf.append("!pb");       // fast method .. so values <= 255
         //buf.append((char) 2  );  // write 2 bytes
         //buf.append((char) x  );
         //buf.append((char) y  );

         //serial.printf("!pb%c%c%c;", 2, x, y);
         qprintf("!pb%c%c%c;", 2, x, y);
      }else{
         //buf.append("!p");        // slow method .. so values > 255
         //buf.append( x  );
         //buf.append("," );
         //buf.append( y  );

         //serial.printf("!p%d,%d;", x, y);
         qprintf("!p%d,%d;", x, y);
      }
      //buf.append(";" );
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }


void Stampdock::DrawGrid(int a, int b, int c, int d, int e, int f)
  {
      //StringBuffer buf=new StringBuffer(36);

      //buf.clear();
      //buf.append("!ab");        // fast binary method
      //buf.append((char) 6  );   // write 6 bytes
      //buf.append((char) a  );   // xspace
      //buf.append((char) b  );   // yspace
      //buf.append((char) c  );   // xlines
      //buf.append((char) d  );   // ylines
      //buf.append((char) e  );   // xoffset
      //buf.append((char) f  );   // yoffset
      //buf.append(";" );
      //System.out.print(buf.toString());

      //serial.printf("!ab%c%c%c%c%c%c%c;", 6, a, b, c, d, e, f );
      qprintf("!ab%c%c%c%c%c%c%c;", 6, a, b, c, d, e, f );
      
      //CPU.delay(1);         // ??
  }

void Stampdock::ClearScreen(void)
  {
      //serial.printf("!c;");
      qprint("!c;");
  }

  // shortcut:     Cmd("!c;");  or Cmd("?O;");

void Stampdock::Cmd(char *p)
  {
      //serial.printf(p);
      qprintf(p);
  }

  // for "!nSpeech;" or "!Llog file;"

void Stampdock::CmdStr(char cmd, char *p  )
  {
       //buf.clear();
       //buf.append("!");
       //buf.append( cmd  );
       //buf.append( p    );
       //buf.append(";" );
       //System.out.print(buf.toString());

       //serial.printf("!%c%s;", cmd, p);
       qprintf("!%c%s;", cmd, p);
   }

  // cmd with no argument so  Cmd0('s');  = "!s;"

void Stampdock::Cmd0(char cmd  )
  {
       //buf.clear();
       //buf.append("!");
       //buf.append( cmd  );
       //buf.append(";" );
       //System.out.print(buf.toString());

       //serial.printf("!%c;", cmd);
       qprintf("!%c;", cmd);
  }

  // request with no arguments
  // Req0( 'm' );  =  "?m;"

 void Stampdock::Req0(char req  )
  {
       //buf.clear();
       //buf.append("?");
       //buf.append( req  );
       //buf.append(";" );
       //System.out.print(buf.toString());

       //serial.printf("?%c;", req );
       qprintf("?%c;", req );
  }

  // cmd with 1 arg   Cmd1('a' , 1 );  =  "!a1;"

void Stampdock::Cmd1(char cmd, int arg1 )
  {
     //buf.clear();
     //buf.append("!");
     //buf.append( cmd  );
     if (arg1 < 256){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 1  );  // 1 argument
       //buf.append((char) arg1 );

       //serial.printf("!%cb%c%c;", cmd, 1, arg1 );
       qprintf("!%cb%c%c;", cmd, 1, arg1 );
     }else{
       //buf.append( arg1 );       // slow ascii mode

       //serial.printf("!%c%d;", cmd, arg1 );
       qprintf("!%c%d;", cmd, arg1 );
    }
    //buf.append(";" );
    //System.out.print(buf.toString());
  }

  // cmd with 2 args    Cmd2('G', 20, 1);  = "!G20,1;"
  // plot = Cmd2( 'p', x, y );

void Stampdock::Cmd2(char cmd, int arg1, int arg2 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 2  );  // 2 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );

       //serial.printf("!%cb%c%c%c;", cmd, 2, arg1, arg2 );
       qprintf("!%cb%c%c%c;", cmd, 2, arg1, arg2 );
     }else{
       //buf.append( arg1 );        // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
 
       //serial.printf("!%c%d,%d;", cmd, arg1, arg2 );
       qprintf("!%c%d,%d;", cmd, arg1, arg2 );
     }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // cmd with 3 args
  // setcolor = Cmd3( 's', r, g, b );

 void Stampdock::Cmd3(char cmd, int arg1, int arg2, int arg3 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255 && arg3 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 3  );  // 3 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );
       //buf.append((char) arg3 );

       //serial.printf("!%cb%c%c%c%c;", cmd, 3, arg1, arg2, arg3 );
       qprintf("!%cb%c%c%c%c;", cmd, 3, arg1, arg2, arg3 );
    }else{
       //buf.append( arg1 );     // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
       //buf.append(","   );
       //buf.append( arg3 );

       //serial.printf("!%c%d,%d,%d;", cmd, arg1, arg2, arg3 );
       qprintf("!%c%d,%d,%d;", cmd, arg1, arg2, arg3 );
     }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // cmd with 4 args
  // line = Cmd4( 'l', x1, y1, x2, y2);

void Stampdock::Cmd4(char cmd, int arg1, int arg2, int arg3, int arg4 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255 && arg3 < 255 && arg4 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 4  );  // 4 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );
       //buf.append((char) arg3 );
       //buf.append((char) arg4 );

       //serial.printf("!%cb%c%c%c%c%c;", cmd, 4, arg1, arg2, arg3, arg4 );
       qprintf("!%cb%c%c%c%c%c;", cmd, 4, arg1, arg2, arg3, arg4 );
    }else{
       //buf.append( arg1 );    // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
       //buf.append(","   );
       //buf.append( arg3 );
       //buf.append(","   );
       //buf.append( arg4 );
 
       //serial.printf("!%c%d,%d,%d,%d;", cmd, arg1, arg2, arg3, arg4 );
       qprintf("!%c%d,%d,%d,%d;", cmd, arg1, arg2, arg3, arg4 );
    }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // play video, mp3 or picture

void Stampdock::Media(char *p)
  {
       //buf.clear();
       //buf.append("!V");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
  
       //serial.printf("!V%s;", p);
       qprintf("!V%s;", p);
  }

void Stampdock::Speech(char *p)
  {
       //buf.clear();
       //buf.append("!n");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
 
       //serial.printf("!n%s;", p);
       qprintf("!n%s;", p);
  }

void Stampdock::Log(char *p)
  {
       //buf.clear();
       //buf.append("!L");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
  
       //serial.printf("!L%s;", p);
       qprintf("!L%s;", p);
 }

 void Stampdock::ScrollLeft()
 {
     //serial.printf("!G20,1;");
     qprintf("!G20,1;");
 }








