

#include "mbed.h"
#include "stampdock.h"

Stampdock stampdock;

AnalogIn xa(p15);
AnalogIn ya(p16);

// mode0 = low , mode1 = high
// returns values of 0-65535 ?

int readadc(int p1, int p2, int p3,  int chan, int mode)
{
   int ret = 0;
   
   if (mode == 0){
      if (chan == 0)  ret = xa * 4096;
      if (chan == 1)  ret = ya * 4096;
   }
   if (mode == 1){
      if (chan == 0)  ret = xa *  256;
      if (chan == 1)  ret = ya *  256;
   }

   return ret;
}

int measure( int chan, int mode)
{
   int ret = 0;
   
   if (mode == 0){
      if (chan == 0)  ret = xa * 4096;
      if (chan == 1)  ret = ya * 4096;
   }
   if (mode == 1){
      if (chan == 0)  ret = xa *  256;
      if (chan == 1)  ret = ya *  256;
   }

   return ret;
}
#define boolean int

  // ChanXMode    '0=off, 1=low, 2=high, 3=gnd ?
 //  Mode          '0=scope,  1=XY,  2=record   (3=off ?)





int main() {
   boolean UseChanA = true,  UseChanB = true;        // Bit
   boolean ready, grid = true, adc = false;    // Bit
   int     ChanAMode = 0, ChanBMode = 0, mode = 0;       // Nib
   int     PosA = 128, PosB = 128;

   int     val, valb, ecnt = 0;       // Word
   int     pval = 0, pvalb = 0;     // Bytes
   int     x, s, cnt = 0, ptr, speed = 0;     // Byte

   boolean trigMode = true, trigEdge = false, trigSrc = false;       // Bit
   int     trigLevel = 127;   // Byte     (128 results in 127 !)
   int  mem[100];  //  [] mem;

   //StringBuffer serbuf = new StringBuffer(80);

   //mem      = new int [100];

   //InitStampdock();


   //initpins();
   //initadc(2,1,0);

   //for (s = 0; s < 100; s++) System.out.print((char) 127 );
   //System.out.print((char) 127 );
   //System.out.print("scope running .. ");
   stampdock.printf("scope running .. ");

   // reset value of gui buttons if reset
   stampdock.SetValue(1, mode);     // System.out.print("!i1,0;");    // mode, 0 is xt scope

   stampdock.SetValue(102,0);       // System.out.print("!i102,1;");  // on/off switch on
   if (grid)     stampdock.SetValue(103,1); else stampdock.SetValue(103,0);   // System.out.print("!i103,1;");  // grid switch on
   if (adc)      stampdock.SetValue(104,1); else stampdock.SetValue(104,0);   // System.out.print("!i104,0;");  // ltc1298 off

   stampdock.SetValue(30, speed);     // System.out.print("!i30,0;");    // speed switch 0
   stampdock.SetValue(40, trigLevel); // System.out.print("!i40,128;");  // trigger level 128
   if (trigMode) stampdock.SetValue(41,1); else stampdock.SetValue(41,0); // System.out.print("!i41,1;");  // trigger on
   if (trigEdge) stampdock.SetValue(42,1); else stampdock.SetValue(42,0); // System.out.print("!i42,1;");  // trigger edge
   if (trigSrc)  stampdock.SetValue(43,1); else stampdock.SetValue(43,0); // System.out.print("!i43,0;");  // trigger source

   stampdock.SetValue(10, PosA);      // System.out.print("!i10,128;");  // pos chan a
   stampdock.SetValue(12, ChanAMode); // System.out.print("!i12,0;");    // chan a mode
   if (UseChanA) stampdock.SetValue(11,1); else stampdock.SetValue(11,0); // System.out.print("!i11,1;");    // channel a on

   stampdock.SetValue(20, PosB);       // System.out.print("!i20,128;");  // pos chan b
   stampdock.SetValue(22, ChanBMode);  // System.out.print("!i22,0;");    // chan b mode
   if (UseChanB) stampdock.SetValue(21,1);  else stampdock.SetValue(21,0);  // System.out.print("!i21,1;");    // channel b on

   while (true){
      if (ecnt > 0){        // (ecnt > 1) test speed up
         x = stampdock.GetEvent();
         ecnt = 0;
      }else{
         ecnt++;
         x = 0;
      }

      if (x != 0){      // do we have a gui click or event ?
        ecnt = 0;            // just had an event, so max wait
        s = stampdock.GetValue(x);     // get value of gui element x

        // now handle GUI element x with value/state s
        if (x == 1){      //mode 0=scope, 1=xy, 2=rec(,3 =off ?)
           mode = s;
           //stampdock.printf("#*");    // flush
           // clear graph
           //'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
           //DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  11c
           //System.out.print("!s100,100,200;!c;");
           stampdock.SetColor(100,100,200);
           stampdock.ClearScreen();
        } else
        if (x == 102){      // on/off switch ??
           // mode = s;
        } else
        if (x == 100){     // turnknob for recorder
           // mode = s;
        } else
        if (x == 103){     // grid on/off switch
           //grid = s;
           if (s == 0) grid = false; else grid = true;
        } else
        if (x == 104){     // ltc1298 on/off switch
           //grid = s;
           if (s == 0) adc = false; else adc = true;
        } else
        if (x == 30){      // speed 0,1,2,3
           speed = s;
        } else




         if (x == 40){     // trigger level
            trigLevel = 255 - s;
         } else
         if (x == 41){     // trigger on/off
            //trigMode = s;
            if (s == 0) trigMode = false; else trigMode = true;
         } else
         if (x == 42){    // trigger edge
            //trigEdge = s;
            if (s == 0) trigEdge = false; else trigEdge = true;
         } else
         if (x == 43){      // trigger source
            //trigSrc = s;
            if (s == 0) trigSrc = false; else trigSrc = true;
         } else

         if (x == 10){     // pos chan a
            PosA = s;
         } else
         if (x == 11){    // chan a on/off
            //UseChanA = s;
            if (s == 0) UseChanA = false; else UseChanA = true;
         } else
         if (x == 12){    //  chan a mode (0=1.5v, 1=15v, 2=gnd)
            ChanAMode = s;
         } else

         if (x == 20){     // pos chan b
            PosB = s;
         } else
         if (x == 21){    // chan b on/off
            //UseChanB = s;
            if (s == 0) UseChanB = false; else UseChanB = true;
         } else
         if (x == 22){    //  chan b mode (0=1.5v, 1=15v, 2=gnd)
            ChanBMode = s;
         }
      }  // if event


      if (mode == 0){     // xt scope mode
         // trigger
         if (trigMode){

            if (trigEdge == false){
               pval = 255;
            }else{
               pval = 0;
            }
            cnt   = 0;
            ready = false;
            do {
               cnt++;
               if (cnt == 20) ready = true;

               if (adc){   // ltc 1298 mode
                  if (trigSrc == false){   // chan a
                     val = readadc(2,1,0,  0, ChanAMode );
                  }else{              // chan b
                     val = readadc(2,1,0,  1, ChanBMode ); ;
                  }
               }else{   // opamp/transistor mode

                  if (trigSrc == false){   // chan a
                     val = measure(0, ChanAMode );
                  }else{              // chan b
                     val = measure(1, ChanBMode );
                  }

               }
               //  now val is the value we want to check trigger on

               if (trigEdge == false) {
                  if (trigLevel < val && trigLevel >= pval) ready = true;
               }else{
                  if (trigLevel > val && trigLevel <= pval) ready = true;
               }
               pval = val;

            }while (!ready);
         } // trigMode

         ptr = 0;    // mem counter
         if (adc){   // ltc 1298 mode
         for (cnt = 0; cnt <= 29; cnt++){
            if (UseChanA){
               //val = readadc(2,1,0,  0, ChanAMode );
               //if (ChanAMode == 0){
               //   val = val - (2048-128);
               //}else{
               //   val = val >> 4;
               //}
               //mem[ptr] = val;
               mem[ptr] = readadc(2,1,0,  0, ChanAMode );
            }
            ptr++;

            if (UseChanB){
               //val = readadc(2,1,0,  1, ChanBMode );
               //if (ChanBMode == 0){
               //   val = val - (2048-128);
               //}else{
               //   val = val >> 4;
               //}
               //mem[ptr] = val;
               mem[ptr] = readadc(2,1,0,  1, ChanBMode );
            }
            ptr++;

            if (speed > 0){
               if (speed == 1) wait(0.001); // CPU.delay(speed);
               if (speed == 2) wait(0.01 ); // CPU.delay(speed);
               if (speed == 3) wait(0.1  ); // CPU.delay(speed);
            }
         }     // for
         }else{  // opamp/transistor mode
         for (cnt = 0; cnt <= 29; cnt++){
            if (UseChanA){
               //val = measure(0, ChanAMode );
               //mem[ptr] = val;
               mem[ptr] = measure(0, ChanAMode );
            }
            ptr++;

            if (UseChanB){
               //val = measure(1, ChanBMode );
               //mem[ptr] = val;
               mem[ptr] = measure(1, ChanBMode );
            }
            ptr++;

            if (speed > 0){
               if (speed == 1) wait(0.001); // CPU.delay(speed);
               if (speed == 2) wait(0.01 ); // CPU.delay(speed);
               if (speed == 3) wait(0.1  ); // CPU.delay(speed);
            }
         }     // for
         }  // !adc

         //  ' clear graph
         //  'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
         // DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  11c
         //System.out.print("!s100,100,200;!c;");
         
         //stampdock.print("#*");     // flush
         //stampdock.SetColor(100,100,200);
         stampdock.SetColor(100,100,200);
         stampdock.ClearScreen();
         
         //grid = 0;
         if (grid){
            //'DEBUG "!s128,128,228;"            'set lighter color  14c
            // DEBUG "!sb",3,128,128,228,";"      'fast binary way to set color  8c
            //System.out.print("!s128,128,228;");
            stampdock.SetColor(128,128,228);

            //'DEBUG "!a20,20,29,19,55,12;"      'slow ascii way draw grid    20c
            //DEBUG "!ab",6,20,20,29,19,55,12,";"     'fast binary way to draw grid  11c
            //System.out.print("!a20,20,29,19,55,12;");
            stampdock.DrawGrid(20,20,29,19,55,12);

            if (trigMode){
               cnt = trigLevel;
               if (trigSrc == false){
                  cnt = 255 - cnt + PosA - 128;
               }else{
                  cnt = 255 - cnt + PosB - 128;
               }

               // 'DEBUG "!l", DEC 1,",", DEC cnt,",", DEC 40,",", DEC cnt, ";"   'slow
               //DEBUG "!lb", 4,1,cnt,40,cnt,";"    ' fast
                //System.out.print("!l1,");
                //System.out.print( cnt);
                //System.out.print(",40,");
                //System.out.print( cnt  );
                //System.out.print(";");
                stampdock.DrawLine(1,cnt,40,cnt);
            } // end trigMode
         }  // end grid

//UseChanA = 0;
//UseChanB = 0;

         if (UseChanA){
            //    draw channel a
            // 'set color black
            // 'DEBUG "!s0,0,0;"                     'slow ascii way to set color  8c
            // DEBUG "!sb",3, 0,0,0, ";"         'fast binary way to set color   8c
            //System.out.print("!s0,0,0;");
            stampdock.SetColor(0,0,0);
/*
            ptr = 0;
            for (cnt = 0; cnt <= 1; cnt++){       // <= 28
               x = mem[ ptr ];
               stampdock.printf("-%d", x );
               ptr = ptr + 2;
            }
*/
            ptr = 0;
            s = mem[ ptr ];
            s = 255 - s + PosA - 128;
            ptr = ptr + 2;
            s -= 60;

            //if (s < -128) s = -128;
            //if (s >  127) s =  127;
            //if (s <    0) s =    0;
            //if (s >  255) s =  255;
            
            //DEBUG "!Pb", 33,20, 0,60 , s     ' init poly line cmd in binary mode  38c
            //' 33 is number of bytes we are going to send
            //' 20=dx , 0=dy      (which means we only send y values)
            //' 0,60 = start x,y

            //System.out.print("!P20,0,60,");
            //System.out.print( s );
/*
            serbuf.clear();
            serbuf.append("!Pb");        // poly line, binary mode
            serbuf.append((char)33);     // 33 values follow
            serbuf.append((char)20);     // dx=20
            serbuf.append((char) 0);     // dy=0 .. so only y values
            serbuf.append((char)60);     // x start
            serbuf.append((char) s);     // y start
*/
            stampdock.printf("!Pb");
            stampdock.printf("%c%c%c%c%c", 33, 20, 0, 60, s);
            //stampdock.printf("%d%d%d%d%d", 33, 20, 0, 60, s);
            
            for (cnt = 0; cnt <= 28; cnt++){
               x = mem[ ptr ];
               x = 255 - x + PosA - 128;
               ptr = ptr + 2;

               //'' --- slow line ---
               //''val = cnt * 20
               //''DEBUG "!l",DEC val,",",DEC s,",", DEC val+20,",", DEC x,";"    ' chars 18
               //'' --- faster line ---
               //''val = cnt * 8
               //''DEBUG "!lb", 4 , val , s, val+8 , x , ";"                  'chars 8
               //'' --- fastest line ---
               //DEBUG x      'chars 1    (poly line cmd with constant dx)

               //System.out.print( "," );
               //System.out.print( x );

               x -= 60;
//               if (x > 127) x -= 256;  // int to char ?
               //serbuf.append((char) x  );    // y value of next line

               //if (x < -128) x = -128;
               //if (x >  127) x =  127;
               //if (x <    0) x =    0;
               //if (x >  255) x =  255;
               stampdock.printf("%c", x );    // y value of next line
               //stampdock.printf("%d.", x );
               //wait(0.01);

               //s = x;
            }
            //System.out.print(";");
            //serbuf.append(";");
            //System.out.print(serbuf.toString());
            stampdock.printf(";");
            //stampdock.printf(" ");   // flush ?
   
         } // end UseChanA

         if (UseChanB){
            //' draw channel b
            //'set color white
            //'DEBUG "!s255,255,255;"                  'slow ascii way to set color
            //DEBUG "!sb",3,255,255,255,";"     'fast binary way to set color
            //System.out.print("!s255,255,255;");
            stampdock.SetColor(255,255,255);

            ptr = 1;
            s = mem[ ptr ];
            s = 255 - s + PosB - 128;
            ptr = ptr + 2;
            s -= 60;

            //if (s < -128) s = -128;
            //if (s >  127) s =  127;
           // if (s <    0) s =    0;
            //if (s >  255) s =  255;
                        
            //DEBUG "!Pb", 33,20, 0,60 , s     ' init poly line cmd in binary mode  38c
            //' 33 is number of bytes we are going to send
            //' 20=dx , 0=dy      (which means we only send y values)
            //' 0,60 = start x,y

            //System.out.print("!P20,0,60,");
            //System.out.print( s );
/*
            serbuf.clear();
            serbuf.append("!Pb");
            serbuf.append((char)33);
            serbuf.append((char)20);
            serbuf.append((char) 0);
            serbuf.append((char)60);
            serbuf.append((char) s);
*/
            stampdock.printf("!Pb");
            stampdock.printf("%c%c%c%c%c", 33, 20, 0, 60, s );
            //stampdock.printf("%d%d%d%d%d", 33, 20, 0, 60, s );
            
            for (cnt = 0; cnt <= 28; cnt++){
               x = mem[ ptr ];
               x = 255 - x + PosB - 128;
               ptr = ptr + 2;

               //'' --- slow line ---
               //''val = cnt * 20
               //''DEBUG "!l",DEC val,",",DEC s,",", DEC val+20,",", DEC x,";"
               //'' --- faster line ---
               //''val = cnt * 8
               //''DEBUG "!lb", 4 , val , s, val+8 , x , ";"
               //'' --- fastest line ---
               //DEBUG x      'chars 1          (poly line cmd with constant dx)

               //System.out.print( "," );
               //System.out.print( x );

               x -= 60;
//               if (x > 127) x -= 256;  // int to char ?
               //serbuf.append((char) x  );
               
               //if (x < -128) x = -128;
               //if (x >  127) x =  127;
               //if (x <    0) x =    0;
               //if (x >  255) x =  255;
               stampdock.printf("%c", x );
               //stampdock.printf("%d.", x );
               //wait(0.01);
               
               //s = x;
            }
            //System.out.print(";");
            //serbuf.append(";");
            //System.out.print(serbuf.toString());
            stampdock.printf(";");
            //stampdock.printf(" ");   // flush ?
            
         } // end UseChanB

         //CPU.delay(1);
      }   // end xt scope mode

      if (mode == 2){   // recorder mode
         if (adc){   // ltc1298 mode
            val  = readadc(2,1,0,  0, ChanAMode );
            valb = readadc(2,1,0,  1, ChanBMode );
         }else{
            val  = measure(0, ChanAMode );
            valb = measure(1, ChanBMode );
         }

         val  = val  + PosA - 128;        // offset
         valb = valb + PosB - 128;

         //' set plot color
         //DEBUG "!s0,0,0;"
         //System.out.print("!s0,0,0;");
         stampdock.SetColor(0,0,0);

         //' plot xy
         //'DEBUG "!p", DEC 610,",", DEC val, ";"
         //' line xy
         //DEBUG "!l", DEC 610,",", DEC val,",", DEC 609,",", DEC pval ,";"

         //System.out.print("!l610,");
         //System.out.print( val  );
         //System.out.print(",609,");
         //System.out.print( pval );
         //System.out.print(";");
         stampdock.DrawLine(610,val,609,pval);

         pval = val;

         //' set plot color
         //'DEBUG "!s250,250,250;"           'slow ascii way to set color
         //DEBUG "!sb",3,250,250,250,";"     'fast binary way to set color
         //System.out.print("!s250,250,250;");
         stampdock.SetColor(250,250,250);

         //' plot xy
         //'DEBUG "!p", DEC 610,",", DEC valb, ";"
         //' line xy
         //DEBUG "!l", DEC 610,",", DEC valb,",", DEC 609,",", DEC pvalb ,";"

         //System.out.print("!l610,");
         //System.out.print( valb  );
         //System.out.print(",609,");
         //System.out.print( pvalb );
         //System.out.print(";");
         stampdock.DrawLine(610,valb,609,pvalb);

         pvalb = valb;

         // ' scrol 1 pixel to the left
         //DEBUG "!G20,1;"
         //System.out.print("!G20,1;"); 
         stampdock.printf("!G20,1;");
      }   // end recorder mode

      if (mode == 1){    // xy scope mode
         if (adc){    // ltc1298 mode
            val  = readadc(2,1,0,  0, ChanAMode );
            valb = readadc(2,1,0,  1, ChanBMode );
         }else{
            val  = measure(0, ChanAMode );
            valb = measure(1, ChanBMode );
         }

         //' set plot color
         //'DEBUG "!s200,200,200;"           'slow ascii way to set color
         //DEBUG "!sb",3,200,200,200,";"     //fast binary way to set color
         //System.out.print("!s,200,200,200;");
         stampdock.SetColor(200,200,200);

         //' plot xy
         //DEBUG "!p", DEC val,",", DEC valb, ";"
         //System.out.print("!p");
         //System.out.print( val );
         //System.out.print(",");
         //System.out.print( valb );
         //System.out.print(";");
         stampdock.Plot(val,valb);

         //' line xy
         //DEBUG "!l", DEC val,",", DEC valb,",", DEC pval,",",DEC pvalb,  ";"

         //System.out.print("!l");
         //System.out.print( val  );
         //System.out.print(",");
         //System.out.print( valb );
         //System.out.print(",");
         //System.out.print( pval  );
         //System.out.print(",");
         //System.out.print( pvalb );
         //System.out.print(";");
         stampdock.DrawLine(val, valb, pval, pvalb);

         pval  = val;
         pvalb = valb;

         cnt = cnt + 1;
         if (cnt == 50){
            //stampdock.printf("#*");  // flush
            //' clear graph
            //'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
            //DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  11c
            //System.out.print("!s,100,100,200;!c;");
            stampdock.SetColor(100,100,200);
            stampdock.ClearScreen();

            cnt = 0;
         }


      } // end xy mode scope

   }   // end while true
 }       // end main





