 

// mbed demo program (needs stampdock software)
// by apspijkerman ap@apsdev.com


#include "mbed.h"

//Serial pc(USBTX, USBRX); // tx, rx
Serial serial(USBTX, USBRX); // tx, rx     default 9600 8N1

AnalogIn xa(p15);
AnalogIn ya(p16);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);


void SetLed(int led, int mode)
{
   if (led == 0) myled1 = mode;
   if (led == 1) myled2 = mode;
   if (led == 2) myled3 = mode;
   if (led == 3) myled4 = mode;
}


void Blink(int led)
{
   if (led == 0) myled1 = 1;
   if (led == 1) myled2 = 1;
   if (led == 2) myled3 = 1;
   if (led == 3) myled4 = 1;
   wait(0.1);
   if (led == 0) myled1 = 0;
   if (led == 1) myled2 = 0;
   if (led == 2) myled3 = 0;
   if (led == 3) myled4 = 0;   
}



void SetLeds(void)
{
   int t;

// flash all leds
/*
   for (t = 0; t < 4; t++){
      SetLed(t, 1);
   }
   wait(1);
   for (t = 0; t < 4; t++){
      SetLed(t, 0);
   }   
*/
// kitt led test
   for (t = 0; t < 4; t++){
      SetLed(t, 1);
      wait(0.2);
      SetLed(t, 0);
   }
}



void ToggleLed(int led)
{
   if (led == 0) myled1 = !myled1;
   if (led == 1) myled2 = !myled2;
   if (led == 2) myled3 = !myled3;
   if (led == 3) myled4 = !myled4;
   wait(0.25);
}

//public class demo {

  // seems we need to write commands in one go, so have a buffer
  //static StringBuffer buf = new StringBuffer(128);

  // check if the system has events for us
  // if value greater then zero then thats the ID number of
  // the gui element or the event number


void InitStampdock(void)
{
//   serial.begin( 9600 );
//   serial.baud(19200);
//   serial.format(8,None,1);
   SetLeds();

}



  static int GetEvent()
  {
      int e = 0, ready = 0, cnt = 0;
      char v;
      //  DEBUG "?Q;"     'query for events .. also sync with PC
      //  SERIN 16, Baud, [x]             '16468
      //  PAUSE 1   ' millisecs .. let serial bus settle

      //serial.printf("\n");      // test .. purge buffer ?
      serial.printf("?Q;");     // query for event
      //wait(0.11);   //CPU.delay(1);        // ??
      do{
      if (serial.readable()){
         //v = Serial.read();
         v = serial.getc();

         e = v;
         if (e < 0) e += 256;      // signed char to int ?

         //e = (255-v) + 1;   // 2's complement

         //serial.printf("EVENT:");
         //serial.printf(e);
         //serial.printf("<-");
         ready = 1;
      }else{
         //serial.printf("no event");
         wait(0.0001);
         cnt++;
         if (cnt == 1000) ready = 1;
         Blink(0);
      }
      }while(!ready);
      //CPU.delay(10);

      // .. flush out of sync events ..
      //while (serial.readable()){
      if (serial.readable()){
         // Serial.read();
         serial.getc();
         Blink(1);
      }

      if (serial.readable()){
         // Serial.read();
         serial.getc();
         Blink(2);
      }
      
      return e;
  }

  // request the state of GUI element i

  static int GetValue(int i)
  {
      int e = 0, ready = 0, cnt = 0;
      char v;
      //StringBuffer buf=new StringBuffer(12);

      // DEBUG "?i",DEC x,";"      'get state of gui element x
      // SERIN 16, Baud, [s]             '16468
      // PAUSE 1   ' millisecs

      //serial.printf("?i");     // query for event
      //serial.printf(i);
      //serial.printf(";");

      //buf.clear();
      //buf.append("?i");
      //buf.append( i );
      //buf.append(";");
      //System.out.print(buf.toString());
 
      serial.printf("?i%d;", i );

      //wait(0.1);         //CPU.delay(1);         // ??
      do {
      if (serial.readable()){
         //v = Serial.read();
         v = serial.getc();

         e = v;
         if (e < 0) e += 256;    // signed char to int ?

         //e = (255-v) + 1;   // 2's complement
         ready = 1;
      }else{
         wait(0.0001);
         cnt++;
         if (cnt == 1000) ready = 1;
      }
      //CPU.delay(10);
      }while(!ready);
      return e;
  }

  // set the state (v) of gui element i

  static void SetValue(int i, int v)
  {
      //StringBuffer buf=new StringBuffer(16);

      // DEBUG "?i",DEC x,";"      'get state of gui element x
      // SERIN 16, Baud, [s]             '16468
      // PAUSE 1   ' millisecs

      //serial.printf("!i");     // set value
      //serial.printf(i);
      //serial.printf(",")
      //serial.printf(v);
      //serial.printf(";");

      //buf.clear();      // slow ascii method to allow values > 255
      if (i <= 255){
         //buf.append("!ib");      // fast binary way
         //buf.append((char) 2 );  // write 2 bytes
         //buf.append((char) i );  // write id
         //buf.append((char) v );  // always smaller als 256

         serial.printf("!ib%c%c%c;", 2 , i , v );
      }else{
         //buf.append("!i");   // slow ascii way
         //buf.append( i );    // in case ID greater as 255
         //buf.append(",");
         //buf.append( v );

         serial.printf("!i%d,%d;", i, v);
      }
      //buf.append(";");
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }


  static char ReadByte()
  {
     char v = 0, ready = 0, cnt = 0;

     //wait(0.1);
     do {
     if (serial.readable()){
         //v =  Serial.read();
         v = serial.getc();

         //e = v;
         //if (e < 0) e += 256;    // signed char to int ?
         ready = 1;
     }else{
        wait(0.0001);
        cnt++;
        if (cnt == 1000) ready = 1;
     }
     }while(!ready);
     return v;
  }


  static void SetColor(int r, int g, int b)
  {
     // StringBuffer buf=new StringBuffer(12);

    if (r == 0 && g == 0 && b == 0){
      serial.printf("!s;");      // black
    }else{
      //buf.clear();
      //buf.append("!sb");     // fast binary method .. so values <= 255
      //buf.append((char) 3 ); // write 3 bytes
      //buf.append((char) r );
      //buf.append((char) g );
      //buf.append((char) b );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      serial.printf("!sb%c%c%c%c;", 3, r, g, b );
    }
      //CPU.delay(1);         // ??
  }


   static void SetGrey(int g)
  {
     // StringBuffer buf=new StringBuffer(12);

    // DEBUG "!fb", 1, dat, ";"

    if (g == 0){
      //System.out.print("!f;");      // black
      serial.printf("!f;");      // black
    }else{
      //buf.clear();
      //buf.append("!fb");     // fast binary method .. so values <= 255
      //buf.append((char) 1 ); // write 3 bytes
      //buf.append((char) g );
      //buf.append(";"      );
      //System.out.print(buf.toString());


      serial.printf("!sf%c%c;", 1, g );
    }
      //CPU.delay(1);         // ??
  }



  static void SetLED(int i, int r, int g, int b)
  {
     // StringBuffer buf=new StringBuffer(12);

      //buf.clear();
      //buf.append("!jb");     // fast binary method .. so values <= 255
      //buf.append((char) 4 ); // write 4 bytes
      //buf.append((char) i );
      //buf.append((char) r );
      //buf.append((char) g );
      //buf.append((char) b );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      serial.printf("!jb%c%c%c%c%c;", 4, i, r, g, b );

      //CPU.delay(1);         // ??
  }

  static void DrawLine(int x1, int y1, int x2, int y2)
  {
      //StringBuffer buf=new StringBuffer(36);

      //if (x1 < 0) x1 = 0;
      //if (y1 < 0) y1 = 0;
      //if (x2 < 0) x2 = 0;
      //if (y2 < 0) y2 = 0;

      //buf.clear();
      if (x1 >= 0 && x1 <= 255 && y1 >= 0 && y1 <= 255 && x2 >= 0 && x2 <= 255 && y2 

>= 0 && x2 <= 255){
        //buf.append("!lb");        // fast binary method
        //buf.append((char) 4  );   // write 4 bytes
        //buf.append((char) x1 );
        //buf.append((char) y1 );
        //buf.append((char) x2 );
        //buf.append((char) y2 );

        serial.printf("!lb%c%c%c%c%c;", 4, x1, y1, x2, y2 );
      }else{
        //buf.append("!l");     // slow method .. so values > 255
        //buf.append( x1 );
        //buf.append("," );
        //buf.append( y1 );
        //buf.append("," );
        //buf.append( x2 );
        //buf.append("," );
        //buf.append( y2 );

        serial.printf("!l%d,%d,%d,%d;", x1, y1, x2, y2);
      }
      //buf.append(";" );
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }

  static void Plot(int x, int y)
  {
      //StringBuffer buf=new StringBuffer(16);

      //if (x < 0) x = 0;
      //if (y < 0) y = 0;

      //buf.clear();
      if (x >= 0 && x <= 255 && y >= 0 && y <= 255){
         //buf.append("!pb");       // fast method .. so values <= 255
         //buf.append((char) 2  );  // write 2 bytes
         //buf.append((char) x  );
         //buf.append((char) y  );

         serial.printf("!pb%c%c%c;", 2, x, y);
      }else{
         //buf.append("!p");        // slow method .. so values > 255
         //buf.append( x  );
         //buf.append("," );
         //buf.append( y  );

         serial.printf("!p%d,%d;", x, y);
      }
      //buf.append(";" );
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }


  static void DrawGrid(int a, int b, int c, int d, int e, int f)
  {
      //StringBuffer buf=new StringBuffer(36);

      //buf.clear();
      //buf.append("!ab");        // fast binary method
      //buf.append((char) 6  );   // write 6 bytes
      //buf.append((char) a  );   // xspace
      //buf.append((char) b  );   // yspace
      //buf.append((char) c  );   // xlines
      //buf.append((char) d  );   // ylines
      //buf.append((char) e  );   // xoffset
      //buf.append((char) f  );   // yoffset
      //buf.append(";" );
      //System.out.print(buf.toString());

      serial.printf("!ab%c%c%c%c%c%c%c;", 6, a, b, c, d, e, f );

      //CPU.delay(1);         // ??
  }

  static void ClearScreen()
  {
      serial.printf("!c;");
  }

  // shortcut:     Cmd("!c;");  or Cmd("?O;");

  static void Cmd(char *p)
  {
      serial.printf(p);
  }

  // for "!nSpeech;" or "!Llog file;"

  static void CmdStr(char cmd, char *p  )
  {
       //buf.clear();
       //buf.append("!");
       //buf.append( cmd  );
       //buf.append( p    );
       //buf.append(";" );
       //System.out.print(buf.toString());

       serial.printf("!%c%s;", cmd, p);
  }

  // cmd with no argument so  Cmd0('s');  = "!s;"

  static void Cmd0(char cmd  )
  {
       //buf.clear();
       //buf.append("!");
       //buf.append( cmd  );
       //buf.append(";" );
       //System.out.print(buf.toString());

       serial.printf("!%c;", cmd);
  }

  // request with no arguments
  // Req0( 'm' );  =  "?m;"

  static void Req0(char req  )
  {
       //buf.clear();
       //buf.append("?");
       //buf.append( req  );
       //buf.append(";" );
       //System.out.print(buf.toString());

       serial.printf("?%c;", req );
  }

  // cmd with 1 arg   Cmd1('a' , 1 );  =  "!a1;"

  static void Cmd1(char cmd, int arg1 )
  {
     //buf.clear();
     //buf.append("!");
     //buf.append( cmd  );
     if (arg1 < 256){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 1  );  // 1 argument
       //buf.append((char) arg1 );

       serial.printf("!%cb%c%c;", cmd, 1, arg1 );
     }else{
       //buf.append( arg1 );       // slow ascii mode

       serial.printf("!%c%d;", cmd, arg1 );
    }
    //buf.append(";" );
    //System.out.print(buf.toString());
  }

  // cmd with 2 args    Cmd2('G', 20, 1);  = "!G20,1;"
  // plot = Cmd2( 'p', x, y );

  static void Cmd2(char cmd, int arg1, int arg2 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 2  );  // 2 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );

       serial.printf("!%cb%c%c%c;", cmd, 2, arg1, arg2 );
     }else{
       //buf.append( arg1 );        // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
 
       serial.printf("!%c%d,%d;", cmd, arg1, arg2 );
     }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // cmd with 3 args
  // setcolor = Cmd3( 's', r, g, b );

  static void Cmd3(char cmd, int arg1, int arg2, int arg3 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255 && arg3 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 3  );  // 3 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );
       //buf.append((char) arg3 );

       serial.printf("!%cb%c%c%c%c;", cmd, 3, arg1, arg2, arg3 );
    }else{
       //buf.append( arg1 );     // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
       //buf.append(","   );
       //buf.append( arg3 );

       serial.printf("!%c%d,%d,%d;", cmd, arg1, arg2, arg3 );
     }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // cmd with 4 args
  // line = Cmd4( 'l', x1, y1, x2, y2);

  static void Cmd4(char cmd, int arg1, int arg2, int arg3, int arg4 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255 && arg3 < 255 && arg4 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 4  );  // 4 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );
       //buf.append((char) arg3 );
       //buf.append((char) arg4 );

       serial.printf("!%cb%c%c%c%c%c;", cmd, 4, arg1, arg2, arg3, arg4 );
    }else{
       //buf.append( arg1 );    // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
       //buf.append(","   );
       //buf.append( arg3 );
       //buf.append(","   );
       //buf.append( arg4 );
 
       serial.printf("!%c%d,%d,%d,%d;", cmd, arg1, arg2, arg3, arg4 );
    }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // play video, mp3 or picture

  static void Media(char *p)
  {
       //buf.clear();
       //buf.append("!V");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
  
       serial.printf("!V%s;", p);
  }

  static void Speech(char *p)
  {
       //buf.clear();
       //buf.append("!n");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
 
       serial.printf("!n%s;", p);
  }

  static void Log(char *p)
  {
       //buf.clear();
       //buf.append("!L");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
  
       serial.printf("!L%s;", p);
 }

 static void ScrollLeft()
 {
     serial.printf("!G20,1;");
  }

/*
  static void DrawGrid(int a, int b, int c, int d, int e, int f)
  {
      //StringBuffer buf=new StringBuffer(36);

      //buf.clear();
      //buf.append("!ab");        // fast binary method
      //buf.append((char) 6  );   // write 6 bytes
      //buf.append((char) a  );   // xspace
      //buf.append((char) b  );   // yspace
      //buf.append((char) c  );   // xlines
      //buf.append((char) d  );   // ylines
      //buf.append((char) e  );   // xoffset
      //buf.append((char) f  );   // yoffset
      //buf.append(";" );

      //System.out.print(buf.toString());

      serial.printf("!ab%c%c%c%c%c%c%c;", 6, a, b, c, d, e, f );

      //CPU.delay(1);         // ??
  }
*/

  /*
  static void initpins() {
    // OUTPUT dischargecap     'capacitor reset   p 15
    // LOW    dischargecap     'disable           p 15

    // OUTPUT chargecap        'capacitor charge  p 14
    // HIGH   chargecap        'disable           p 14

    // INPUT  chanblow      'channel b    p 12
    // INPUT  chanalow      'channel a    p 13
    // INPUT  chanbhigh     'channel b high  p 10
    // INPUT  chanahigh     'channel a high  p 11

    CPU.setInput (CPU.pins[10]);    // chan b high opamp
    CPU.setInput (CPU.pins[11]);    // chan a high opamp
    CPU.setInput (CPU.pins[12]);    // chan b low opamp
    CPU.setInput (CPU.pins[13]);    // chan a low opamp

    CPU.setOutput(CPU.pins[14]);    // charge cap pin
    CPU.setOutput(CPU.pins[15]);    // discarge cap pin

    CPU.writePin (CPU.pins[15] ,  false );
    CPU.writePin (CPU.pins[14] ,  true  );
  }


  // interface with ltc1298 chip

  // static int gEnablePin;        // speedup ?
  // static int gClockPin;
  // static int gDataPin;

  static void initadc(int dataPin, int clockPin, int enablePin){

    //gEnablePin =  CPU.pins[enablePin];   // speedup ?
    //gClockPin  =  CPU.pins[clockPin];
    //gDataPin   =  CPU.pins[dataPin];

    CPU.writePin(CPU.pins[enablePin],false);          // init the bus
    CPU.writePin(CPU.pins[clockPin ],false);
    CPU.delay(100);                         // settle down
    CPU.writePin(CPU.pins[enablePin],false);
    CPU.writePin(CPU.pins[enablePin],true );

    //CPU.writePin(CPU.pins[dataPin  ],false );     // test
    //Serial.print(CPU.pins[ 1 ]);      // just adds one ?
  }

  static int readadc(int dataPin, int clockPin, int enablePin, int channel, int 

mode){

     int command, readSize;
     int clockIn;

     if (channel == 0)  command = 0x1a;      // %11010  read ch0  (pin2)
     else               command = 0x1e;      // %11110  read ch1  (pin3)

     readSize   = 12;                        // Bytes to Read on the LTC1298
     //resolution = 4096;                    // Range of the LTC1298
     //clockIn    = 1000;

     CPU.writePin(CPU.pins[enablePin],false);
     // set port
     CPU.shiftOut(CPU.pins[dataPin],CPU.pins[clockPin],5,CPU.SHIFT_MSB,(command << 

11));
     // read the value
     clockIn = 

CPU.shiftIn(CPU.pins[dataPin],CPU.pins[clockPin],readSize,CPU.PRE_CLOCK_MSB);
     CPU.writePin(CPU.pins[enablePin],true);

     //CPU.delay(100);
     //CPU.writePin(CPU.pins[dataPin],false ); // test
     //CPU.setInput(dataPin);


     if (mode == 0){           // low
        clockIn = clockIn - (2048-128);
     }else{
        if (mode == 1){         // high
         //clockIn = clockIn / 16;   //  make 8 bits from 12
           clockIn = clockIn >> 4;   //  make 8 bits from 12
        }else{                         // gnd
           clockIn = 128;
        }
     }

     //  Serial.print("v:");
     //  Serial.print(channel);
     //  Serial.print(",");
     //  Serial.print(clockIn);
     //  Serial.println("");

     return clockIn;
  }
  */


  /*
  static int measure(int channel, int mode) {
    int e, time;

    if (channel == 0){  // chan a
       if (mode == 0){
          e = 13;       // a low
       }else{
          if (mode == 1){
             e = 11;       // a high
          }else{
             return 128;   // gnd
          }
       }
    }else{   // chan b
       if (mode == 0){
          e = 12;       // b low
       }else{
          if (mode == 1){
             e = 10;       // b high
          }else{
             return 128;   // gnd
          }
       }
    }

    // PULSOUT dischargecap, 10     '2uS units   ->  20uS

    //CPU.writePin(CPU.pins[15] ,  1 );    // discharge cap
    //CPU.delay( 1 );
    //CPU.writePin(CPU.pins[15] ,  0 );
    CPU.pulseOut(2, CPU.pins[15] );   //     2 x 8.7 = 17 uS

    // LOW    chargecap    'start charge
    // RCTIME chanahigh, 0 , val         'PULSIN
    // HIGH   chargecap   'stop charge

    CPU.writePin(CPU.pins[14] ,  false );
    time = CPU.rcTime( 1000 ,CPU.pins[ e ], true );  //  8.68 uS units    (0-200uS)
    CPU.writePin(CPU.pins[14] ,  true  );

    //CPU.readPin(  CPU.pins[e]);    // switch back to input
    time = time << 3;    // resolution 8 times lower as basic stamp

    return time;
  }
 */



/*
                     val = readadc(2,1,0,  0, ChanAMode );
                     val = readadc(2,1,0,  1, ChanBMode ); ;
*/
// mode0 = low , mode1 = high

int readadc(int p1, int p2, int p3,  int chan, int mode)
{
   int ret;
   
   if (mode == 0){
      if (chan == 0)  ret = xa * 4096;
      if (chan == 1)  ret = ya * 4096;
   }
   if (mode == 1){
      if (chan == 0)  ret = xa *  256;
      if (chan == 1)  ret = ya *  256;
   }

   return ret;
}

int measure( int chan, int mode)
{
   int ret;
   
   if (mode == 0){
      if (chan == 0)  ret = xa * 4096;
      if (chan == 1)  ret = ya * 4096;
   }
   if (mode == 1){
      if (chan == 0)  ret = xa *  256;
      if (chan == 1)  ret = ya *  256;
   }

   return ret;
}
#define boolean int

  // ChanXMode    '0=off, 1=low, 2=high, 3=gnd ?
 //  Mode          '0=scope,  1=XY,  2=record   (3=off ?)





int main() {
   boolean UseChanA = true,  UseChanB = true;        // Bit
   boolean ready, grid = true, adc = false;    // Bit
   int     ChanAMode = 0, ChanBMode = 0, mode = 0;       // Nib
   int     PosA = 128, PosB = 128;

   int     val, valb, ecnt = 0;       // Word
   int     pval = 0, pvalb = 0;     // Bytes
   int     x, s, cnt = 0, ptr, speed = 0;     // Byte

   boolean trigMode = true, trigEdge = false, trigSrc = false;       // Bit
   int     trigLevel = 127;   // Byte     (128 results in 127 !)
   int  mem[100];  //  [] mem;

   //StringBuffer serbuf = new StringBuffer(80);

   //mem      = new int [100];

   InitStampdock();


   //initpins();
   //initadc(2,1,0);

   //for (s = 0; s < 100; s++) System.out.print((char) 127 );
   //System.out.print((char) 127 );
   //System.out.print("scope running .. ");
   serial.printf("scope running .. ");

   // reset value of gui buttons if reset
   SetValue(1, mode);     // System.out.print("!i1,0;");    // mode, 0 is xt scope

   SetValue(102,0);       // System.out.print("!i102,1;");  // on/off switch on
   if (grid)     SetValue(103,1); else SetValue(103,0);   // System.out.print("!i103,1;");  // grid switch on
   if (adc)      SetValue(104,1); else SetValue(104,0);   // System.out.print("!i104,0;");  // ltc1298 off

   SetValue(30, speed);     // System.out.print("!i30,0;");    // speed switch 0
   SetValue(40, trigLevel); // System.out.print("!i40,128;");  // trigger level 128
   if (trigMode) SetValue(41,1); else SetValue(41,0); // System.out.print("!i41,1;");  // trigger on
   if (trigEdge) SetValue(42,1); else SetValue(42,0); // System.out.print("!i42,1;");  // trigger edge
   if (trigSrc)  SetValue(43,1); else SetValue(43,0); // System.out.print("!i43,0;");  // trigger source

   SetValue(10, PosA);      // System.out.print("!i10,128;");  // pos chan a
   SetValue(12, ChanAMode); // System.out.print("!i12,0;");    // chan a mode
   if (UseChanA) SetValue(11,1); else SetValue(11,0); // System.out.print("!i11,1;");    // channel a on

   SetValue(20, PosB);       // System.out.print("!i20,128;");  // pos chan b
   SetValue(22, ChanBMode);  // System.out.print("!i22,0;");    // chan b mode
   if (UseChanB) SetValue(21,1); else SetValue(21,0);  // System.out.print("!i21,1;");    // channel b on

   while (true){
      if (ecnt == 2){        // test speed up
         x = GetEvent();
         ecnt = 0;
      }else{
         ecnt++;
         x = 0;
      }

      if (x != 0){      // do we have a gui click or event ?
        ecnt = 0;            // just had an event, so max wait
        s = GetValue(x);     // get value of gui element x

        // now handle GUI element x with value/state s
        if (x == 1){      //mode 0=scope, 1=xy, 2=rec(,3 =off ?)
           mode = s;
           // clear graph
           //'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
           //DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  11c
           //System.out.print("!s100,100,200;!c;");
           SetColor(100,100,200);
           ClearScreen();
        } else
        if (x == 102){      // on/off switch ??
           // mode = s;
        } else
        if (x == 100){     // turnknob for recorder
           // mode = s;
        } else
        if (x == 103){     // grid on/off switch
           //grid = s;
           if (s == 0) grid = false; else grid = true;
        } else
        if (x == 104){     // ltc1298 on/off switch
           //grid = s;
           if (s == 0) adc = false; else adc = true;
        } else
        if (x == 30){      // speed 0,1,2,3
           speed = s;
        } else




         if (x == 40){     // trigger level
            trigLevel = 255 - s;
         } else
         if (x == 41){     // trigger on/off
            //trigMode = s;
            if (s == 0) trigMode = false; else trigMode = true;
         } else
         if (x == 42){    // trigger edge
            //trigEdge = s;
            if (s == 0) trigEdge = false; else trigEdge = true;
         } else
         if (x == 43){      // trigger source
            //trigSrc = s;
            if (s == 0) trigSrc = false; else trigSrc = true;
         } else

         if (x == 10){     // pos chan a
            PosA = s;
         } else
         if (x == 11){    // chan a on/off
            //UseChanA = s;
            if (s == 0) UseChanA = false; else UseChanA = true;
         } else
         if (x == 12){    //  chan a mode (0=1.5v, 1=15v, 2=gnd)
            ChanAMode = s;
         } else

         if (x == 20){     // pos chan b
            PosB = s;
         } else
         if (x == 21){    // chan b on/off
            //UseChanB = s;
            if (s == 0) UseChanB = false; else UseChanB = true;
         } else
         if (x == 22){    //  chan b mode (0=1.5v, 1=15v, 2=gnd)
            ChanBMode = s;
         }
      }  // if event


      if (mode == 0){     // xt scope mode
         // trigger
         if (trigMode){

            if (trigEdge == false){
               pval = 255;
            }else{
               pval = 0;
            }
            cnt   = 0;
            ready = false;
            do {
               cnt++;
               if (cnt == 20) ready = true;

               if (adc){   // ltc 1298 mode
                  if (trigSrc == false){   // chan a
                     val = readadc(2,1,0,  0, ChanAMode );
                  }else{              // chan b
                     val = readadc(2,1,0,  1, ChanBMode ); ;
                  }
               }else{   // opamp/transistor mode

                  if (trigSrc == false){   // chan a
                     val = measure(0, ChanAMode );
                  }else{              // chan b
                     val = measure(1, ChanBMode );
                  }

               }
               //  now val is the value we want to check trigger on

               if (trigEdge == false) {
                  if (trigLevel < val && trigLevel >= pval) ready = true;
               }else{
                  if (trigLevel > val && trigLevel <= pval) ready = true;
               }
               pval = val;

            }while (!ready);
         } // trigMode

         ptr = 0;    // mem counter
         if (adc){   // ltc 1298 mode
         for (cnt = 0; cnt <= 29; cnt++){
            if (UseChanA){
               //val = readadc(2,1,0,  0, ChanAMode );
               //if (ChanAMode == 0){
               //   val = val - (2048-128);
               //}else{
               //   val = val >> 4;
               //}
               //mem[ptr] = val;
               mem[ptr] = readadc(2,1,0,  0, ChanAMode );
            }
            ptr++;

            if (UseChanB){
               //val = readadc(2,1,0,  1, ChanBMode );
               //if (ChanBMode == 0){
               //   val = val - (2048-128);
               //}else{
               //   val = val >> 4;
               //}
               //mem[ptr] = val;
               mem[ptr] = readadc(2,1,0,  1, ChanBMode );
            }
            ptr++;

            if (speed > 0){
               if (speed == 1) wait(0.001); // CPU.delay(speed);
               if (speed == 2) wait(0.01 ); // CPU.delay(speed);
               if (speed == 3) wait(0.1  ); // CPU.delay(speed);
            }
         }     // for
         }else{  // opamp/transistor mode
         for (cnt = 0; cnt <= 29; cnt++){
            if (UseChanA){
               //val = measure(0, ChanAMode );
               //mem[ptr] = val;
               mem[ptr] = measure(0, ChanAMode );
            }
            ptr++;

            if (UseChanB){
               //val = measure(1, ChanBMode );
               //mem[ptr] = val;
               mem[ptr] = measure(1, ChanBMode );
            }
            ptr++;

            if (speed > 0){
               if (speed == 1) wait(0.001); // CPU.delay(speed);
               if (speed == 2) wait(0.01 ); // CPU.delay(speed);
               if (speed == 3) wait(0.1  ); // CPU.delay(speed);
            }
         }     // for
         }  // !adc

         //  ' clear graph
         //  'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
         // DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  11c
         //System.out.print("!s100,100,200;!c;");
         SetColor(100,100,200);
         ClearScreen();

         if (grid){
            //'DEBUG "!s128,128,228;"            'set lighter color  14c
            // DEBUG "!sb",3,128,128,228,";"      'fast binary way to set color  8c
            //System.out.print("!s128,128,228;");
            SetColor(128,128,228);

            //'DEBUG "!a20,20,29,19,55,12;"      'slow ascii way draw grid    20c
            //DEBUG "!ab",6,20,20,29,19,55,12,";"     'fast binary way to draw grid  11c
            //System.out.print("!a20,20,29,19,55,12;");
            DrawGrid(20,20,29,19,55,12);

            if (trigMode){
               cnt = trigLevel;
               if (trigSrc == false){
                  cnt = 255 - cnt + PosA - 128;
               }else{
                  cnt = 255 - cnt + PosB - 128;
               }

               // 'DEBUG "!l", DEC 1,",", DEC cnt,",", DEC 40,",", DEC cnt, ";"   'slow
               //DEBUG "!lb", 4,1,cnt,40,cnt,";"    ' fast
                //System.out.print("!l1,");
                //System.out.print( cnt);
                //System.out.print(",40,");
                //System.out.print( cnt  );
                //System.out.print(";");
                DrawLine(1,cnt,40,cnt);
            } // end trigMode
         }  // end grid


         if (UseChanA){
            //    draw channel a
            // 'set color black
            // 'DEBUG "!s0,0,0;"                     'slow ascii way to set color  8c
            // DEBUG "!sb",3, 0,0,0, ";"         'fast binary way to set color   8c
            //System.out.print("!s0,0,0;");
            SetColor(0,0,0);

            ptr = 0;
            s = mem[ ptr ];
            s = 255 - s + PosA - 128;
            ptr = ptr + 2;
            s -= 60;

            //DEBUG "!Pb", 33,20, 0,60 , s     ' init poly line cmd in binary mode  38c
            //' 33 is number of bytes we are going to send
            //' 20=dx , 0=dy      (which means we only send y values)
            //' 0,60 = start x,y

            //System.out.print("!P20,0,60,");
            //System.out.print( s );
/*
            serbuf.clear();
            serbuf.append("!Pb");        // poly line, binary mode
            serbuf.append((char)33);     // 33 values follow
            serbuf.append((char)20);     // dx=20
            serbuf.append((char) 0);     // dy=0 .. so only y values
            serbuf.append((char)60);     // x start
            serbuf.append((char) s);     // y start
*/
            serial.printf("!Pb");
            serial.printf("%c%c%c%c%c", 33, 20, 0, 60, s);

            for (cnt = 0; cnt <= 28; cnt++){
               x = mem[ ptr ];
               x = 255 - x + PosA - 128;
               ptr = ptr + 2;

               //'' --- slow line ---
               //''val = cnt * 20
               //''DEBUG "!l",DEC val,",",DEC s,",", DEC val+20,",", DEC x,";"    ' chars 18
               //'' --- faster line ---
               //''val = cnt * 8
               //''DEBUG "!lb", 4 , val , s, val+8 , x , ";"                  'chars 8
               //'' --- fastest line ---
               //DEBUG x      'chars 1    (poly line cmd with constant dx)

               //System.out.print( "," );
               //System.out.print( x );

               x -= 60;
               if (x > 127) x -= 256;  // int to char ?
               //serbuf.append((char) x  );    // y value of next line
               serial.printf("%c", x );    // y value of next line

               //s = x;
            }
            //System.out.print(";");
            //serbuf.append(";");
            //System.out.print(serbuf.toString());
            serial.printf(";");

         } // end UseChanA

         if (UseChanB){
            //' draw channel b
            //'set color white
            //'DEBUG "!s255,255,255;"                  'slow ascii way to set color
            //DEBUG "!sb",3,255,255,255,";"     'fast binary way to set color
            //System.out.print("!s255,255,255;");
            SetColor(255,255,255);

            ptr = 1;
            s = mem[ ptr ];
            s = 255 - s + PosB - 128;
            ptr = ptr + 2;
            s -= 60;

            //DEBUG "!Pb", 33,20, 0,60 , s     ' init poly line cmd in binary mode  38c
            //' 33 is number of bytes we are going to send
            //' 20=dx , 0=dy      (which means we only send y values)
            //' 0,60 = start x,y

            //System.out.print("!P20,0,60,");
            //System.out.print( s );
/*
            serbuf.clear();
            serbuf.append("!Pb");
            serbuf.append((char)33);
            serbuf.append((char)20);
            serbuf.append((char) 0);
            serbuf.append((char)60);
            serbuf.append((char) s);
*/
            serial.printf("!Pb");
            serial.printf("%c%c%c%c%c", 33, 20, 0, 60, s );

            for (cnt = 0; cnt <= 28; cnt++){
               x = mem[ ptr ];
               x = 255 - x + PosB - 128;
               ptr = ptr + 2;

               //'' --- slow line ---
               //''val = cnt * 20
               //''DEBUG "!l",DEC val,",",DEC s,",", DEC val+20,",", DEC x,";"
               //'' --- faster line ---
               //''val = cnt * 8
               //''DEBUG "!lb", 4 , val , s, val+8 , x , ";"
               //'' --- fastest line ---
               //DEBUG x      'chars 1          (poly line cmd with constant dx)

               //System.out.print( "," );
               //System.out.print( x );

               x -= 60;
               if (x > 127) x -= 256;  // int to char ?
               //serbuf.append((char) x  );
               serial.printf("%c", x );

               //s = x;
            }
            //System.out.print(";");
            //serbuf.append(";");
            //System.out.print(serbuf.toString());
            serial.printf(";");

         } // end UseChanB

         //CPU.delay(1);
      }   // end xt scope mode

      if (mode == 2){   // recorder mode
         if (adc){   // ltc1298 mode
            val  = readadc(2,1,0,  0, ChanAMode );
            valb = readadc(2,1,0,  1, ChanBMode );
         }else{
            val  = measure(0, ChanAMode );
            valb = measure(1, ChanBMode );
         }

         val  = val  + PosA - 128;        // offset
         valb = valb + PosB - 128;

         //' set plot color
         //DEBUG "!s0,0,0;"
         //System.out.print("!s0,0,0;");
         SetColor(0,0,0);

         //' plot xy
         //'DEBUG "!p", DEC 610,",", DEC val, ";"
         //' line xy
         //DEBUG "!l", DEC 610,",", DEC val,",", DEC 609,",", DEC pval ,";"

         //System.out.print("!l610,");
         //System.out.print( val  );
         //System.out.print(",609,");
         //System.out.print( pval );
         //System.out.print(";");
         DrawLine(610,val,609,pval);

         pval = val;

         //' set plot color
         //'DEBUG "!s250,250,250;"           'slow ascii way to set color
         //DEBUG "!sb",3,250,250,250,";"     'fast binary way to set color
         //System.out.print("!s250,250,250;");
         SetColor(250,250,250);

         //' plot xy
         //'DEBUG "!p", DEC 610,",", DEC valb, ";"
         //' line xy
         //DEBUG "!l", DEC 610,",", DEC valb,",", DEC 609,",", DEC pvalb ,";"

         //System.out.print("!l610,");
         //System.out.print( valb  );
         //System.out.print(",609,");
         //System.out.print( pvalb );
         //System.out.print(";");
         DrawLine(610,valb,609,pvalb);

         pvalb = valb;

         // ' scrol 1 pixel to the left
         //DEBUG "!G20,1;"
         //System.out.print("!G20,1;");
         serial.printf("!G20,1;");
      }   // end recorder mode

      if (mode == 1){    // xy scope mode
         if (adc){    // ltc1298 mode
            val  = readadc(2,1,0,  0, ChanAMode );
            valb = readadc(2,1,0,  1, ChanBMode );
         }else{
            val  = measure(0, ChanAMode );
            valb = measure(1, ChanBMode );
         }

         //' set plot color
         //'DEBUG "!s200,200,200;"           'slow ascii way to set color
         //DEBUG "!sb",3,200,200,200,";"     //fast binary way to set color
         //System.out.print("!s,200,200,200;");
         SetColor(200,200,200);

         //' plot xy
         //DEBUG "!p", DEC val,",", DEC valb, ";"
         //System.out.print("!p");
         //System.out.print( val );
         //System.out.print(",");
         //System.out.print( valb );
         //System.out.print(";");
         Plot(val,valb);

         //' line xy
         //DEBUG "!l", DEC val,",", DEC valb,",", DEC pval,",",DEC pvalb,  ";"

         //System.out.print("!l");
         //System.out.print( val  );
         //System.out.print(",");
         //System.out.print( valb );
         //System.out.print(",");
         //System.out.print( pval  );
         //System.out.print(",");
         //System.out.print( pvalb );
         //System.out.print(";");
         DrawLine(val, valb, pval, pvalb);

         pval  = val;
         pvalb = valb;

         cnt = cnt + 1;
         if (cnt == 50){
            //' clear graph
            //'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
            //DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  11c
            //System.out.print("!s,100,100,200;!c;");
            SetColor(100,100,200);
            ClearScreen();

            cnt = 0;
         }


      } // end xy mode scope

   }   // end while true
 }       // end main





