



#ifndef STAMPDOCK_H
#define STAMPDOCK_H

#include "mbed.h"

// #define qarduino 1
#define qmbed  1

class Stampdock {
public:
   Stampdock(void);
  ~Stampdock(void);
  
   int init(void);
  
   int print(char *p);
   int printf(char *fmt, ... );
  
   int GetEvent(void);

   // request the state of GUI element i
   int GetValue(int i);

   // set the state (v) of gui element i
   void SetValue(int i, int v);

   char ReadByte(void);

   void SetColor(int r, int g, int b);

   void SetGrey(int g);

   void SetLED(int i, int r, int g, int b);

   void DrawLine(int x1, int y1, int x2, int y2);

   void Plot(int x, int y);

   void DrawGrid(int a, int b, int c, int d, int e, int f);

   void ClearScreen(void);
   
   void Cmd(char *p);   
   
   void CmdStr(char cmd, char *p  );

   void Cmd0(char cmd  );

   void Req0(char req  );

   void Cmd1(char cmd, int arg1 );

   void Cmd2(char cmd, int arg1, int arg2 );

   void Cmd3(char cmd, int arg1, int arg2, int arg3 );

   void Cmd4(char cmd, int arg1, int arg2, int arg3, int arg4 );

   void Media(char *p);

   void Speech(char *p);

   void Log(char *p);
   
   void ScrollLeft(void);   
   

private:

    //static stampdock *instance;
    //Serial _serial;

};




#endif