
#include "mbed.h"
#include "stampdock.h"

Stampdock stampdock;



DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);



void SetLed(int led, int mode)
{
   if (led == 0) myled1 = mode;
   if (led == 1) myled2 = mode;
   if (led == 2) myled3 = mode;
   if (led == 3) myled4 = mode;
}

void Blink(int led)
{
   if (led == 0) myled1 = 1;
   if (led == 1) myled2 = 1;
   if (led == 2) myled3 = 1;
   if (led == 3) myled4 = 1;
   wait(0.1);
   if (led == 0) myled1 = 0;
   if (led == 1) myled2 = 0;
   if (led == 2) myled3 = 0;
   if (led == 3) myled4 = 0;   
}

void SetLeds(void)
{
   int t;

// flash all leds
/*
   for (t = 0; t < 4; t++){
      SetLed(t, 1);
   }
   wait(1);
   for (t = 0; t < 4; t++){
      SetLed(t, 0);
   }   
*/
// kitt led test
   for (t = 0; t < 4; t++){
      SetLed(t, 1);
      wait(0.2);
      SetLed(t, 0);
   }
}

void ToggleLed(int led)
{
   if (led == 0) myled1 = !myled1;
   if (led == 1) myled2 = !myled2;
   if (led == 2) myled3 = !myled3;
   if (led == 3) myled4 = !myled4;
   wait(0.25);
}



#define boolean int

  // ChanXMode    '0=off, 1=low, 2=high, 3=gnd ?
 //  Mode          '0=scope,  1=XY,  2=record   (3=off ?)

int main() {
   boolean ready;    // Bit
   int   x, s, cnt = 0, ptr, speed = 0;     // Byte
   int   x1, y1, x2, y2, ecnt = 0;
   int mem[10];   //  int    [] mem;

   //stampdock *Stampdock = new stampdock();

   //StringBuffer serbuf = new StringBuffer(80);

   //mem      = new int [10];

   //InitStampdock();

   //serial.printf("demo running .. \r\n");
   stampdock.printf("demo running %d .. \r\n", 123);


   for (cnt = 0; cnt < 100; cnt++){
      stampdock.SetValue(cnt, 0);
   }

   stampdock.Cmd("!j0,250,0,0;");    // LED 0 to red
   stampdock.Cmd("!j1,0,250,0;");    // LED 1 to green
   stampdock.Cmd("!j2,0,0,250;");    // LED 2 to blue
   stampdock.Cmd("!j3,4;");          // LED 3 to white

   stampdock.Cmd4( 'j', 0, 250, 0, 0 );   // LED 0 to red

   stampdock.SetColor(100,100,200);
   stampdock.ClearScreen();            // clear graph

   stampdock.SetColor(128,128,228);
   stampdock.DrawGrid(20,20,29,19,55,12);

   stampdock.SetColor(0,0,0);   // black
   for (cnt = 0; cnt < 20; cnt++){

      x1 = cnt * 10;
      y1 = 15;

      stampdock.Plot(x1, y1);
   }

   for (cnt = 0; cnt < 20; cnt++){
      x1 = 10 * cnt;
      x2 = 15 * cnt;
      y1 = 20;
      y2 = 40;
      stampdock.DrawLine(x1,y1,x2,y2);
   }

   stampdock.Cmd("!f12;");      // set greyscale value 12
   stampdock.Cmd("!r60,60,100,100;");    // draw rectangle

   stampdock.Cmd("!h10,70;");     // set draw position to home or 10,70
   stampdock.Cmd("!g50;");        // draw grey pixel and increase
   stampdock.Cmd("!g100;");       // draw grey pixel and increase
   stampdock.Cmd("!g150;");       // draw grey pixel and increase
   stampdock.Cmd("!g200;");       // draw grey pixel and increase
   stampdock.Cmd("!w10;");        // draw 10 white pixels and increase
   stampdock.Cmd("!b10;");        // draw 10 black pixels and increase


   s = 80;
   //serbuf.clear();
   //serbuf.append("!Pb");        // poly line, binary mode
   //serbuf.append((char)33);     // 33 values follow
   //serbuf.append((char)20);     // dx=20
   //serbuf.append((char) 0);     // dy=0 .. so only y values
   //serbuf.append((char)60);     // x start
   //serbuf.append((char) s);     // y start

   stampdock.printf("!Pb%c%c%c%c%c", 33, 20, 0, 60, s );

   for (cnt = 0; cnt <= 28; cnt++){
      x = cnt * cnt;
      //serbuf.append((char) x  );    // y value of next line

      stampdock.printf("%c", x );
   }

   //serbuf.append(";");     // end poly line cmd
   //System.out.print(serbuf.toString());
   stampdock.print(";");


   // do some file access

   stampdock.Cmd("!Otempfile.txt;");    // open file for writing
   stampdock.Cmd("!e12,24,48,96;");     // write some values
   stampdock.Cmd("!O;");                // close file

   stampdock.Cmd("?Otempfile.txt;");   // open file for reading
   stampdock.ReadByte();
   stampdock.ReadByte();
   stampdock.ReadByte();
   s = stampdock.ReadByte();    // read LSB size of file
   stampdock.printf("file is ");
   stampdock.printf( "%d", s );
   stampdock.printf(" bytes.\r\n");

   stampdock.printf("read values: ");
   for (cnt = 0; cnt < s; cnt++){
      stampdock.Cmd("?e;");    // read a byte
      x = stampdock.ReadByte();
      stampdock.printf( "%d", x );
      stampdock.printf(",");
   }
   stampdock.printf("\r\n");
   stampdock.Cmd("?O;");    // close file
   stampdock.ReadByte();


   stampdock.printf("ticks is: ");
   stampdock.Cmd("?t0;");    // request ticks
   for (cnt = 0; cnt < 4; cnt++){
      mem[cnt] = (int) stampdock.ReadByte();
   }
   for (cnt = 0; cnt < 4; cnt++){
      stampdock.printf( "%d", mem[cnt] );
      stampdock.printf(",");
   }
   stampdock.printf("\r\n");



   stampdock.printf("time: y2 y1 mon day hour min sec tic : ");
   stampdock.Cmd("?t1;");    // request time
   for (cnt = 0; cnt < 8; cnt++){
      mem[cnt] = stampdock.ReadByte();
   }
   for (cnt = 0; cnt < 8; cnt++){
      stampdock.printf( "%d", mem[cnt] );
      stampdock.printf(",");
   }
   stampdock.printf("\r\n");

   // for (cnt = 0; cnt < 50; cnt++)
   // Cmd2( 'G', 20, 1 );          // do "!G20,1;"


   stampdock.Cmd("!nThis is a speech test.;");

   stampdock.Cmd("!LThis is a log file test;");

   stampdock.Cmd("!Vmedia/video.mpg;");
   wait( 1.1 ); // CPU.delay(1000);
   stampdock.Cmd("!Vmedia/sound.mp3;");
   wait (1.1); // CPU.delay(1000);
   stampdock.Cmd("!Vmedia/pic.jpg;");

   while (true){
      if (ecnt == 2){        // test speed up
         x = stampdock.GetEvent();
         ecnt = 0;
      }else{
         ecnt++;
         x = 0;
      }

      if (x != 0){      // do we have a gui click or event ?
        ecnt = 0;            // just had an event, so max wait
        s = stampdock.GetValue(x);     // get value of gui element x

        // now handle GUI element x with value/state s
        if (x == 1){
           //mode = s;
           // clear graph
           //'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
           //DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  


           //serial.printf("!s100,100,200;!c;");
           stampdock.SetColor(100,100,200);
           stampdock.ClearScreen();
        } else

        if (x == 10){     // checkmark 0
           stampdock.SetValue(12, s);    // set checkmark 2
        } else
        if (x == 11){     // checkmark 1
           stampdock.SetValue(13, s);    // set checkmark 3
        } else

        if (x == 20){     // hor switch 0
           stampdock.SetValue(21, s);    // set hor switch 1
        } else
         if (x == 21){     // hor switch1
           stampdock.SetValue(20, s);    // set hor switch 0
        } else

        if (x == 40){     // hor potm 0
           stampdock.SetValue(41, s);    // hor potm 1
           stampdock.SetValue(60, s);    // set analog meter
        } else
        if (x == 41){     // hor potm 1
           stampdock.SetValue(40, s);    // hor potm 0
           stampdock.SetValue(61, s);    // set analog meter
        } else

         if (x == 100){     // turn knob 0
           stampdock.SetValue(101, s);    // turn knob 1
        } else
        if (x == 101){     // turn knob 1
           stampdock.SetValue(100, s);    // turn knob 0
        } else

        if (x == 90){     // button 1
           stampdock.ScrollLeft();    // scroll left 1 pixel
        }


       }  // if event

       wait(0.1);   // CPU.delay(100);

       // do ..


   }   // end while true
 }       // end main


