

// mbed demo program (needs stampdock software)
// by apspijkerman ap@apsdev.com


#include "mbed.h"

//Serial pc(USBTX, USBRX); // tx, rx
Serial serial(USBTX, USBRX); // tx, rx     default 9600 8N1

AnalogIn xa(p15);
AnalogIn ya(p16);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);


void SetLed(int led, int mode)
{
   if (led == 0) myled1 = mode;
   if (led == 1) myled2 = mode;
   if (led == 2) myled3 = mode;
   if (led == 3) myled4 = mode;
}

void Blink(int led)
{
   if (led == 0) myled1 = 1;
   if (led == 1) myled2 = 1;
   if (led == 2) myled3 = 1;
   if (led == 3) myled4 = 1;
   wait(0.1);
   if (led == 0) myled1 = 0;
   if (led == 1) myled2 = 0;
   if (led == 2) myled3 = 0;
   if (led == 3) myled4 = 0;   
}

void SetLeds(void)
{
   int t;

// flash all leds
/*
   for (t = 0; t < 4; t++){
      SetLed(t, 1);
   }
   wait(1);
   for (t = 0; t < 4; t++){
      SetLed(t, 0);
   }   
*/
// kitt led test
   for (t = 0; t < 4; t++){
      SetLed(t, 1);
      wait(0.2);
      SetLed(t, 0);
   }
}

void ToggleLed(int led)
{
   if (led == 0) myled1 = !myled1;
   if (led == 1) myled2 = !myled2;
   if (led == 2) myled3 = !myled3;
   if (led == 3) myled4 = !myled4;
   wait(0.25);
}

//public class demo {

  // seems we need to write commands in one go, so have a buffer
  //static StringBuffer buf = new StringBuffer(128);

  // check if the system has events for us
  // if value greater then zero then thats the ID number of
  // the gui element or the event number


void InitStampdock(void)
{
//   serial.begin( 9600 );
//   serial.baud(19200);
//   serial.format(8,None,1);
   SetLeds();

}


  static int GetEvent()
  {
      int e = 0, ready = 0, cnt = 0;
      char v;
      //  DEBUG "?Q;"     'query for events .. also sync with PC
      //  SERIN 16, Baud, [x]             '16468
      //  PAUSE 1   ' millisecs .. let serial bus settle

      //serial.printf("\n");      // test .. purge buffer ?
      serial.printf("?Q;");     // query for event
      //wait(0.11);   //CPU.delay(1);        // ??
      do{
      if (serial.readable()){
         //v = Serial.read();
         v = serial.getc();

         e = v;
         if (e < 0) e += 256;      // signed char to int ?

         //e = (255-v) + 1;   // 2's complement

         //serial.printf("EVENT:");
         //serial.printf(e);
         //serial.printf("<-");
         ready = 1;
      }else{
         //serial.printf("no event");
         wait(0.0001);
         cnt++;
         if (cnt == 1000) ready = 1;
         Blink(0);
      }
      }while(!ready);
      //CPU.delay(10);

      // .. flush out of sync events ..
      //while (serial.readable()){
      if (serial.readable()){
         // Serial.read();
         serial.getc();
         Blink(1);
      }

      if (serial.readable()){
         // Serial.read();
         serial.getc();
         Blink(2);
      }
      
      return e;
  }

  // request the state of GUI element i

  static int GetValue(int i)
  {
      int e = 0, ready = 0, cnt = 0;
      char v;
      //StringBuffer buf=new StringBuffer(12);

      // DEBUG "?i",DEC x,";"      'get state of gui element x
      // SERIN 16, Baud, [s]             '16468
      // PAUSE 1   ' millisecs

      //serial.printf("?i");     // query for event
      //serial.printf(i);
      //serial.printf(";");

      //buf.clear();
      //buf.append("?i");
      //buf.append( i );
      //buf.append(";");
      //System.out.print(buf.toString());
 
      serial.printf("?i%d;", i );

      //wait(0.1);         //CPU.delay(1);         // ??
      do {
      if (serial.readable()){
         //v = Serial.read();
         v = serial.getc();

         e = v;
         if (e < 0) e += 256;    // signed char to int ?

         //e = (255-v) + 1;   // 2's complement
         ready = 1;
      }else{
         wait(0.0001);
         cnt++;
         if (cnt == 1000) ready = 1;
      }
      //CPU.delay(10);
      }while(!ready);
      return e;
  }

  // set the state (v) of gui element i

  static void SetValue(int i, int v)
  {
      //StringBuffer buf=new StringBuffer(16);

      // DEBUG "?i",DEC x,";"      'get state of gui element x
      // SERIN 16, Baud, [s]             '16468
      // PAUSE 1   ' millisecs

      //serial.printf("!i");     // set value
      //serial.printf(i);
      //serial.printf(",")
      //serial.printf(v);
      //serial.printf(";");

      //buf.clear();      // slow ascii method to allow values > 255
      if (i <= 255){
         //buf.append("!ib");      // fast binary way
         //buf.append((char) 2 );  // write 2 bytes
         //buf.append((char) i );  // write id
         //buf.append((char) v );  // always smaller als 256

         serial.printf("!ib%c%c%c;", 2 , i , v );
      }else{
         //buf.append("!i");   // slow ascii way
         //buf.append( i );    // in case ID greater as 255
         //buf.append(",");
         //buf.append( v );

         serial.printf("!i%d,%d;", i, v);
      }
      //buf.append(";");
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }


  static char ReadByte()
  {
     char v = 0, ready = 0, cnt = 0;

     //wait(0.1);
     do {
     if (serial.readable()){
         //v =  Serial.read();
         v = serial.getc();

         //e = v;
         //if (e < 0) e += 256;    // signed char to int ?
         ready = 1;
     }else{
        wait(0.0001);
        cnt++;
        if (cnt == 1000) ready = 1;
     }
     }while(!ready);
     return v;
  }


  static void SetColor(int r, int g, int b)
  {
     // StringBuffer buf=new StringBuffer(12);

    if (r == 0 && g == 0 && b == 0){
      serial.printf("!s;");      // black
    }else{
      //buf.clear();
      //buf.append("!sb");     // fast binary method .. so values <= 255
      //buf.append((char) 3 ); // write 3 bytes
      //buf.append((char) r );
      //buf.append((char) g );
      //buf.append((char) b );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      serial.printf("!sb%c%c%c%c;", 3, r, g, b );
    }
      //CPU.delay(1);         // ??
  }


   static void SetGrey(int g)
  {
     // StringBuffer buf=new StringBuffer(12);

    // DEBUG "!fb", 1, dat, ";"

    if (g == 0){
      //System.out.print("!f;");      // black
      serial.printf("!f;");      // black
    }else{
      //buf.clear();
      //buf.append("!fb");     // fast binary method .. so values <= 255
      //buf.append((char) 1 ); // write 3 bytes
      //buf.append((char) g );
      //buf.append(";"      );
      //System.out.print(buf.toString());


      serial.printf("!sf%c%c;", 1, g );
    }
      //CPU.delay(1);         // ??
  }



  static void SetLED(int i, int r, int g, int b)
  {
     // StringBuffer buf=new StringBuffer(12);

      //buf.clear();
      //buf.append("!jb");     // fast binary method .. so values <= 255
      //buf.append((char) 4 ); // write 4 bytes
      //buf.append((char) i );
      //buf.append((char) r );
      //buf.append((char) g );
      //buf.append((char) b );
      //buf.append(";"      );
      //System.out.print(buf.toString());

      serial.printf("!jb%c%c%c%c%c;", 4, i, r, g, b );

      //CPU.delay(1);         // ??
  }

  static void DrawLine(int x1, int y1, int x2, int y2)
  {
      //StringBuffer buf=new StringBuffer(36);

      //if (x1 < 0) x1 = 0;
      //if (y1 < 0) y1 = 0;
      //if (x2 < 0) x2 = 0;
      //if (y2 < 0) y2 = 0;

      //buf.clear();
      if (x1 >= 0 && x1 <= 255 && y1 >= 0 && y1 <= 255 && x2 >= 0 && x2 <= 255 && y2 

>= 0 && x2 <= 255){
        //buf.append("!lb");        // fast binary method
        //buf.append((char) 4  );   // write 4 bytes
        //buf.append((char) x1 );
        //buf.append((char) y1 );
        //buf.append((char) x2 );
        //buf.append((char) y2 );

        serial.printf("!lb%c%c%c%c%c;", 4, x1, y1, x2, y2 );
      }else{
        //buf.append("!l");     // slow method .. so values > 255
        //buf.append( x1 );
        //buf.append("," );
        //buf.append( y1 );
        //buf.append("," );
        //buf.append( x2 );
        //buf.append("," );
        //buf.append( y2 );

        serial.printf("!l%d,%d,%d,%d;", x1, y1, x2, y2);
      }
      //buf.append(";" );
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }

  static void Plot(int x, int y)
  {
      //StringBuffer buf=new StringBuffer(16);

      //if (x < 0) x = 0;
      //if (y < 0) y = 0;

      //buf.clear();
      if (x >= 0 && x <= 255 && y >= 0 && y <= 255){
         //buf.append("!pb");       // fast method .. so values <= 255
         //buf.append((char) 2  );  // write 2 bytes
         //buf.append((char) x  );
         //buf.append((char) y  );

         serial.printf("!pb%c%c%c;", 2, x, y);
      }else{
         //buf.append("!p");        // slow method .. so values > 255
         //buf.append( x  );
         //buf.append("," );
         //buf.append( y  );

         serial.printf("!p%d,%d;", x, y);
      }
      //buf.append(";" );
      //System.out.print(buf.toString());

      //CPU.delay(1);         // ??
  }


  static void DrawGrid(int a, int b, int c, int d, int e, int f)
  {
      //StringBuffer buf=new StringBuffer(36);

      //buf.clear();
      //buf.append("!ab");        // fast binary method
      //buf.append((char) 6  );   // write 6 bytes
      //buf.append((char) a  );   // xspace
      //buf.append((char) b  );   // yspace
      //buf.append((char) c  );   // xlines
      //buf.append((char) d  );   // ylines
      //buf.append((char) e  );   // xoffset
      //buf.append((char) f  );   // yoffset
      //buf.append(";" );
      //System.out.print(buf.toString());

      serial.printf("!ab%c%c%c%c%c%c%c;", 6, a, b, c, d, e, f );

      //CPU.delay(1);         // ??
  }

  static void ClearScreen()
  {
      serial.printf("!c;");
  }

  // shortcut:     Cmd("!c;");  or Cmd("?O;");

  static void Cmd(char *p)
  {
      serial.printf(p);
  }

  // for "!nSpeech;" or "!Llog file;"

  static void CmdStr(char cmd, char *p  )
  {
       //buf.clear();
       //buf.append("!");
       //buf.append( cmd  );
       //buf.append( p    );
       //buf.append(";" );
       //System.out.print(buf.toString());

       serial.printf("!%c%s;", cmd, p);
  }

  // cmd with no argument so  Cmd0('s');  = "!s;"

  static void Cmd0(char cmd  )
  {
       //buf.clear();
       //buf.append("!");
       //buf.append( cmd  );
       //buf.append(";" );
       //System.out.print(buf.toString());

       serial.printf("!%c;", cmd);
  }

  // request with no arguments
  // Req0( 'm' );  =  "?m;"

  static void Req0(char req  )
  {
       //buf.clear();
       //buf.append("?");
       //buf.append( req  );
       //buf.append(";" );
       //System.out.print(buf.toString());

       serial.printf("?%c;", req );
  }

  // cmd with 1 arg   Cmd1('a' , 1 );  =  "!a1;"

  static void Cmd1(char cmd, int arg1 )
  {
     //buf.clear();
     //buf.append("!");
     //buf.append( cmd  );
     if (arg1 < 256){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 1  );  // 1 argument
       //buf.append((char) arg1 );

       serial.printf("!%cb%c%c;", cmd, 1, arg1 );
     }else{
       //buf.append( arg1 );       // slow ascii mode

       serial.printf("!%c%d;", cmd, arg1 );
    }
    //buf.append(";" );
    //System.out.print(buf.toString());
  }

  // cmd with 2 args    Cmd2('G', 20, 1);  = "!G20,1;"
  // plot = Cmd2( 'p', x, y );

  static void Cmd2(char cmd, int arg1, int arg2 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 2  );  // 2 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );

       serial.printf("!%cb%c%c%c;", cmd, 2, arg1, arg2 );
     }else{
       //buf.append( arg1 );        // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
 
       serial.printf("!%c%d,%d;", cmd, arg1, arg2 );
     }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // cmd with 3 args
  // setcolor = Cmd3( 's', r, g, b );

  static void Cmd3(char cmd, int arg1, int arg2, int arg3 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255 && arg3 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 3  );  // 3 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );
       //buf.append((char) arg3 );

       serial.printf("!%cb%c%c%c%c;", cmd, 3, arg1, arg2, arg3 );
    }else{
       //buf.append( arg1 );     // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
       //buf.append(","   );
       //buf.append( arg3 );

       serial.printf("!%c%d,%d,%d;", cmd, arg1, arg2, arg3 );
     }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // cmd with 4 args
  // line = Cmd4( 'l', x1, y1, x2, y2);

  static void Cmd4(char cmd, int arg1, int arg2, int arg3, int arg4 )
  {
    //buf.clear();
    //buf.append("!"   );       // !
    //buf.append( cmd  );
    if (arg1 < 255 && arg2 < 255 && arg3 < 255 && arg4 < 255){
       //buf.append( 'b'  );      // binary mode
       //buf.append((char) 4  );  // 4 arguments
       //buf.append((char) arg1 );
       //buf.append((char) arg2 );
       //buf.append((char) arg3 );
       //buf.append((char) arg4 );

       serial.printf("!%cb%c%c%c%c%c;", cmd, 4, arg1, arg2, arg3, arg4 );
    }else{
       //buf.append( arg1 );    // slow ascii mode
       //buf.append(","   );
       //buf.append( arg2 );
       //buf.append(","   );
       //buf.append( arg3 );
       //buf.append(","   );
       //buf.append( arg4 );
 
       serial.printf("!%c%d,%d,%d,%d;", cmd, arg1, arg2, arg3, arg4 );
    }
     //buf.append(";"   );
     //System.out.print(buf.toString());
  }

  // play video, mp3 or picture

  static void Media(char *p)
  {
       //buf.clear();
       //buf.append("!V");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
  
       serial.printf("!V%s;", p);
  }

  static void Speech(char *p)
  {
       //buf.clear();
       //buf.append("!n");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
 
       serial.printf("!n%s;", p);
  }

  static void Log(char *p)
  {
       //buf.clear();
       //buf.append("!L");
       //buf.append( p );
       //buf.append(";" );
       //System.out.print(buf.toString());
  
       serial.printf("!L%s;", p);
 }

 static void ScrollLeft()
 {
     serial.printf("!G20,1;");
  }

/*
  static void DrawGrid(int a, int b, int c, int d, int e, int f)
  {
      //StringBuffer buf=new StringBuffer(36);

      //buf.clear();
      //buf.append("!ab");        // fast binary method
      //buf.append((char) 6  );   // write 6 bytes
      //buf.append((char) a  );   // xspace
      //buf.append((char) b  );   // yspace
      //buf.append((char) c  );   // xlines
      //buf.append((char) d  );   // ylines
      //buf.append((char) e  );   // xoffset
      //buf.append((char) f  );   // yoffset
      //buf.append(";" );

      //System.out.print(buf.toString());

      serial.printf("!ab%c%c%c%c%c%c%c;", 6, a, b, c, d, e, f );

      //CPU.delay(1);         // ??
  }
*/

  /*
  static void initpins() {
    // OUTPUT dischargecap     'capacitor reset   p 15
    // LOW    dischargecap     'disable           p 15

    // OUTPUT chargecap        'capacitor charge  p 14
    // HIGH   chargecap        'disable           p 14

    // INPUT  chanblow      'channel b    p 12
    // INPUT  chanalow      'channel a    p 13
    // INPUT  chanbhigh     'channel b high  p 10
    // INPUT  chanahigh     'channel a high  p 11

    CPU.setInput (CPU.pins[10]);    // chan b high opamp
    CPU.setInput (CPU.pins[11]);    // chan a high opamp
    CPU.setInput (CPU.pins[12]);    // chan b low opamp
    CPU.setInput (CPU.pins[13]);    // chan a low opamp

    CPU.setOutput(CPU.pins[14]);    // charge cap pin
    CPU.setOutput(CPU.pins[15]);    // discarge cap pin

    CPU.writePin (CPU.pins[15] ,  false );
    CPU.writePin (CPU.pins[14] ,  true  );
  }


  // interface with ltc1298 chip

  // static int gEnablePin;        // speedup ?
  // static int gClockPin;
  // static int gDataPin;

  static void initadc(int dataPin, int clockPin, int enablePin){

    //gEnablePin =  CPU.pins[enablePin];   // speedup ?
    //gClockPin  =  CPU.pins[clockPin];
    //gDataPin   =  CPU.pins[dataPin];

    CPU.writePin(CPU.pins[enablePin],false);          // init the bus
    CPU.writePin(CPU.pins[clockPin ],false);
    CPU.delay(100);                         // settle down
    CPU.writePin(CPU.pins[enablePin],false);
    CPU.writePin(CPU.pins[enablePin],true );

    //CPU.writePin(CPU.pins[dataPin  ],false );     // test
    //Serial.print(CPU.pins[ 1 ]);      // just adds one ?
  }

  static int readadc(int dataPin, int clockPin, int enablePin, int channel, int 

mode){

     int command, readSize;
     int clockIn;

     if (channel == 0)  command = 0x1a;      // %11010  read ch0  (pin2)
     else               command = 0x1e;      // %11110  read ch1  (pin3)

     readSize   = 12;                        // Bytes to Read on the LTC1298
     //resolution = 4096;                    // Range of the LTC1298
     //clockIn    = 1000;

     CPU.writePin(CPU.pins[enablePin],false);
     // set port
     CPU.shiftOut(CPU.pins[dataPin],CPU.pins[clockPin],5,CPU.SHIFT_MSB,(command << 

11));
     // read the value
     clockIn = 

CPU.shiftIn(CPU.pins[dataPin],CPU.pins[clockPin],readSize,CPU.PRE_CLOCK_MSB);
     CPU.writePin(CPU.pins[enablePin],true);

     //CPU.delay(100);
     //CPU.writePin(CPU.pins[dataPin],false ); // test
     //CPU.setInput(dataPin);


     if (mode == 0){           // low
        clockIn = clockIn - (2048-128);
     }else{
        if (mode == 1){         // high
         //clockIn = clockIn / 16;   //  make 8 bits from 12
           clockIn = clockIn >> 4;   //  make 8 bits from 12
        }else{                         // gnd
           clockIn = 128;
        }
     }

     //  Serial.print("v:");
     //  Serial.print(channel);
     //  Serial.print(",");
     //  Serial.print(clockIn);
     //  Serial.println("");

     return clockIn;
  }
  */


  /*
  static int measure(int channel, int mode) {
    int e, time;

    if (channel == 0){  // chan a
       if (mode == 0){
          e = 13;       // a low
       }else{
          if (mode == 1){
             e = 11;       // a high
          }else{
             return 128;   // gnd
          }
       }
    }else{   // chan b
       if (mode == 0){
          e = 12;       // b low
       }else{
          if (mode == 1){
             e = 10;       // b high
          }else{
             return 128;   // gnd
          }
       }
    }

    // PULSOUT dischargecap, 10     '2uS units   ->  20uS

    //CPU.writePin(CPU.pins[15] ,  1 );    // discharge cap
    //CPU.delay( 1 );
    //CPU.writePin(CPU.pins[15] ,  0 );
    CPU.pulseOut(2, CPU.pins[15] );   //     2 x 8.7 = 17 uS

    // LOW    chargecap    'start charge
    // RCTIME chanahigh, 0 , val         'PULSIN
    // HIGH   chargecap   'stop charge

    CPU.writePin(CPU.pins[14] ,  false );
    time = CPU.rcTime( 1000 ,CPU.pins[ e ], true );  //  8.68 uS units    (0-200uS)
    CPU.writePin(CPU.pins[14] ,  true  );

    //CPU.readPin(  CPU.pins[e]);    // switch back to input
    time = time << 3;    // resolution 8 times lower as basic stamp

    return time;
  }
 */


#define boolean int

  // ChanXMode    '0=off, 1=low, 2=high, 3=gnd ?
 //  Mode          '0=scope,  1=XY,  2=record   (3=off ?)

int main() {
   boolean ready;    // Bit
   int   x, s, cnt = 0, ptr, speed = 0;     // Byte
   int   x1, y1, x2, y2, ecnt = 0;
   int mem[10];   //  int    [] mem;

   //StringBuffer serbuf = new StringBuffer(80);

   //mem      = new int [10];

   InitStampdock();

   serial.printf("demo running .. \r\n");



   for (cnt = 0; cnt < 100; cnt++){
      SetValue(cnt, 0);
   }

   Cmd("!j0,250,0,0;");    // LED 0 to red
   Cmd("!j1,0,250,0;");    // LED 1 to green
   Cmd("!j2,0,0,250;");    // LED 2 to blue
   Cmd("!j3,4;");          // LED 3 to white

   Cmd4( 'j', 0, 250, 0, 0 );   // LED 0 to red

   SetColor(100,100,200);
   ClearScreen();            // clear graph

   SetColor(128,128,228);
   DrawGrid(20,20,29,19,55,12);

   SetColor(0,0,0);   // black
   for (cnt = 0; cnt < 20; cnt++){

      x1 = cnt * 10;
      y1 = 15;

      Plot(x1, y1);
   }

   for (cnt = 0; cnt < 20; cnt++){
      x1 = 10 * cnt;
      x2 = 15 * cnt;
      y1 = 20;
      y2 = 40;
      DrawLine(x1,y1,x2,y2);
   }

   Cmd("!f12;");      // set greyscale value 12
   Cmd("!r60,60,100,100;");    // draw rectangle

   Cmd("!h10,70;");     // set draw position to home or 10,70
   Cmd("!g50;");        // draw grey pixel and increase
   Cmd("!g100;");       // draw grey pixel and increase
   Cmd("!g150;");       // draw grey pixel and increase
   Cmd("!g200;");       // draw grey pixel and increase
   Cmd("!w10;");        // draw 10 white pixels and increase
   Cmd("!b10;");        // draw 10 black pixels and increase


   s = 80;
   //serbuf.clear();
   //serbuf.append("!Pb");        // poly line, binary mode
   //serbuf.append((char)33);     // 33 values follow
   //serbuf.append((char)20);     // dx=20
   //serbuf.append((char) 0);     // dy=0 .. so only y values
   //serbuf.append((char)60);     // x start
   //serbuf.append((char) s);     // y start

   serial.printf("!Pb%c%c%c%c%c", 33, 20, 0, 60, s );

   for (cnt = 0; cnt <= 28; cnt++){
      x = cnt * cnt;
      //serbuf.append((char) x  );    // y value of next line

      serial.printf("%c", x );
   }

   //serbuf.append(";");     // end poly line cmd
   //System.out.print(serbuf.toString());
   serial.printf(";");


   // do some file access

   Cmd("!Otempfile.txt;");    // open file for writing
   Cmd("!e12,24,48,96;");     // write some values
   Cmd("!O;");                // close file

   Cmd("?Otempfile.txt;");   // open file for reading
   ReadByte();
   ReadByte();
   ReadByte();
   s = ReadByte();    // read LSB size of file
   serial.printf("file is ");
   serial.printf( "%d", s );
   serial.printf(" bytes.\r\n");

   serial.printf("read values: ");
   for (cnt = 0; cnt < s; cnt++){
      Cmd("?e;");    // read a byte
      x = ReadByte();
      serial.printf( "%d", x );
      serial.printf(",");
   }
   serial.printf("\r\n");
   Cmd("?O;");    // close file
   ReadByte();


   serial.printf("ticks is: ");
   Cmd("?t0;");    // request ticks
   for (cnt = 0; cnt < 4; cnt++){
      mem[cnt] = (int) ReadByte();
   }
   for (cnt = 0; cnt < 4; cnt++){
      serial.printf( "%d", mem[cnt] );
      serial.printf(",");
   }
   serial.printf("\r\n");



   serial.printf("time: y2 y1 mon day hour min sec tic : ");
   Cmd("?t1;");    // request time
   for (cnt = 0; cnt < 8; cnt++){
      mem[cnt] = ReadByte();
   }
   for (cnt = 0; cnt < 8; cnt++){
      serial.printf( "%d", mem[cnt] );
      serial.printf(",");
   }
   serial.printf("\r\n");

   // for (cnt = 0; cnt < 50; cnt++)
   // Cmd2( 'G', 20, 1 );          // do "!G20,1;"


   Cmd("!nThis is a speech test.;");

   Cmd("!LThis is a log file test;");

   Cmd("!Vmedia/video.mpg;");
   wait( 1.1 ); // CPU.delay(1000);
   Cmd("!Vmedia/sound.mp3;");
   wait (1.1); // CPU.delay(1000);
   Cmd("!Vmedia/pic.jpg;");

   while (true){
      if (ecnt == 2){        // test speed up
         x = GetEvent();
         ecnt = 0;
      }else{
         ecnt++;
         x = 0;
      }

      if (x != 0){      // do we have a gui click or event ?
        ecnt = 0;            // just had an event, so max wait
        s = GetValue(x);     // get value of gui element x

        // now handle GUI element x with value/state s
        if (x == 1){
           //mode = s;
           // clear graph
           //'DEBUG "!s100,100,200;!c;"    'set blue color , clear screen    17c
           //DEBUG "!sb",3, 100,100,200, ";!c;"     'fast binary way to set color  


           //serial.printf("!s100,100,200;!c;");
           SetColor(100,100,200);
           ClearScreen();
        } else

        if (x == 10){     // checkmark 0
           SetValue(12, s);    // set checkmark 2
        } else
        if (x == 11){     // checkmark 1
           SetValue(13, s);    // set checkmark 3
        } else

        if (x == 20){     // hor switch 0
           SetValue(21, s);    // set hor switch 1
        } else
         if (x == 21){     // hor switch1
           SetValue(20, s);    // set hor switch 0
        } else

        if (x == 40){     // hor potm 0
           SetValue(41, s);    // hor potm 1
           SetValue(60, s);    // set analog meter
        } else
        if (x == 41){     // hor potm 1
           SetValue(40, s);    // hor potm 0
           SetValue(61, s);    // set analog meter
        } else

         if (x == 100){     // turn knob 0
           SetValue(101, s);    // turn knob 1
        } else
        if (x == 101){     // turn knob 1
           SetValue(100, s);    // turn knob 0
        } else

        if (x == 90){     // button 1
           ScrollLeft();    // scroll left 1 pixel
        }


       }  // if event

       wait(0.1);   // CPU.delay(100);

       // do ..


   }   // end while true
 }       // end main




 //}  // class demo