#include "mbed.h"
#include "platform/mbed_thread.h"
#include "RPinName.h"

// Blinking rate in milliseconds
#define loopdelay    1000
#define betweenleds 500
 // Initialise the digital pins for LEDs as an output
    DigitalOut ledg(led1);  // WiFi or same as LED1
    DigitalOut ledb(led2);  // Azure
    DigitalOut ledy(led3);  // User
    
    InterruptIn ButtonA(Key2);
    InterruptIn ButtonB(Key3);
    
    // Initialise the pulse-width-moudulation for RGB LED
    PwmOut RGBR(RedRGB);
    PwmOut RGBG(GreenRGB);
    PwmOut RGBB(BlueRGB);
    
    Serial AZ(tx, rx); // tx, rx
    
    void ToggleGreen()
    {
        ledg = !ledg;
        }
    void ToggleBlue()
    {
        ledb = !ledb;
        }

int main()
{
    //ButtonA.rise(&ToggleGreen);
    //ButtonB.rise(&ToggleBlue);
    ButtonA.mode(PullUp);
    ButtonA.fall(&ToggleGreen);
    ButtonB.mode(PullUp);
    ButtonB.fall(&ToggleBlue);
    
    while(1) {
        
        AZ.printf("Hi There from Appa\r\n");
        RGBR = 0;
        AZ.printf("Random Green RGB LED\r\n");
        RGBG = rand() % 100;
        thread_sleep_for(betweenleds);
        RGBG = 0;
        AZ.printf("Random Blue RGB LED\r\n");
        RGBB = rand() % 100;
        thread_sleep_for(betweenleds);
        RGBB = 0;
        AZ.printf("Random Red RGB LED\r\n");
        RGBR = rand() % 100;
        thread_sleep_for(loopdelay);
    }
}