#include "mbed.h"
#include "platform/mbed_thread.h"
#include "RPinName.h"

// Blinking rate in milliseconds
#define loopdelay    1000
#define betweenleds 500


int main()
{

    // Initialise the digital pins for LEDs as an output
    DigitalOut ledg(led1);  // WiFi or same as LED1
    DigitalOut ledb(led2);  // Azure
    DigitalOut ledy(led3);  // User
    
    // Initialise the pulse-width-moudulation for RGB LED
    PwmOut RGBR(RedRGB);
    PwmOut RGBG(GreenRGB);
    PwmOut RGBB(BlueRGB);
    
    Serial AZ(tx, rx); // tx, rx
    
    while (true) {
        AZ.printf("Hi There from Appa\r\n");
        
        RGBR = 0;
        AZ.printf("Random Green RGB LED\r\n");
        RGBG = rand() % 100;
        AZ.printf("Not Green LED\r\n");
        ledg = !ledg;
        thread_sleep_for(betweenleds);
        RGBG = 0;
        AZ.printf("Random Blue RGB LED\r\n");
        RGBB = rand() % 100;
        AZ.printf("Not Blue LED\r\n");
        ledb = !ledb;
        thread_sleep_for(betweenleds);
        RGBB = 0;
        AZ.printf("Random Red RGB LED\r\n");
        RGBR = rand() % 100;
        AZ.printf("Not Red LED\r\n");
        ledy = !ledy;
        thread_sleep_for(loopdelay);
    }
}