#include "mbed.h"
#include "platform/mbed_thread.h"
#include "RPinName.h"

// Blinking rate in milliseconds
#define loopdelay    1000
#define betweenleds 500


int main()
{

    // Initialise the digital pins for LEDs as an output
    DigitalOut ledg(led1);  // WiFi or same as LED1
    DigitalOut ledb(led2);  // Azure
    DigitalOut ledy(led3);  // User
    
    DigitalIn PushButtonA(Key2);
    DigitalIn PushButtonB(Key3);
    
    // Initialise the pulse-width-moudulation for RGB LED
    PwmOut RGBR(RedRGB);
    PwmOut RGBG(GreenRGB);
    PwmOut RGBB(BlueRGB);
    
    Serial AZ(tx, rx); // tx, rx
    
    PushButtonA.mode(PullUp);
    PushButtonB.mode(PullUp);
    
    while(1) {
        ledg = !PushButtonA;
        ledb = !PushButtonB;
    }
}